/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.metrics;

import com.netflix.netty.common.HttpLifecycleChannelHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.AttributeKey;
import javax.inject.Provider;

public class HttpBodySizeRecordingChannelHandler
extends CombinedChannelDuplexHandler {
    private static final AttributeKey<State> ATTR_STATE = AttributeKey.newInstance((String)"_http_body_size_state");

    public HttpBodySizeRecordingChannelHandler() {
        super((ChannelInboundHandler)new InboundChannelHandler(), (ChannelOutboundHandler)new OutboundChannelHandler());
    }

    public static Provider<Long> getCurrentInboundBodySize(Channel ch) {
        return new InboundBodySizeProvider(ch);
    }

    public static Provider<Long> getCurrentOutboundBodySize(Channel ch) {
        return new OutboundBodySizeProvider(ch);
    }

    private static State getOrCreateCurrentState(Channel ch) {
        State state = (State)ch.attr(ATTR_STATE).get();
        if (state == null) {
            state = HttpBodySizeRecordingChannelHandler.createNewState(ch);
        }
        return state;
    }

    private static State createNewState(Channel ch) {
        State state = new State();
        ch.attr(ATTR_STATE).set((Object)state);
        return state;
    }

    static class OutboundBodySizeProvider
    implements Provider<Long> {
        private final Channel channel;

        public OutboundBodySizeProvider(Channel channel) {
            this.channel = channel;
        }

        public Long get() {
            State state = HttpBodySizeRecordingChannelHandler.getOrCreateCurrentState(this.channel);
            return state == null ? 0L : state.outboundBodySize;
        }
    }

    static class InboundBodySizeProvider
    implements Provider<Long> {
        private final Channel channel;

        public InboundBodySizeProvider(Channel channel) {
            this.channel = channel;
        }

        public Long get() {
            State state = HttpBodySizeRecordingChannelHandler.getOrCreateCurrentState(this.channel);
            return state == null ? 0L : state.inboundBodySize;
        }
    }

    private static class State {
        long inboundBodySize = 0L;
        long outboundBodySize = 0L;

        private State() {
        }
    }

    private static class OutboundChannelHandler
    extends ChannelOutboundHandlerAdapter {
        private OutboundChannelHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            State state = null;
            if (msg instanceof HttpRequest) {
                state = HttpBodySizeRecordingChannelHandler.createNewState(ctx.channel());
            }
            if (msg instanceof HttpContent) {
                if (state == null) {
                    state = HttpBodySizeRecordingChannelHandler.getOrCreateCurrentState(ctx.channel());
                }
                state.outboundBodySize += (long)((HttpContent)msg).content().readableBytes();
            }
            super.write(ctx, msg, promise);
        }
    }

    private static class InboundChannelHandler
    extends ChannelInboundHandlerAdapter {
        private InboundChannelHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            State state = null;
            if (msg instanceof HttpRequest) {
                state = HttpBodySizeRecordingChannelHandler.createNewState(ctx.channel());
            }
            if (msg instanceof HttpContent) {
                if (state == null) {
                    state = HttpBodySizeRecordingChannelHandler.getOrCreateCurrentState(ctx.channel());
                }
                state.inboundBodySize += (long)((HttpContent)msg).content().readableBytes();
            }
            super.channelRead(ctx, msg);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            try {
                super.userEventTriggered(ctx, evt);
            }
            finally {
                if (evt instanceof HttpLifecycleChannelHandler.CompleteEvent) {
                    ctx.channel().attr(ATTR_STATE).set(null);
                }
            }
        }
    }
}

