/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.metrics;

import com.netflix.netty.common.metrics.EventLoopGroupMetrics;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import java.util.concurrent.atomic.AtomicInteger;

public class EventLoopMetrics
implements EventLoopGroupMetrics.EventLoopInfo {
    private final String name;
    public final AtomicInteger currentRequests = new AtomicInteger(0);
    public final AtomicInteger currentConnections = new AtomicInteger(0);
    private final Registry registry;
    private final Id currentRequestsId;
    private final Id currentConnectionsId;

    public EventLoopMetrics(Registry registry, String eventLoopName) {
        this.name = eventLoopName;
        this.registry = registry;
        this.currentRequestsId = this.registry.createId("server.eventloop.http.requests.current");
        this.currentConnectionsId = this.registry.createId("server.eventloop.connections.current");
    }

    @Override
    public int currentConnectionsCount() {
        return this.currentConnections.get();
    }

    @Override
    public int currentHttpRequestsCount() {
        return this.currentRequests.get();
    }

    public void incrementCurrentRequests() {
        int value = this.currentRequests.incrementAndGet();
        this.updateGauge(this.currentRequestsId, value);
    }

    public void decrementCurrentRequests() {
        int value = this.currentRequests.decrementAndGet();
        this.updateGauge(this.currentRequestsId, value);
    }

    public void incrementCurrentConnections() {
        int value = this.currentConnections.incrementAndGet();
        this.updateGauge(this.currentConnectionsId, value);
    }

    public void decrementCurrentConnections() {
        int value = this.currentConnections.decrementAndGet();
        this.updateGauge(this.currentConnectionsId, value);
    }

    private void updateGauge(Id gaugeId, int value) {
        this.registry.gauge(gaugeId.withTag("eventloop", this.name)).set((double)value);
    }
}

