/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.util;

import org.junit.Assert;
import org.junit.Test;

public class VipUtils {
    public static String getVIPPrefix(String vipAddress) {
        String vipHost = vipAddress.split(":")[0];
        return vipHost.split("\\.")[0];
    }

    public static String extractAppNameFromVIP(String vipAddress) {
        String vipPrefix = VipUtils.getVIPPrefix(vipAddress);
        return vipPrefix.split("-")[0];
    }

    public static class UnitTest {
        @Test(expected=NullPointerException.class)
        public void testGetVIPPrefix() {
            Assert.assertEquals((Object)"api-test", (Object)VipUtils.getVIPPrefix("api-test.netflix.net:7001"));
            Assert.assertEquals((Object)"api-test", (Object)VipUtils.getVIPPrefix("api-test.netflix.net"));
            Assert.assertEquals((Object)"api-test", (Object)VipUtils.getVIPPrefix("api-test:7001"));
            Assert.assertEquals((Object)"api-test", (Object)VipUtils.getVIPPrefix("api-test"));
            Assert.assertEquals((Object)"", (Object)VipUtils.getVIPPrefix(""));
            VipUtils.getVIPPrefix(null);
        }

        @Test(expected=NullPointerException.class)
        public void testExtractAppNameFromVIP() {
            Assert.assertEquals((Object)"api", (Object)VipUtils.extractAppNameFromVIP("api-test.netflix.net:7001"));
            Assert.assertEquals((Object)"api", (Object)VipUtils.extractAppNameFromVIP("api-test-blah.netflix.net:7001"));
            Assert.assertEquals((Object)"api", (Object)VipUtils.extractAppNameFromVIP("api"));
            Assert.assertEquals((Object)"", (Object)VipUtils.extractAppNameFromVIP(""));
            VipUtils.extractAppNameFromVIP(null);
        }
    }
}

