/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.plugins;

import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.InjectableTag;
import com.netflix.zuul.monitoring.CounterFactory;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Counter
extends CounterFactory {
    static final ConcurrentMap<String, BasicCounter> map = new ConcurrentHashMap<String, BasicCounter>();
    final Object lock = new Object();

    @Override
    public void increment(String name) {
        BasicCounter counter = this.getCounter(name);
        counter.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicCounter getCounter(String name) {
        BasicCounter counter = (BasicCounter)map.get(name);
        if (counter == null) {
            Object object = this.lock;
            synchronized (object) {
                counter = (BasicCounter)map.get(name);
                if (counter != null) {
                    return counter;
                }
                ArrayList<InjectableTag> tags = new ArrayList<InjectableTag>(2);
                tags.add(InjectableTag.HOSTNAME);
                tags.add(InjectableTag.IP);
                counter = new BasicCounter(MonitorConfig.builder((String)name).withTags(tags).build());
                map.putIfAbsent(name, counter);
                DefaultMonitorRegistry.getInstance().register((Monitor)counter);
            }
        }
        return counter;
    }
}

