/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.origins;

import com.netflix.spectator.api.Registry;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.origins.BasicNettyOrigin;
import com.netflix.zuul.origins.OriginManager;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BasicNettyOriginManager
implements OriginManager<BasicNettyOrigin> {
    private final Registry registry;
    private final ConcurrentHashMap<String, BasicNettyOrigin> originMappings;

    @Inject
    public BasicNettyOriginManager(Registry registry) {
        this.registry = registry;
        this.originMappings = new ConcurrentHashMap();
    }

    @Override
    public BasicNettyOrigin getOrigin(String name, String vip, String uri, SessionContext ctx) {
        return this.originMappings.computeIfAbsent(name, n -> this.createOrigin(name, vip, uri, false, ctx));
    }

    @Override
    public BasicNettyOrigin createOrigin(String name, String vip, String uri, boolean useFullVipName, SessionContext ctx) {
        return new BasicNettyOrigin(name, vip, this.registry);
    }
}

