/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.niws;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import com.netflix.zuul.exception.OutboundException;
import com.netflix.zuul.netty.connectionpool.OriginConnectException;
import io.netty.handler.timeout.ReadTimeoutException;

public class RequestAttempt {
    private static final ObjectMapper JACKSON_MAPPER = new ObjectMapper();
    private int attempt;
    private int status;
    private long duration;
    private String error;
    private String exceptionType;
    private String app;
    private String asg;
    private String instanceId;
    private String host;
    private int port;
    private String vip;
    private String region;
    private String availabilityZone;
    private int readTimeout;
    private int connectTimeout;
    private int maxRetries;

    public RequestAttempt(int attemptNumber, InstanceInfo server, String targetVip, String chosenWarmupLB, int status, String error, String exceptionType, int readTimeout, int connectTimeout, int maxRetries) {
        if (attemptNumber < 1) {
            throw new IllegalArgumentException("Attempt number must be greater than 0! - " + attemptNumber);
        }
        this.attempt = attemptNumber;
        this.vip = targetVip;
        if (server != null) {
            this.app = server.getAppName().toLowerCase();
            this.asg = server.getASGName();
            this.instanceId = server.getInstanceId();
            this.host = server.getHostName();
            this.port = server.getPort();
            if (targetVip == null) {
                this.vip = server.getVIPAddress();
            }
            if (server.getDataCenterInfo() instanceof AmazonInfo) {
                this.availabilityZone = (String)((AmazonInfo)server.getDataCenterInfo()).getMetadata().get("availability-zone");
                String az = this.getAvailabilityZone();
                if (az != null && az.length() > 0) {
                    this.region = az.substring(0, az.length() - 1);
                }
            }
        }
        this.status = status;
        this.error = error;
        this.exceptionType = exceptionType;
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        this.maxRetries = maxRetries;
    }

    public RequestAttempt(Server server, IClientConfig clientConfig, int attemptNumber, int readTimeout) {
        this.status = -1;
        this.attempt = attemptNumber;
        this.readTimeout = readTimeout;
        if (server != null) {
            this.host = server.getHost();
            this.port = server.getPort();
            this.availabilityZone = server.getZone();
            if (server instanceof DiscoveryEnabledServer) {
                InstanceInfo instanceInfo = ((DiscoveryEnabledServer)server).getInstanceInfo();
                this.app = instanceInfo.getAppName().toLowerCase();
                this.asg = instanceInfo.getASGName();
                this.instanceId = instanceInfo.getInstanceId();
                this.host = instanceInfo.getHostName();
                this.port = instanceInfo.getPort();
                this.vip = server.getPort() == instanceInfo.getSecurePort() ? instanceInfo.getSecureVipAddress() : instanceInfo.getVIPAddress();
                if (instanceInfo.getDataCenterInfo() instanceof AmazonInfo) {
                    this.availabilityZone = (String)((AmazonInfo)instanceInfo.getDataCenterInfo()).getMetadata().get("availability-zone");
                }
            } else {
                Server.MetaInfo metaInfo = server.getMetaInfo();
                if (metaInfo != null) {
                    this.asg = metaInfo.getServerGroup();
                    this.vip = metaInfo.getServiceIdForDiscovery();
                    this.instanceId = metaInfo.getInstanceId();
                }
            }
            if (this.availabilityZone != null && this.availabilityZone.length() > 0) {
                this.region = this.availabilityZone.substring(0, this.availabilityZone.length() - 1);
            }
        }
        if (clientConfig != null) {
            this.connectTimeout = (Integer)clientConfig.get(IClientConfigKey.Keys.ConnectTimeout);
        }
    }

    private RequestAttempt() {
    }

    public void complete(int responseStatus, long durationMs, Throwable exception) {
        if (responseStatus > -1) {
            this.setStatus(responseStatus);
        }
        this.duration = durationMs;
        if (exception != null) {
            this.setException(exception);
        }
    }

    public int getAttempt() {
        return this.attempt;
    }

    public String getVip() {
        return this.vip;
    }

    public int getStatus() {
        return this.status;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getError() {
        return this.error;
    }

    public String getApp() {
        return this.app;
    }

    public String getAsg() {
        return this.asg;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setAsg(String asg) {
        this.asg = asg;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setVip(String vip) {
        this.vip = vip;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setException(Throwable t) {
        if (t != null) {
            if (t instanceof ReadTimeoutException) {
                this.error = "READ_TIMEOUT";
                this.exceptionType = t.getClass().getSimpleName();
            } else if (t instanceof OriginConnectException) {
                OriginConnectException oce = (OriginConnectException)t;
                this.error = oce.getErrorType() != null ? oce.getErrorType().toString() : "ORIGIN_CONNECT_ERROR";
                Throwable cause = t.getCause();
                this.exceptionType = cause != null ? t.getCause().getClass().getSimpleName() : t.getClass().getSimpleName();
            } else if (t instanceof OutboundException) {
                OutboundException obe = (OutboundException)t;
                this.error = obe.getOutboundErrorType().toString();
                this.exceptionType = OutboundException.class.getSimpleName();
            } else {
                this.error = t.getMessage();
                this.exceptionType = t.getClass().getSimpleName();
            }
        }
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public String toString() {
        try {
            return JACKSON_MAPPER.writeValueAsString((Object)this.toJsonNode());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error serializing RequestAttempt!", e);
        }
    }

    public ObjectNode toJsonNode() {
        ObjectNode root = JACKSON_MAPPER.createObjectNode();
        root.put("status", this.status);
        root.put("duration", this.duration);
        root.put("attempt", this.attempt);
        RequestAttempt.putNullableAttribute(root, "error", this.error);
        RequestAttempt.putNullableAttribute(root, "exceptionType", this.exceptionType);
        RequestAttempt.putNullableAttribute(root, "region", this.region);
        RequestAttempt.putNullableAttribute(root, "asg", this.asg);
        RequestAttempt.putNullableAttribute(root, "instanceId", this.instanceId);
        RequestAttempt.putNullableAttribute(root, "vip", this.vip);
        if (this.status < 1) {
            root.put("readTimeout", this.readTimeout);
            root.put("connectTimeout", this.connectTimeout);
        }
        return root;
    }

    private static ObjectNode putNullableAttribute(ObjectNode node, String name, String value) {
        if (value != null) {
            node.put(name, value);
        }
        return node;
    }
}

