/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.ssl;

import com.netflix.netty.common.SourceAddressChannelHandler;
import com.netflix.netty.common.ssl.SslHandshakeInfo;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.netty.ChannelUtils;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.AttributeKey;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslHandshakeInfoHandler
extends ChannelInboundHandlerAdapter {
    public static final AttributeKey<SslHandshakeInfo> ATTR_SSL_INFO = AttributeKey.newInstance((String)"_ssl_handshake_info");
    private static final Logger LOG = LoggerFactory.getLogger(SslHandshakeInfoHandler.class);
    private final Registry spectatorRegistry;
    private final boolean isSSlFromIntermediary;

    public SslHandshakeInfoHandler(Registry spectatorRegistry, boolean isSSlFromIntermediary) {
        this.spectatorRegistry = spectatorRegistry;
        this.isSSlFromIntermediary = isSSlFromIntermediary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            try {
                sslEvent = (SslHandshakeCompletionEvent)evt;
                if (sslEvent.isSuccess()) {
                    CurrentPassport.fromChannel(ctx.channel()).add(PassportState.SERVER_CH_SSL_HANDSHAKE_COMPLETE);
                    sslhandler = (SslHandler)ctx.channel().pipeline().get("ssl");
                    session = sslhandler.engine().getSession();
                    clientAuth = this.whichClientAuthEnum(sslhandler);
                    serverCert = null;
                    peerCert = null;
                    if ((clientAuth == ClientAuth.REQUIRE || clientAuth == ClientAuth.OPTIONAL) && session.getPeerCertificateChain() != null && session.getPeerCertificateChain().length > 0) {
                        peerCert = session.getPeerCertificateChain()[0];
                    }
                    if (session.getLocalCertificates() != null && session.getLocalCertificates().length > 0) {
                        serverCert = session.getLocalCertificates()[0];
                    }
                    info = new SslHandshakeInfo(this.isSSlFromIntermediary, session.getProtocol(), session.getCipherSuite(), clientAuth, serverCert, peerCert);
                    ctx.channel().attr(SslHandshakeInfoHandler.ATTR_SSL_INFO).set((Object)info);
                    this.incrementCounters(sslEvent, info);
                    if (SslHandshakeInfoHandler.LOG.isDebugEnabled()) {
                        SslHandshakeInfoHandler.LOG.debug("Successful SSL Handshake: " + String.valueOf(info));
                    }
                    if (!SslHandshakeInfoHandler.LOG.isInfoEnabled()) ** GOTO lbl49
                    SslHandshakeInfoHandler.LOG.info("Successful SSL Handshake: protocol={}, ciphersuite={}, has_client_cert={}", new Object[]{info.getProtocol(), info.getCipherSuite(), info.getClientCertificate() != null});
                }
                clientIP = (String)ctx.channel().attr(SourceAddressChannelHandler.ATTR_SOURCE_ADDRESS).get();
                cause = sslEvent.cause();
                passportState = CurrentPassport.fromChannel(ctx.channel()).getState();
                if (cause instanceof ClosedChannelException && (PassportState.SERVER_CH_INACTIVE.equals((Object)passportState) || PassportState.SERVER_CH_IDLE_TIMEOUT.equals((Object)passportState))) {
                    SslHandshakeInfoHandler.LOG.info("Client closed connection or it idle timed-out without doing an ssl handshake. , client_ip = " + String.valueOf(clientIP) + ", channel_info = " + ChannelUtils.channelInfoForLogging(ctx.channel()));
                }
                if (cause instanceof SSLException && "handshake timed out".equals(cause.getMessage())) {
                    SslHandshakeInfoHandler.LOG.info("Client timed-out doing the ssl handshake. , client_ip = " + String.valueOf(clientIP) + ", channel_info = " + ChannelUtils.channelInfoForLogging(ctx.channel()));
                }
                msg = "Unsuccessful SSL Handshake: " + String.valueOf(sslEvent) + ", client_ip = " + String.valueOf(clientIP) + ", channel_info = " + ChannelUtils.channelInfoForLogging(ctx.channel()) + ", error = " + String.valueOf(cause);
                if (cause != null && cause instanceof ClosedChannelException) {
                    SslHandshakeInfoHandler.LOG.warn(msg);
                } else {
                    SslHandshakeInfoHandler.LOG.warn(msg, cause);
                }
                this.incrementCounters(sslEvent, null);
            }
            catch (Throwable e) {
                SslHandshakeInfoHandler.LOG.warn("Error getting the SSL handshake info.", e);
            }
            finally {
                ctx.pipeline().remove((ChannelHandler)this);
            }
        } else if (evt instanceof SslCloseCompletionEvent) {
            // empty if block
        }
lbl49:
        // 10 sources

        super.userEventTriggered(ctx, evt);
    }

    private ClientAuth whichClientAuthEnum(SslHandler sslhandler) {
        ClientAuth clientAuth = sslhandler.engine().getNeedClientAuth() ? ClientAuth.REQUIRE : (sslhandler.engine().getWantClientAuth() ? ClientAuth.OPTIONAL : ClientAuth.NONE);
        return clientAuth;
    }

    private void incrementCounters(SslHandshakeCompletionEvent sslHandshakeCompletionEvent, SslHandshakeInfo handshakeInfo) {
        try {
            if (sslHandshakeCompletionEvent.isSuccess()) {
                String proto = handshakeInfo.getProtocol().length() > 0 ? handshakeInfo.getProtocol() : "unknown";
                String ciphsuite = handshakeInfo.getCipherSuite().length() > 0 ? handshakeInfo.getCipherSuite() : "unknown";
                this.spectatorRegistry.counter("server.ssl.handshake", new String[]{"success", String.valueOf(sslHandshakeCompletionEvent.isSuccess()), "protocol", String.valueOf(proto), "ciphersuite", String.valueOf(ciphsuite), "clientauth", String.valueOf(handshakeInfo.getClientAuthRequirement())}).increment();
            } else {
                this.spectatorRegistry.counter("server.ssl.handshake", new String[]{"success", String.valueOf(sslHandshakeCompletionEvent.isSuccess()), "failure_cause", String.valueOf(sslHandshakeCompletionEvent.cause())}).increment();
            }
        }
        catch (Exception e) {
            LOG.error("Error incrememting counters for SSL handshake!", (Throwable)e);
        }
    }
}

