/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.push;

import com.netflix.config.CachedDynamicBooleanProperty;
import com.netflix.config.CachedDynamicIntProperty;
import com.netflix.zuul.netty.server.push.PushConnection;
import com.netflix.zuul.netty.server.push.PushConnectionRegistry;
import com.netflix.zuul.netty.server.push.PushProtocol;
import com.netflix.zuul.netty.server.push.PushUserAuth;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushRegistrationHandler
extends ChannelInboundHandlerAdapter {
    protected final PushConnectionRegistry pushConnectionRegistry;
    protected final PushProtocol pushProtocol;
    private volatile PushUserAuth authEvent;
    protected final AtomicBoolean destroyed;
    private ChannelHandlerContext ctx;
    private volatile PushConnection pushConnection;
    private ScheduledFuture<?> keepAliveTask;
    public static final CachedDynamicIntProperty PUSH_REGISTRY_TTL = new CachedDynamicIntProperty("zuul.push.registry.ttl.seconds", 1800);
    public static final CachedDynamicIntProperty RECONNECT_DITHER = new CachedDynamicIntProperty("zuul.push.reconnect.dither.seconds", 180);
    public static final CachedDynamicIntProperty UNAUTHENTICATED_CONN_TTL = new CachedDynamicIntProperty("zuul.push.noauth.ttl.seconds", 8);
    public static final CachedDynamicIntProperty CLIENT_CLOSE_GRACE_PERIOD = new CachedDynamicIntProperty("zuul.push.client.close.grace.period", 4);
    public static final CachedDynamicBooleanProperty KEEP_ALIVE_ENABLED = new CachedDynamicBooleanProperty("zuul.push.keepalive.enabled", true);
    public static final CachedDynamicIntProperty KEEP_ALIVE_INTERVAL = new CachedDynamicIntProperty("zuul.push.keepalive.interval.seconds", 180);
    private static Logger logger = LoggerFactory.getLogger(PushRegistrationHandler.class);

    public PushRegistrationHandler(PushConnectionRegistry pushConnectionRegistry, PushProtocol pushProtocol) {
        this.pushConnectionRegistry = pushConnectionRegistry;
        this.pushProtocol = pushProtocol;
        this.destroyed = new AtomicBoolean();
    }

    protected final boolean isAuthenticated() {
        return this.authEvent != null && this.authEvent.isSuccess();
    }

    private void tearDown() {
        if (!this.destroyed.get()) {
            this.destroyed.set(true);
            if (this.authEvent != null) {
                this.pushConnectionRegistry.remove(this.authEvent.getClientIdentity());
                logger.debug("Closing connection for {}", (Object)this.authEvent);
            }
        }
        if (this.keepAliveTask != null) {
            this.keepAliveTask.cancel(false);
            this.keepAliveTask = null;
        }
    }

    public final void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.tearDown();
        super.channelInactive(ctx);
        ctx.close();
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error("Exception caught, closing push channel for " + this.authEvent, cause);
        ctx.close();
        super.exceptionCaught(ctx, cause);
    }

    protected final void forceCloseConnectionFromServerSide() {
        if (!this.destroyed.get()) {
            logger.debug("server forcing close connection");
            this.pushProtocol.sendErrorAndClose(this.ctx, 1000, "Server closed connection");
        }
    }

    private void closeIfNotAuthenticated() {
        if (!this.isAuthenticated()) {
            logger.error("Closing connection because it is still unauthenticated after {} seconds.", (Object)UNAUTHENTICATED_CONN_TTL.get());
            this.forceCloseConnectionFromServerSide();
        }
    }

    private void requestClientToCloseConnection() {
        if (this.ctx.channel().isActive()) {
            this.ctx.writeAndFlush(this.pushProtocol.goAwayMessage());
            this.ctx.executor().schedule(() -> this.forceCloseConnectionFromServerSide(), (long)CLIENT_CLOSE_GRACE_PERIOD.get(), TimeUnit.SECONDS);
        } else {
            this.forceCloseConnectionFromServerSide();
        }
    }

    protected void keepAlive() {
        if (KEEP_ALIVE_ENABLED.get()) {
            this.ctx.writeAndFlush((Object)new PingWebSocketFrame());
        }
    }

    private int ditheredReconnectDeadline() {
        int dither = ThreadLocalRandom.current().nextInt(RECONNECT_DITHER.get());
        return PUSH_REGISTRY_TTL.get() - dither - CLIENT_CLOSE_GRACE_PERIOD.get();
    }

    public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.ctx = ctx;
        if (!this.destroyed.get()) {
            if (evt == this.pushProtocol.getHandshakeCompleteEvent()) {
                this.pushConnection = new PushConnection(this.pushProtocol, ctx);
                ctx.executor().schedule(this::closeIfNotAuthenticated, (long)UNAUTHENTICATED_CONN_TTL.get(), TimeUnit.SECONDS);
                logger.debug("WebSocket handshake complete.");
            } else if (evt instanceof PushUserAuth) {
                this.authEvent = (PushUserAuth)evt;
                if (this.authEvent.isSuccess()) {
                    logger.debug("registering client {}", (Object)this.authEvent);
                    ctx.pipeline().remove("push_auth_handler");
                    this.registerClient(ctx, this.authEvent, this.pushConnection, this.pushConnectionRegistry);
                    logger.debug("Authentication complete {}", (Object)this.authEvent);
                } else {
                    this.pushProtocol.sendErrorAndClose(ctx, 1008, "Auth failed");
                }
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    protected void registerClient(ChannelHandlerContext ctx, PushUserAuth authEvent, PushConnection conn, PushConnectionRegistry registry) {
        registry.put(authEvent.getClientIdentity(), conn);
        ctx.executor().schedule(this::requestClientToCloseConnection, (long)this.ditheredReconnectDeadline(), TimeUnit.SECONDS);
        if (KEEP_ALIVE_ENABLED.get()) {
            this.keepAliveTask = ctx.executor().scheduleWithFixedDelay(this::keepAlive, (long)KEEP_ALIVE_INTERVAL.get(), (long)KEEP_ALIVE_INTERVAL.get(), TimeUnit.SECONDS);
        }
    }
}

