/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import com.netflix.config.DynamicIntProperty;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import java.lang.reflect.Field;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DirectMemoryMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(DirectMemoryMonitor.class);
    private static final String PROP_PREFIX = "zuul.directmemory";
    private static final DynamicIntProperty TASK_DELAY_PROP = new DynamicIntProperty("zuul.directmemory.task.delay", 10);
    private final LongGauge reservedMemoryGauge = new LongGauge(MonitorConfig.builder((String)"zuul.directmemory.reserved").build());
    private final LongGauge maxMemoryGauge = new LongGauge(MonitorConfig.builder((String)"zuul.directmemory.max").build());
    private final ScheduledExecutorService service = Executors.newScheduledThreadPool(1);

    public DirectMemoryMonitor() {
        DefaultMonitorRegistry.getInstance().register((Monitor)this.reservedMemoryGauge);
        DefaultMonitorRegistry.getInstance().register((Monitor)this.maxMemoryGauge);
    }

    @PostConstruct
    public void init() {
        this.service.scheduleWithFixedDelay(new Task(), TASK_DELAY_PROP.get(), TASK_DELAY_PROP.get(), TimeUnit.SECONDS);
    }

    public void stop() {
        this.service.shutdown();
    }

    class Current {
        Long maxMemory;
        Long reservedMemory;

        Current() {
        }
    }

    class Task
    implements Runnable {
        Task() {
        }

        @Override
        public void run() {
            try {
                Current current = this.measure();
                if (current != null) {
                    LOG.debug("reservedMemory={}, maxMemory={}", (Object)current.reservedMemory, (Object)current.maxMemory);
                    DirectMemoryMonitor.this.reservedMemoryGauge.set(current.reservedMemory);
                    DirectMemoryMonitor.this.maxMemoryGauge.set(current.maxMemory);
                }
            }
            catch (Throwable t) {
                LOG.warn("Error in DirectMemoryMonitor task.", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Current measure() {
            try {
                Class<?> c = Class.forName("io.netty.util.internal.PlatformDependent");
                Field maxMemory = c.getDeclaredField("DIRECT_MEMORY_LIMIT");
                maxMemory.setAccessible(true);
                Field reservedMemory = c.getDeclaredField("DIRECT_MEMORY_COUNTER");
                reservedMemory.setAccessible(true);
                Current current = new Current();
                Class<?> clazz = c;
                synchronized (clazz) {
                    current.maxMemory = this.getMemoryValue(maxMemory);
                    current.reservedMemory = this.getMemoryValue(reservedMemory);
                }
                return current;
            }
            catch (Exception e) {
                LOG.warn("Error measuring direct memory.", (Throwable)e);
                return null;
            }
        }

        private Long getMemoryValue(Field field) throws IllegalAccessException {
            Object value = field.get(null);
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof AtomicLong) {
                return ((AtomicLong)value).get();
            }
            return null;
        }
    }
}

