/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import com.netflix.netty.common.HttpLifecycleChannelHandler;
import com.netflix.netty.common.SourceAddressChannelHandler;
import com.netflix.netty.common.ssl.SslHandshakeInfo;
import com.netflix.zuul.context.Debug;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.context.SessionContextDecorator;
import com.netflix.zuul.exception.ZuulException;
import com.netflix.zuul.message.Headers;
import com.netflix.zuul.message.http.HttpQueryParams;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpRequestMessageImpl;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.netty.ChannelUtils;
import com.netflix.zuul.netty.server.http2.Http2OrHttpHandler;
import com.netflix.zuul.netty.server.ssl.SslHandshakeInfoHandler;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import com.netflix.zuul.stats.status.StatusCategoryUtils;
import com.netflix.zuul.stats.status.ZuulStatusCategory;
import com.netflix.zuul.util.HttpUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.unix.Errors;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRequestReceiver
extends ChannelDuplexHandler {
    private final SessionContextDecorator decorator;
    private HttpRequestMessage zuulRequest;
    private HttpRequest clientRequest;
    private static final Logger LOG = LoggerFactory.getLogger(ClientRequestReceiver.class);
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    public static final AttributeKey<HttpRequestMessage> ATTR_ZUUL_REQ = AttributeKey.newInstance((String)"_zuul_request");
    public static final AttributeKey<HttpResponseMessage> ATTR_ZUUL_RESP = AttributeKey.newInstance((String)"_zuul_response");
    public static final AttributeKey<Boolean> ATTR_LAST_CONTENT_RECEIVED = AttributeKey.newInstance((String)"_last_content_received");

    public ClientRequestReceiver(SessionContextDecorator decorator) {
        this.decorator = decorator;
    }

    public static HttpRequestMessage getRequestFromChannel(Channel ch) {
        return (HttpRequestMessage)ch.attr(ATTR_ZUUL_REQ).get();
    }

    public static HttpResponseMessage getResponseFromChannel(Channel ch) {
        return (HttpResponseMessage)ch.attr(ATTR_ZUUL_RESP).get();
    }

    public static boolean isLastContentReceivedForChannel(Channel ch) {
        Boolean value = (Boolean)ch.attr(ATTR_LAST_CONTENT_RECEIVED).get();
        return value == null ? false : value;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof LastHttpContent) {
            ctx.channel().attr(ATTR_LAST_CONTENT_RECEIVED).set((Object)Boolean.TRUE);
        }
        if (msg instanceof HttpRequest) {
            this.clientRequest = (HttpRequest)msg;
            this.zuulRequest = this.buildZuulHttpRequest(this.clientRequest, ctx);
            this.handleExpect100Continue(ctx, this.clientRequest);
            if (this.clientRequest.decoderResult().isFailure()) {
                String errorMsg = "Invalid http request. clientRequest = " + this.clientRequest.toString() + ", uri = " + String.valueOf(this.clientRequest.uri()) + ", info = " + ChannelUtils.channelInfoForLogging(ctx.channel());
                String causeMsg = String.valueOf(this.clientRequest.decoderResult().cause());
                ZuulException ze = new ZuulException(errorMsg, causeMsg, true);
                ze.setStatusCode(400);
                StatusCategoryUtils.setStatusCategory(this.zuulRequest.getContext(), ZuulStatusCategory.FAILURE_CLIENT_BAD_REQUEST);
                this.zuulRequest.getContext().setError(ze);
                this.zuulRequest.getContext().setShouldSendErrorResponse(true);
            }
            ctx.fireChannelRead((Object)this.zuulRequest);
        } else if (msg instanceof HttpContent) {
            if (this.zuulRequest != null && !this.zuulRequest.getContext().isCancelled()) {
                ctx.fireChannelRead(msg);
            } else {
                ReferenceCountUtil.release((Object)msg);
            }
        } else if (msg instanceof HAProxyMessage) {
            LOG.debug("Received HAProxyMessage for Proxy Protocol IP: {}", (Object)((HAProxyMessage)msg).sourceAddress());
            ReferenceCountUtil.release((Object)msg);
        } else {
            LOG.debug("Received unrecognized message type. " + msg.getClass().getName());
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpLifecycleChannelHandler.CompleteEvent) {
            HttpLifecycleChannelHandler.CompleteReason reason = ((HttpLifecycleChannelHandler.CompleteEvent)evt).getReason();
            if (this.zuulRequest != null) {
                this.zuulRequest.getContext().cancel();
                this.zuulRequest.disposeBufferedBody();
                CurrentPassport passport = CurrentPassport.fromSessionContext(this.zuulRequest.getContext());
                if (passport != null && passport.findState(PassportState.OUT_RESP_LAST_CONTENT_SENT) == null) {
                    passport.add(PassportState.IN_REQ_CANCELLED);
                }
            }
            if (reason == HttpLifecycleChannelHandler.CompleteReason.INACTIVE) {
                StatusCategoryUtils.setStatusCategory(this.zuulRequest.getContext(), ZuulStatusCategory.FAILURE_CLIENT_CANCELLED);
            }
            if (reason != HttpLifecycleChannelHandler.CompleteReason.SESSION_COMPLETE && this.zuulRequest != null) {
                SessionContext zuulCtx = this.zuulRequest.getContext();
                if (this.clientRequest != null && LOG.isInfoEnabled() && !"HTTP/2".equals(this.zuulRequest.getProtocol())) {
                    LOG.info("Client {} request UUID {} to {} completed with reason = {}, {}", new Object[]{this.clientRequest.method(), zuulCtx.getUUID(), this.clientRequest.uri(), reason.name(), ChannelUtils.channelInfoForLogging(ctx.channel())});
                }
                if (zuulCtx.debugRequest()) {
                    LOG.debug("Endpoint = {}", (Object)zuulCtx.getEndpoint());
                    ClientRequestReceiver.dumpDebugInfo(Debug.getRequestDebug(zuulCtx));
                    ClientRequestReceiver.dumpDebugInfo(Debug.getRoutingDebug(zuulCtx));
                }
            }
            this.clientRequest = null;
            this.zuulRequest = null;
        }
        super.userEventTriggered(ctx, evt);
        if (evt instanceof HttpLifecycleChannelHandler.CompleteEvent) {
            Channel channel = ctx.channel();
            channel.attr(ATTR_ZUUL_REQ).set(null);
            channel.attr(ATTR_ZUUL_RESP).set(null);
            channel.attr(ATTR_LAST_CONTENT_RECEIVED).set(null);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof TooLongFrameException) {
            // empty if block
        }
        super.exceptionCaught(ctx, cause);
    }

    private static void dumpDebugInfo(List<String> debugInfo) {
        debugInfo.forEach(dbg -> LOG.debug(dbg));
    }

    private void handleExpect100Continue(ChannelHandlerContext ctx, HttpRequest req) {
        if (HttpUtil.is100ContinueExpected((HttpMessage)req)) {
            ChannelFuture f = ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            f.addListener(s -> {
                if (!s.isSuccess()) {
                    throw new ZuulException(s.cause(), "Failed while writing 100-continue response", true);
                }
            });
            req.headers().remove((CharSequence)HttpHeaderNames.EXPECT);
            this.zuulRequest.getHeaders().remove(HttpHeaderNames.EXPECT.toString());
        }
    }

    private HttpRequestMessage buildZuulHttpRequest(HttpRequest nativeRequest, ChannelHandlerContext clientCtx) {
        HttpRequestMessageImpl request;
        String path;
        int queryIndex;
        String protocol;
        SessionContext context;
        if (this.decorator != null) {
            SessionContext tempContext = new SessionContext();
            tempContext.set("_netty_server_channel_handler_context", clientCtx);
            context = this.decorator.decorate(tempContext);
        } else {
            context = new SessionContext();
        }
        Channel channel = clientCtx.channel();
        String clientIp = (String)channel.attr(SourceAddressChannelHandler.ATTR_SOURCE_ADDRESS).get();
        int port = (Integer)channel.attr(SourceAddressChannelHandler.ATTR_SERVER_LOCAL_PORT).get();
        String serverName = (String)channel.attr(SourceAddressChannelHandler.ATTR_SERVER_LOCAL_ADDRESS).get();
        String scheme = SCHEME_HTTP;
        SslHandshakeInfo sslHandshakeInfo = (SslHandshakeInfo)channel.attr(SslHandshakeInfoHandler.ATTR_SSL_INFO).get();
        if (sslHandshakeInfo != null) {
            context.set("ssl_handshake_info", sslHandshakeInfo);
            scheme = SCHEME_HTTPS;
        }
        if ((protocol = (String)channel.attr(Http2OrHttpHandler.PROTOCOL_NAME).get()) == null) {
            protocol = nativeRequest.protocolVersion().text();
        }
        if ((queryIndex = (path = nativeRequest.uri()).indexOf(63)) > -1) {
            path = path.substring(0, queryIndex);
        }
        if (HttpUtils.hasChunkedTransferEncodingHeader(request = new HttpRequestMessageImpl(context, protocol, nativeRequest.method().asciiName().toString().toLowerCase(), path, ClientRequestReceiver.copyQueryParams(nativeRequest), ClientRequestReceiver.copyHeaders(nativeRequest), clientIp, scheme, port, serverName)) || HttpUtils.hasNonZeroContentLengthHeader(request)) {
            request.setHasBody(true);
        }
        request.storeInboundRequest();
        context.set("_netty_http_request", nativeRequest);
        channel.attr(ATTR_ZUUL_REQ).set((Object)request);
        if (nativeRequest instanceof DefaultFullHttpRequest) {
            ByteBuf chunk = ((DefaultFullHttpRequest)nativeRequest).content();
            request.bufferBodyContents((HttpContent)new DefaultLastHttpContent(chunk));
        }
        return request;
    }

    private static Headers copyHeaders(HttpRequest req) {
        Headers headers = new Headers();
        for (Map.Entry entry : req.headers().entries()) {
            headers.add((String)entry.getKey(), (String)entry.getValue());
        }
        return headers;
    }

    public static HttpQueryParams copyQueryParams(HttpRequest nativeRequest) {
        String uri = nativeRequest.uri();
        int queryStart = uri.indexOf(63);
        String query = queryStart == -1 ? null : uri.substring(queryStart + 1);
        return HttpQueryParams.parse(query);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpResponse) {
            promise.addListener(future -> {
                if (!future.isSuccess()) {
                    this.fireWriteError("response headers", future.cause(), ctx);
                }
            });
            super.write(ctx, msg, promise);
        } else if (msg instanceof HttpContent) {
            promise.addListener(future -> {
                if (!future.isSuccess()) {
                    this.fireWriteError("response content", future.cause(), ctx);
                }
            });
            super.write(ctx, msg, promise);
        } else {
            ReferenceCountUtil.release((Object)msg);
            throw new ZuulException("Attempt to write invalid content type to client: " + msg.getClass().getSimpleName(), true);
        }
    }

    private void fireWriteError(String requestPart, Throwable cause, ChannelHandlerContext ctx) throws Exception {
        String errMesg = String.format("Error writing %s to client", requestPart);
        if (cause instanceof ClosedChannelException || cause instanceof Errors.NativeIoException) {
            LOG.info(errMesg + " - client connection is closed.");
            if (this.zuulRequest != null) {
                this.zuulRequest.getContext().cancel();
                StatusCategoryUtils.storeStatusCategoryIfNotAlreadyFailure(this.zuulRequest.getContext(), ZuulStatusCategory.FAILURE_CLIENT_CANCELLED);
            }
        } else {
            LOG.error(errMesg, cause);
            ctx.fireExceptionCaught((Throwable)new ZuulException(cause, errMesg, true));
        }
    }
}

