/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.config.DynamicIntProperty;
import com.netflix.discovery.EurekaClient;
import com.netflix.netty.common.accesslog.AccessLogPublisher;
import com.netflix.netty.common.channel.config.ChannelConfig;
import com.netflix.netty.common.channel.config.ChannelConfigValue;
import com.netflix.netty.common.channel.config.CommonChannelConfigKeys;
import com.netflix.netty.common.metrics.EventLoopGroupMetrics;
import com.netflix.netty.common.proxyprotocol.StripUntrustedProxyHeadersHandler;
import com.netflix.netty.common.ssl.ServerSslConfig;
import com.netflix.netty.common.status.ServerStatusManager;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.FilterUsageNotifier;
import com.netflix.zuul.RequestCompleteHandler;
import com.netflix.zuul.context.SessionContextDecorator;
import com.netflix.zuul.netty.ratelimiting.NullChannelHandlerProvider;
import com.netflix.zuul.netty.server.ClientConnectionsShutdown;
import com.netflix.zuul.netty.server.DirectMemoryMonitor;
import com.netflix.zuul.netty.server.Server;
import com.netflix.zuul.netty.server.ZuulDependencyKeys;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseServerStartup {
    protected static final Logger LOG = LoggerFactory.getLogger(BaseServerStartup.class);
    protected final ServerStatusManager serverStatusManager;
    protected final Registry registry;
    protected final DirectMemoryMonitor directMemoryMonitor;
    protected final EventLoopGroupMetrics eventLoopGroupMetrics;
    protected final EurekaClient discoveryClient;
    protected final ApplicationInfoManager applicationInfoManager;
    protected final AccessLogPublisher accessLogPublisher;
    protected final SessionContextDecorator sessionCtxDecorator;
    protected final RequestCompleteHandler reqCompleteHandler;
    protected final FilterLoader filterLoader;
    protected final FilterUsageNotifier usageNotifier;
    private Map<Integer, ChannelInitializer> portsToChannelInitializers;
    private ClientConnectionsShutdown clientConnectionsShutdown;
    private Server server;

    @Inject
    public BaseServerStartup(ServerStatusManager serverStatusManager, FilterLoader filterLoader, SessionContextDecorator sessionCtxDecorator, FilterUsageNotifier usageNotifier, RequestCompleteHandler reqCompleteHandler, Registry registry, DirectMemoryMonitor directMemoryMonitor, EventLoopGroupMetrics eventLoopGroupMetrics, EurekaClient discoveryClient, ApplicationInfoManager applicationInfoManager, AccessLogPublisher accessLogPublisher) {
        this.serverStatusManager = serverStatusManager;
        this.registry = registry;
        this.directMemoryMonitor = directMemoryMonitor;
        this.eventLoopGroupMetrics = eventLoopGroupMetrics;
        this.discoveryClient = discoveryClient;
        this.applicationInfoManager = applicationInfoManager;
        this.accessLogPublisher = accessLogPublisher;
        this.sessionCtxDecorator = sessionCtxDecorator;
        this.reqCompleteHandler = reqCompleteHandler;
        this.filterLoader = filterLoader;
        this.usageNotifier = usageNotifier;
    }

    public Server server() {
        return this.server;
    }

    @PostConstruct
    public void init() throws Exception {
        ChannelConfig channelDeps = new ChannelConfig();
        this.addChannelDependencies(channelDeps);
        DefaultChannelGroup clientChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.clientConnectionsShutdown = new ClientConnectionsShutdown((ChannelGroup)clientChannels, (EventExecutor)GlobalEventExecutor.INSTANCE, this.discoveryClient);
        this.portsToChannelInitializers = this.choosePortsAndChannels((ChannelGroup)clientChannels, channelDeps);
        this.server = new Server(this.portsToChannelInitializers, this.serverStatusManager, this.clientConnectionsShutdown, this.eventLoopGroupMetrics);
    }

    protected abstract Map<Integer, ChannelInitializer> choosePortsAndChannels(ChannelGroup var1, ChannelConfig var2);

    protected void addChannelDependencies(ChannelConfig channelDeps) throws Exception {
        channelDeps.set(ZuulDependencyKeys.registry, this.registry);
        channelDeps.set(ZuulDependencyKeys.applicationInfoManager, this.applicationInfoManager);
        channelDeps.set(ZuulDependencyKeys.serverStatusManager, this.serverStatusManager);
        channelDeps.set(ZuulDependencyKeys.accessLogPublisher, this.accessLogPublisher);
        channelDeps.set(ZuulDependencyKeys.sessionCtxDecorator, this.sessionCtxDecorator);
        channelDeps.set(ZuulDependencyKeys.requestCompleteHandler, this.reqCompleteHandler);
        BasicCounter httpRequestReadTimeoutCounter = new BasicCounter(MonitorConfig.builder((String)"server.http.request.read.timeout").build());
        DefaultMonitorRegistry.getInstance().register((Monitor)httpRequestReadTimeoutCounter);
        channelDeps.set(ZuulDependencyKeys.httpRequestReadTimeoutCounter, httpRequestReadTimeoutCounter);
        channelDeps.set(ZuulDependencyKeys.filterLoader, this.filterLoader);
        channelDeps.set(ZuulDependencyKeys.filterUsageNotifier, this.usageNotifier);
        channelDeps.set(ZuulDependencyKeys.eventLoopGroupMetrics, this.eventLoopGroupMetrics);
        channelDeps.set(ZuulDependencyKeys.sslClientCertCheckChannelHandlerProvider, new NullChannelHandlerProvider());
        channelDeps.set(ZuulDependencyKeys.rateLimitingChannelHandlerProvider, new NullChannelHandlerProvider());
        this.directMemoryMonitor.init();
    }

    public static ChannelConfig defaultChannelConfig() {
        ChannelConfig config = new ChannelConfig();
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxConnections, new DynamicIntProperty("server.connection.max", 20000).get()));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxRequestsPerConnection, new DynamicIntProperty("server.connection.max.requests", 20000).get()));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxRequestsPerConnectionInBrownout, new DynamicIntProperty("server.connection.max.requests.brownout", CommonChannelConfigKeys.maxRequestsPerConnectionInBrownout.defaultValue().intValue()).get()));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.connectionExpiry, new DynamicIntProperty("server.connection.expiry", CommonChannelConfigKeys.connectionExpiry.defaultValue().intValue()).get()));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.idleTimeout, new DynamicIntProperty("server.connection.idle.timeout", 65000).get()));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.httpRequestReadTimeout, new DynamicIntProperty("server.http.request.read.timeout", 5000).get()));
        config.add(new ChannelConfigValue<StripUntrustedProxyHeadersHandler.AllowWhen>(CommonChannelConfigKeys.allowProxyHeadersWhen, StripUntrustedProxyHeadersHandler.AllowWhen.NEVER));
        config.set(CommonChannelConfigKeys.withProxyProtocol, true);
        config.set(CommonChannelConfigKeys.preferProxyProtocolForClientIp, true);
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.connCloseDelay, new DynamicIntProperty("zuul.server.connection.close.delay", 10).get()));
        return config;
    }

    public static void addHttp2DefaultConfig(ChannelConfig config) {
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxConcurrentStreams, new DynamicIntProperty("server.http2.max.concurrent.streams", CommonChannelConfigKeys.maxConcurrentStreams.defaultValue().intValue()).get()));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.initialWindowSize, new DynamicIntProperty("server.http2.initialwindowsize", CommonChannelConfigKeys.initialWindowSize.defaultValue().intValue()).get()));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxHttp2HeaderTableSize, new DynamicIntProperty("server.http2.maxheadertablesize", 65536).get()));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxHttp2HeaderListSize, new DynamicIntProperty("server.http2.maxheaderlistsize", 32768).get()));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxRequestsPerConnection, new DynamicIntProperty("server.connection.max.requests", 4000).get()));
    }

    protected void logPortConfigured(int port, ServerSslConfig serverSslConfig) {
        String msg = "Configured port: " + port;
        if (serverSslConfig != null) {
            msg = msg + " with SSL config: " + serverSslConfig.toString();
        }
        LOG.warn(msg);
    }
}

