/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.connectionpool;

import com.netflix.spectator.api.Counter;
import com.netflix.zuul.netty.SpectatorUtils;
import com.netflix.zuul.netty.connectionpool.ConnectionPoolConfig;
import com.netflix.zuul.netty.server.Server;
import com.netflix.zuul.passport.CurrentPassport;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ZuulBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientConnectionFactory {
    private final ConnectionPoolConfig connPoolConfig;
    private final ChannelInitializer<? extends Channel> channelInitializer;
    private final Counter unresolvedDiscoveryHost;
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyClientConnectionFactory.class);

    NettyClientConnectionFactory(ConnectionPoolConfig connPoolConfig, ChannelInitializer<? extends Channel> channelInitializer) {
        this.connPoolConfig = connPoolConfig;
        this.channelInitializer = channelInitializer;
        this.unresolvedDiscoveryHost = SpectatorUtils.newCounter("unresolvedDiscoveryHost", connPoolConfig.getOriginName() == null ? "unknownOrigin" : connPoolConfig.getOriginName());
    }

    public ChannelFuture connect(EventLoop eventLoop, String host, int port, CurrentPassport passport) {
        Class socketChannelClass = Server.USE_EPOLL.get() ? EpollSocketChannel.class : NioSocketChannel.class;
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(socketChannelClass)).handler(this.channelInitializer)).group((EventLoopGroup)eventLoop)).attr(CurrentPassport.CHANNEL_ATTR, (Object)passport)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connPoolConfig.getConnectTimeout())).option(ChannelOption.SO_KEEPALIVE, (Object)this.connPoolConfig.getTcpKeepAlive())).option(ChannelOption.TCP_NODELAY, (Object)this.connPoolConfig.getTcpNoDelay())).option(ChannelOption.SO_SNDBUF, (Object)this.connPoolConfig.getTcpSendBufferSize())).option(ChannelOption.SO_RCVBUF, (Object)this.connPoolConfig.getTcpReceiveBufferSize())).option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)this.connPoolConfig.getNettyWriteBufferHighWaterMark())).option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)this.connPoolConfig.getNettyWriteBufferLowWaterMark())).option(ChannelOption.AUTO_READ, (Object)this.connPoolConfig.getNettyAutoRead())).remoteAddress((SocketAddress)socketAddress);
        ZuulBootstrap zuulBootstrap = new ZuulBootstrap(bootstrap);
        if (!zuulBootstrap.getResolver(eventLoop).isResolved((SocketAddress)socketAddress)) {
            LOGGER.warn("NettyClientConnectionFactory got an unresolved server address, host: " + host + ", port: " + port);
            this.unresolvedDiscoveryHost.increment();
        }
        return bootstrap.connect();
    }
}

