/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.connectionpool;

import com.netflix.netty.common.HttpLifecycleChannelHandler;
import com.netflix.spectator.api.Counter;
import com.netflix.zuul.netty.ChannelUtils;
import com.netflix.zuul.netty.SpectatorUtils;
import com.netflix.zuul.netty.connectionpool.PooledConnection;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ConnectionPoolHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionPoolHandler.class);
    public static final String METRIC_PREFIX = "connectionpool";
    private final String originName;
    private final Counter idleCounter;
    private final Counter inactiveCounter;
    private final Counter errorCounter;

    public ConnectionPoolHandler(String originName) {
        if (originName == null) {
            throw new IllegalArgumentException("Null originName passed to constructor!");
        }
        this.originName = originName;
        this.idleCounter = SpectatorUtils.newCounter("connectionpool_idle", originName);
        this.inactiveCounter = SpectatorUtils.newCounter("connectionpool_inactive", originName);
        this.errorCounter = SpectatorUtils.newCounter("connectionpool_error", originName);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.idleCounter.increment();
            String msg = "Origin channel for origin - " + this.originName + " - idle timeout has fired. " + ChannelUtils.channelInfoForLogging(ctx.channel());
            this.closeConnection(ctx, msg);
        } else if (evt instanceof HttpLifecycleChannelHandler.CompleteEvent) {
            HttpLifecycleChannelHandler.CompleteReason reason = ((HttpLifecycleChannelHandler.CompleteEvent)evt).getReason();
            if (reason == HttpLifecycleChannelHandler.CompleteReason.SESSION_COMPLETE) {
                PooledConnection conn = PooledConnection.getFromChannel(ctx.channel());
                if (conn != null) {
                    conn.setConnectionState(PooledConnection.ConnectionState.WRITE_READY);
                    conn.release();
                }
            } else {
                String msg = "Origin channel for origin - " + this.originName + " - completed with reason " + reason.name() + ", " + ChannelUtils.channelInfoForLogging(ctx.channel());
                this.closeConnection(ctx, msg);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.errorCounter.increment();
        String mesg = "Exception on Origin channel for origin - " + this.originName + ". " + ChannelUtils.channelInfoForLogging(ctx.channel()) + " - " + cause.getClass().getCanonicalName() + ": " + cause.getMessage();
        this.closeConnection(ctx, mesg);
        if (LOG.isDebugEnabled()) {
            LOG.debug(mesg, cause);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.inactiveCounter.increment();
        String msg = "Client channel for origin - " + this.originName + " - inactive event has fired. " + ChannelUtils.channelInfoForLogging(ctx.channel());
        this.closeConnection(ctx, msg);
    }

    private void closeConnection(ChannelHandlerContext ctx, String msg) {
        PooledConnection conn = PooledConnection.getFromChannel(ctx.channel());
        if (conn != null) {
            if (LOG.isDebugEnabled()) {
                msg = msg + " Closing the PooledConnection and releasing. ASG: " + String.valueOf(conn.getServerKey().getASGName() + ", host=" + String.valueOf(conn.getServerKey().getHostName()));
                LOG.debug(msg);
            }
            this.flagCloseAndReleaseConnection(conn);
        } else {
            LOG.warn(msg + " But no PooledConnection attribute. So just closing Channel.");
            ctx.close();
        }
    }

    private void flagCloseAndReleaseConnection(PooledConnection pooledConnection) {
        if (pooledConnection.isInPool()) {
            pooledConnection.closeAndRemoveFromPool();
        } else {
            pooledConnection.flagShouldClose();
            pooledConnection.release();
        }
    }
}

