/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.connectionpool;

import com.google.common.base.Stopwatch;
import com.netflix.loadbalancer.Server;
import com.netflix.zuul.netty.connectionpool.RequestStat;
import com.netflix.zuul.stats.status.ZuulStatusCategory;
import java.util.concurrent.TimeUnit;

public class BasicRequestStat
implements RequestStat {
    private volatile boolean isFinished = false;
    private volatile Stopwatch stopwatch = Stopwatch.createStarted();

    public BasicRequestStat(String clientName) {
    }

    @Override
    public RequestStat server(Server server) {
        return this;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public long duration() {
        if (!this.isFinished) {
            return -1L;
        }
        long ns = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        return ns > 0L ? ns / 1000000L : 0L;
    }

    @Override
    public void serviceUnavailable() {
        this.failAndSetErrorCode(ZuulStatusCategory.FAILURE_ORIGIN_THROTTLED.name());
    }

    @Override
    public void nextServerRetriesExceeded() {
        this.failAndSetErrorCode(ZuulStatusCategory.FAILURE_ORIGIN_THROTTLED.name());
    }

    @Override
    public void generalError() {
        this.failAndSetErrorCode(ZuulStatusCategory.FAILURE_ORIGIN.name());
    }

    @Override
    public void failAndSetErrorCode(String error) {
    }

    @Override
    public void updateWithHttpStatusCode(int httpStatusCode) {
    }

    @Override
    public boolean finishIfNotAlready() {
        if (this.isFinished) {
            return false;
        }
        this.stopwatch.stop();
        this.publishMetrics();
        this.isFinished = true;
        return true;
    }

    protected void publishMetrics() {
    }
}

