/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.message.http;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.message.Header;
import com.netflix.zuul.message.Headers;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.ZuulMessageImpl;
import com.netflix.zuul.message.http.Cookies;
import com.netflix.zuul.message.http.HttpHeaderNames;
import com.netflix.zuul.message.http.HttpRequestInfo;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseInfo;
import com.netflix.zuul.message.http.HttpResponseMessage;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.ServerCookieEncoder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseMessageImpl
implements HttpResponseMessage {
    private static final DynamicIntProperty MAX_BODY_SIZE_PROP = DynamicPropertyFactory.getInstance().getIntProperty("zuul.HttpResponseMessage.body.max.size", 25600000);
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseMessageImpl.class);
    private ZuulMessage message;
    private HttpRequestMessage outboundRequest;
    private int status;
    private HttpResponseInfo inboundResponse = null;

    public HttpResponseMessageImpl(SessionContext context, HttpRequestMessage request, int status) {
        this(context, new Headers(), request, status);
    }

    public HttpResponseMessageImpl(SessionContext context, Headers headers, HttpRequestMessage request, int status) {
        this.message = new ZuulMessageImpl(context, headers);
        this.outboundRequest = request;
        if (this.outboundRequest.getInboundRequest() == null) {
            LOG.warn("HttpResponseMessage created with a request that does not have a stored inboundRequest! Probably a bug in the filter that is creating this response.", (Throwable)new RuntimeException("Invalid HttpRequestMessage"));
        }
        this.status = status;
    }

    public static HttpResponseMessage defaultErrorResponse(HttpRequestMessage request) {
        HttpResponseMessageImpl resp = new HttpResponseMessageImpl(request.getContext(), request, 500);
        resp.finishBufferedBodyIfIncomplete();
        return resp;
    }

    @Override
    public Headers getHeaders() {
        return this.message.getHeaders();
    }

    @Override
    public SessionContext getContext() {
        return this.message.getContext();
    }

    @Override
    public void setHeaders(Headers newHeaders) {
        this.message.setHeaders(newHeaders);
    }

    @Override
    public void setHasBody(boolean hasBody) {
        this.message.setHasBody(hasBody);
    }

    @Override
    public boolean hasBody() {
        return this.message.hasBody();
    }

    @Override
    public void bufferBodyContents(HttpContent chunk) {
        this.message.bufferBodyContents(chunk);
    }

    @Override
    public void setBodyAsText(String bodyText) {
        this.message.setBodyAsText(bodyText);
    }

    @Override
    public void setBody(byte[] body) {
        this.message.setBody(body);
    }

    @Override
    public String getBodyAsText() {
        return this.message.getBodyAsText();
    }

    @Override
    public byte[] getBody() {
        return this.message.getBody();
    }

    @Override
    public int getBodyLength() {
        return this.message.getBodyLength();
    }

    @Override
    public boolean hasCompleteBody() {
        return this.message.hasCompleteBody();
    }

    @Override
    public boolean finishBufferedBodyIfIncomplete() {
        return this.message.finishBufferedBodyIfIncomplete();
    }

    @Override
    public Iterable<HttpContent> getBodyContents() {
        return this.message.getBodyContents();
    }

    @Override
    public void runBufferedBodyContentThroughFilter(ZuulFilter filter) {
        this.message.runBufferedBodyContentThroughFilter(filter);
    }

    @Override
    public void disposeBufferedBody() {
        this.message.disposeBufferedBody();
    }

    @Override
    public HttpRequestInfo getInboundRequest() {
        return this.outboundRequest.getInboundRequest();
    }

    @Override
    public HttpRequestMessage getOutboundRequest() {
        return this.outboundRequest;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getMaxBodySize() {
        return MAX_BODY_SIZE_PROP.get();
    }

    @Override
    public Cookies parseSetCookieHeader(String setCookieValue) {
        Cookies cookies = new Cookies();
        for (Cookie cookie : CookieDecoder.decode((String)setCookieValue)) {
            cookies.add(cookie);
        }
        return cookies;
    }

    @Override
    public boolean hasSetCookieWithName(String cookieName) {
        boolean has = false;
        block0: for (String setCookieValue : this.getHeaders().get(HttpHeaderNames.SET_COOKIE)) {
            for (Cookie cookie : CookieDecoder.decode((String)setCookieValue)) {
                if (!cookie.getName().equalsIgnoreCase(cookieName)) continue;
                has = true;
                continue block0;
            }
        }
        return has;
    }

    @Override
    public boolean removeExistingSetCookie(String cookieName) {
        String cookieNamePrefix = cookieName + "=";
        boolean dirty = false;
        Headers filtered = new Headers();
        for (Header hdr : this.getHeaders().entries()) {
            if (HttpHeaderNames.SET_COOKIE.equals(hdr.getName())) {
                String value = hdr.getValue();
                if (value.startsWith(cookieNamePrefix)) {
                    dirty = true;
                    continue;
                }
                filtered.add(hdr.getName(), hdr.getValue());
                continue;
            }
            filtered.add(hdr.getName(), hdr.getValue());
        }
        if (dirty) {
            this.setHeaders(filtered);
        }
        return dirty;
    }

    @Override
    public void addSetCookie(Cookie cookie) {
        this.getHeaders().add(HttpHeaderNames.SET_COOKIE, ServerCookieEncoder.encode((Cookie)cookie));
    }

    @Override
    public void setSetCookie(Cookie cookie) {
        this.getHeaders().set(HttpHeaderNames.SET_COOKIE, ServerCookieEncoder.encode((Cookie)cookie));
    }

    @Override
    public ZuulMessage clone() {
        HttpResponseMessageImpl clone = new HttpResponseMessageImpl(this.getContext().clone(), this.getHeaders().clone(), this.getOutboundRequest(), this.getStatus());
        if (this.getInboundResponse() != null) {
            clone.inboundResponse = (HttpResponseInfo)this.getInboundResponse().clone();
        }
        return clone;
    }

    protected HttpResponseInfo copyResponseInfo() {
        HttpResponseMessageImpl response = new HttpResponseMessageImpl(this.getContext(), this.getHeaders().immutableCopy(), this.getOutboundRequest(), this.getStatus());
        response.setHasBody(this.hasBody());
        return response;
    }

    public String toString() {
        return "HttpResponseMessageImpl{message=" + this.message + ", outboundRequest=" + this.outboundRequest + ", status=" + this.status + ", inboundResponse=" + this.inboundResponse + '}';
    }

    @Override
    public void storeInboundResponse() {
        this.inboundResponse = this.copyResponseInfo();
    }

    @Override
    public HttpResponseInfo getInboundResponse() {
        return this.inboundResponse;
    }

    @Override
    public String getInfoForLogging() {
        HttpRequestInfo req = this.getInboundRequest() == null ? this.getOutboundRequest() : this.getInboundRequest();
        StringBuilder sb = new StringBuilder().append(req.getInfoForLogging()).append(",proxy-status=").append(this.getStatus());
        return sb.toString();
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Mock
        private HttpRequestMessage request;
        private HttpResponseMessageImpl response;

        @Before
        public void setup() {
            this.response = new HttpResponseMessageImpl(new SessionContext(), new Headers(), this.request, 200);
        }

        @Test
        public void testHasSetCookieWithName() {
            this.response.getHeaders().add("Set-Cookie", "c1=1234; Max-Age=-1; Expires=Tue, 01 Sep 2015 22:49:57 GMT; Path=/; Domain=.netflix.com");
            this.response.getHeaders().add("Set-Cookie", "c2=4567; Max-Age=-1; Expires=Tue, 01 Sep 2015 22:49:57 GMT; Path=/; Domain=.netflix.com");
            Assert.assertTrue((boolean)this.response.hasSetCookieWithName("c1"));
            Assert.assertTrue((boolean)this.response.hasSetCookieWithName("c2"));
            Assert.assertFalse((boolean)this.response.hasSetCookieWithName("XX"));
        }

        @Test
        public void testRemoveExistingSetCookie() {
            this.response.getHeaders().add("Set-Cookie", "c1=1234; Max-Age=-1; Expires=Tue, 01 Sep 2015 22:49:57 GMT; Path=/; Domain=.netflix.com");
            this.response.getHeaders().add("Set-Cookie", "c2=4567; Max-Age=-1; Expires=Tue, 01 Sep 2015 22:49:57 GMT; Path=/; Domain=.netflix.com");
            this.response.removeExistingSetCookie("c1");
            Assert.assertEquals((long)1L, (long)this.response.getHeaders().size());
            Assert.assertFalse((boolean)this.response.hasSetCookieWithName("c1"));
            Assert.assertTrue((boolean)this.response.hasSetCookieWithName("c2"));
        }
    }
}

