/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.accesslog;

import com.netflix.config.DynamicStringListProperty;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogPublisher {
    private static final char DELIM = '\t';
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    private static final List<String> LOG_REQ_HEADERS = new DynamicStringListProperty("zuul.access.log.requestheaders", "host,x-forwarded-for,x-forwarded-proto,x-forwarded-host,x-forwarded-port,user-agent").get();
    private static final List<String> LOG_RESP_HEADERS = new DynamicStringListProperty("zuul.access.log.responseheaders", "server,via,content-type").get();
    private final Logger logger;
    private final BiFunction<Channel, HttpRequest, String> requestIdProvider;
    private static final Logger LOG = LoggerFactory.getLogger(AccessLogPublisher.class);

    public AccessLogPublisher(String loggerName, BiFunction<Channel, HttpRequest, String> requestIdProvider) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
        this.requestIdProvider = requestIdProvider;
    }

    public void log(Channel channel, HttpRequest request, HttpResponse response, LocalDateTime dateTime, Integer localPort, String remoteIp, Long durationNs, Integer requestBodySize, Integer responseBodySize) {
        StringBuilder sb = new StringBuilder();
        String dateTimeStr = dateTime != null ? dateTime.format(DATE_TIME_FORMATTER) : "-----T-:-:-";
        String remoteIpStr = remoteIp != null && !remoteIp.isEmpty() ? remoteIp : "-";
        String port = localPort != null ? localPort.toString() : "-";
        String method = request != null ? request.method().toString().toUpperCase() : "-";
        String uri = request != null ? request.uri() : "-";
        String status = response != null ? String.valueOf(response.status().code()) : "-";
        String requestId = null;
        try {
            requestId = this.requestIdProvider.apply(channel, request);
        }
        catch (Exception ex) {
            LOG.error("requestIdProvider failed in AccessLogPublisher method={}, uri={}, status={}", new Object[]{method, uri, status});
        }
        requestId = requestId != null ? requestId : "-";
        String durationStr = durationNs != null && durationNs > 0L ? String.valueOf(durationNs / 1000L) : "-";
        String requestBodySizeStr = requestBodySize != null && requestBodySize > 0 ? requestBodySize.toString() : "-";
        String responseBodySizeStr = responseBodySize != null && responseBodySize > 0 ? responseBodySize.toString() : "-";
        sb.append(dateTimeStr).append('\t').append(remoteIpStr).append('\t').append(port).append('\t').append(method).append('\t').append(uri).append('\t').append(status).append('\t').append(durationStr).append('\t').append(responseBodySizeStr).append('\t').append(requestId).append('\t').append(requestBodySizeStr);
        if (request != null && request.headers() != null) {
            this.includeMatchingHeaders(sb, LOG_REQ_HEADERS, request.headers());
        }
        if (response != null && response.headers() != null) {
            this.includeMatchingHeaders(sb, LOG_RESP_HEADERS, response.headers());
        }
        String access = sb.toString();
        this.logger.info(access);
        LOG.debug(access);
    }

    void includeMatchingHeaders(StringBuilder builder, List<String> requiredHeaders, HttpHeaders headers) {
        for (String headerName : requiredHeaders) {
            String value = this.headerAsString(headers, headerName);
            builder.append('\t').append('\"').append(value).append('\"');
        }
    }

    String headerAsString(HttpHeaders headers, String headerName) {
        List values = headers.getAll(headerName);
        return values.size() == 0 ? "-" : String.join((CharSequence)",", values);
    }
}

