/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import com.netflix.netty.common.HttpLifecycleChannelHandler;
import com.netflix.zuul.passport.PassportState;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;

public class HttpServerLifecycleChannelHandler
extends HttpLifecycleChannelHandler {
    public HttpServerLifecycleChannelHandler() {
        super((ChannelInboundHandler)new HttpServerLifecycleInboundChannelHandler(), (ChannelOutboundHandler)new HttpServerLifecycleOutboundChannelHandler());
    }

    private static class HttpServerLifecycleOutboundChannelHandler
    extends ChannelOutboundHandlerAdapter {
        private HttpServerLifecycleOutboundChannelHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof HttpResponse) {
                ctx.channel().attr(HttpLifecycleChannelHandler.ATTR_HTTP_RESP).set((Object)((HttpResponse)msg));
            }
            try {
                super.write(ctx, msg, promise);
            }
            finally {
                if (msg instanceof LastHttpContent) {
                    boolean dontFireCompleteYet = false;
                    if (msg instanceof HttpResponse && ((HttpResponse)msg).status() == HttpResponseStatus.CONTINUE) {
                        dontFireCompleteYet = true;
                    }
                    if (!dontFireCompleteYet) {
                        if (promise.isDone()) {
                            HttpLifecycleChannelHandler.fireCompleteEventIfNotAlready(ctx, HttpLifecycleChannelHandler.CompleteReason.SESSION_COMPLETE);
                        } else {
                            promise.addListener(future -> HttpLifecycleChannelHandler.fireCompleteEventIfNotAlready(ctx, HttpLifecycleChannelHandler.CompleteReason.SESSION_COMPLETE));
                        }
                    }
                }
            }
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            HttpLifecycleChannelHandler.fireCompleteEventIfNotAlready(ctx, HttpLifecycleChannelHandler.CompleteReason.DISCONNECT);
            super.disconnect(ctx, promise);
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            HttpLifecycleChannelHandler.addPassportState(ctx, PassportState.SERVER_CH_CLOSE);
            HttpLifecycleChannelHandler.fireCompleteEventIfNotAlready(ctx, HttpLifecycleChannelHandler.CompleteReason.CLOSE);
            super.close(ctx, promise);
        }
    }

    private static class HttpServerLifecycleInboundChannelHandler
    extends ChannelInboundHandlerAdapter {
        private HttpServerLifecycleInboundChannelHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof HttpRequest) {
                if (HttpLifecycleChannelHandler.fireStartEvent(ctx, (HttpRequest)msg)) {
                    super.channelRead(ctx, msg);
                }
            } else {
                super.channelRead(ctx, msg);
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            HttpLifecycleChannelHandler.fireCompleteEventIfNotAlready(ctx, HttpLifecycleChannelHandler.CompleteReason.INACTIVE);
            super.channelInactive(ctx);
        }
    }
}

