/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.http;

import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.http.ServletInputStreamWrapper;
import com.netflix.zuul.util.HTTPRequestUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletRequestWrapper
extends javax.servlet.http.HttpServletRequestWrapper {
    private static final HashMap<String, String[]> EMPTY_MAP = new HashMap();
    protected static final Logger LOG = LoggerFactory.getLogger(HttpServletRequestWrapper.class);
    private HttpServletRequest req;
    private byte[] contentData = null;
    private HashMap<String, String[]> parameters = null;
    private long bodyBufferingTimeNs = 0L;

    public HttpServletRequestWrapper() {
        super(HttpServletRequestWrapper.groovyTrick());
    }

    private static HttpServletRequest groovyTrick() {
        throw new IllegalArgumentException("Please use HttpServletRequestWrapper(HttpServletRequest request) constructor!");
    }

    private HttpServletRequestWrapper(HttpServletRequest request, byte[] contentData, HashMap<String, String[]> parameters) {
        super(request);
        this.req = request;
        this.contentData = contentData;
        this.parameters = parameters;
    }

    public HttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.req = request;
    }

    public HttpServletRequest getRequest() {
        try {
            this.parseRequest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot parse the request!", e);
        }
        return this.req;
    }

    public byte[] getContentData() {
        return this.contentData;
    }

    public HashMap<String, String[]> getParameters() {
        if (this.parameters == null) {
            return EMPTY_MAP;
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>(this.parameters.size() * 2);
        for (String key : this.parameters.keySet()) {
            map.put(key, (String[])this.parameters.get(key).clone());
        }
        return map;
    }

    private void parseRequest() throws IOException {
        LinkedList<String> list;
        if (this.parameters != null) {
            return;
        }
        HashMap<String, LinkedList<String>> mapA = new HashMap<String, LinkedList<String>>();
        Map<String, List<String>> query = HTTPRequestUtils.getInstance().getQueryParams();
        if (query != null) {
            for (String key : query.keySet()) {
                list = query.get(key);
                mapA.put(key, list);
            }
        }
        if (this.shouldBufferBody()) {
            boolean isFormBody;
            block19: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    long bufferStartTime = System.nanoTime();
                    IOUtils.copy((InputStream)this.req.getInputStream(), (OutputStream)baos);
                    this.bodyBufferingTimeNs = System.nanoTime() - bufferStartTime;
                    this.contentData = baos.toByteArray();
                }
                catch (SocketTimeoutException e) {
                    LOG.error("SocketTimeoutException reading request body from inputstream. error=" + String.valueOf(e.getMessage()));
                    if (this.contentData != null) break block19;
                    this.contentData = new byte[0];
                }
            }
            try {
                LOG.debug("Length of contentData byte array = " + this.contentData.length);
                if (this.req.getContentLength() != this.contentData.length) {
                    LOG.warn("Content-length different from byte array length! cl=" + this.req.getContentLength() + ", array=" + this.contentData.length);
                }
            }
            catch (Exception e) {
                LOG.error("Error checking if request body gzipped!", (Throwable)e);
            }
            boolean isPost = this.req.getMethod().equals("POST");
            String contentType = this.req.getContentType();
            boolean bl = isFormBody = contentType != null && contentType.contains("application/x-www-form-urlencoded");
            if (isPost && isFormBody) {
                boolean decode;
                String enc = this.req.getCharacterEncoding();
                if (enc == null) {
                    enc = "UTF-8";
                }
                String s = new String(this.contentData, enc);
                StringTokenizer st = new StringTokenizer(s, "&");
                boolean bl2 = decode = this.req.getContentType() != null;
                while (st.hasMoreTokens()) {
                    s = st.nextToken();
                    int i = s.indexOf("=");
                    if (i <= 0 || s.length() <= i + 1) continue;
                    String name = s.substring(0, i);
                    String value = s.substring(i + 1);
                    if (decode) {
                        try {
                            name = URLDecoder.decode(name, "UTF-8");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            value = URLDecoder.decode(value, "UTF-8");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((list = (List)mapA.get(name)) == null) {
                        list = new LinkedList<String>();
                        mapA.put(name, list);
                    }
                    list.add(value);
                }
            }
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>(mapA.size() * 2);
        for (String key : mapA.keySet()) {
            list = (LinkedList<String>)mapA.get(key);
            map.put(key, list.toArray(new String[list.size()]));
        }
        this.parameters = map;
    }

    private boolean shouldBufferBody() {
        String transferEncoding;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Path = " + this.req.getPathInfo());
            LOG.debug("Transfer-Encoding = " + String.valueOf(this.req.getHeader("transfer-encoding")));
            LOG.debug("Content-Encoding = " + String.valueOf(this.req.getHeader("Content-Encoding")));
            LOG.debug("Content-Length header = " + this.req.getContentLength());
        }
        boolean should = false;
        if (this.req.getContentLength() > 0) {
            should = true;
        } else if (this.req.getContentLength() == -1 && (transferEncoding = this.req.getHeader("transfer-encoding")) != null && transferEncoding.equals("chunked")) {
            RequestContext.getCurrentContext().setChunkedRequestBody();
            should = true;
        }
        return should;
    }

    public long getBodyBufferingTimeNs() {
        return this.bodyBufferingTimeNs;
    }

    public ServletInputStream getInputStream() throws IOException {
        this.parseRequest();
        return new ServletInputStreamWrapper(this.contentData);
    }

    public BufferedReader getReader() throws IOException {
        byte[] data;
        this.parseRequest();
        String enc = this.req.getCharacterEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        if ((data = this.contentData) == null) {
            data = new byte[]{};
        }
        return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(data), enc));
    }

    public String getParameter(String name) {
        try {
            this.parseRequest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot parse the request!", e);
        }
        if (this.parameters == null) {
            return null;
        }
        String[] values = this.parameters.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map getParameterMap() {
        try {
            this.parseRequest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot parse the request!", e);
        }
        return this.getParameters();
    }

    public Enumeration getParameterNames() {
        try {
            this.parseRequest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot parse the request!", e);
        }
        return new Enumeration<String>(){
            private String[] arr;
            private int idx;
            {
                this.arr = HttpServletRequestWrapper.this.getParameters().keySet().toArray(new String[0]);
                this.idx = 0;
            }

            @Override
            public boolean hasMoreElements() {
                return this.idx < this.arr.length;
            }

            @Override
            public String nextElement() {
                return this.arr[this.idx++];
            }
        };
    }

    public String[] getParameterValues(String name) {
        try {
            this.parseRequest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot parse the request!", e);
        }
        if (this.parameters == null) {
            return null;
        }
        String[] arr = this.parameters.get(name);
        if (arr == null) {
            return null;
        }
        return (String[])arr.clone();
    }

    public static final class UnitTest {
        @Mock
        HttpServletRequest request;

        @Before
        public void before() {
            RequestContext.getCurrentContext().unset();
            MockitoAnnotations.initMocks((Object)this);
            RequestContext.getCurrentContext().setRequest(this.request);
            this.method("GET");
            this.contentType("zuul/test-content-type");
        }

        private void body(byte[] body) throws IOException {
            Mockito.when((Object)this.request.getInputStream()).thenReturn((Object)new ServletInputStreamWrapper(body));
            Mockito.when((Object)this.request.getContentLength()).thenReturn((Object)body.length);
        }

        private void method(String s) {
            Mockito.when((Object)this.request.getMethod()).thenReturn((Object)s);
        }

        private void contentType(String s) {
            Mockito.when((Object)this.request.getContentType()).thenReturn((Object)s);
        }

        private static String readZipInputStream(InputStream input) throws IOException {
            byte[] uploadedBytes = UnitTest.getBytesFromInputStream(input);
            input.close();
            String uploadFileTxt = null;
            ZipInputStream zInput = new ZipInputStream(new ByteArrayInputStream(uploadedBytes));
            ZipEntry zipEntry = zInput.getNextEntry();
            if (zipEntry != null) {
                while (zipEntry != null) {
                    byte[] fileBytes = UnitTest.getBytesFromInputStream(zInput);
                    uploadFileTxt = new String(fileBytes);
                    zipEntry = zInput.getNextEntry();
                }
            }
            return uploadFileTxt;
        }

        private static byte[] getBytesFromInputStream(InputStream input) throws IOException {
            int v = 0;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((v = input.read()) != -1) {
                bos.write(v);
            }
            bos.close();
            return bos.toByteArray();
        }

        @Test
        public void handlesDuplicateParams() {
            Mockito.when((Object)this.request.getQueryString()).thenReturn((Object)"path=one&key1=val1&path=two");
            HttpServletRequestWrapper w = new HttpServletRequestWrapper(this.request);
            w.getParameterMap();
            HashMap<String, String[]> params = w.getParameters();
            Assert.assertFalse((String)"params should not be empty", (boolean)params.isEmpty());
            String[] paths = (String[])params.get("path");
            Assert.assertTrue((String)"paths param should not be empty", (paths.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"one", (Object)paths[0]);
            Assert.assertEquals((Object)"two", (Object)paths[1]);
        }

        @Test
        public void handlesPlainRequestBody() throws IOException {
            String body = "hello";
            this.body("hello".getBytes());
            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(this.request);
            Assert.assertEquals((Object)"hello", (Object)IOUtils.toString((InputStream)wrapper.getInputStream()));
        }

        @Test
        public void handlesGzipRequestBody() throws IOException {
            String body = "hello";
            byte[] bodyBytes = "hello".getBytes();
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream(0);
            GZIPOutputStream gzipOutStream = new GZIPOutputStream(byteOutStream);
            gzipOutStream.write(bodyBytes);
            gzipOutStream.finish();
            gzipOutStream.flush();
            this.body(byteOutStream.toByteArray());
            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(this.request);
            Assert.assertEquals((Object)"hello", (Object)IOUtils.toString((InputStream)new GZIPInputStream((InputStream)wrapper.getInputStream())));
        }

        @Test
        public void handlesZipRequestBody() throws IOException {
            String body = "hello";
            byte[] bodyBytes = "hello".getBytes();
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream(0);
            ZipOutputStream zOutput = new ZipOutputStream(byteOutStream);
            zOutput.putNextEntry(new ZipEntry("f1"));
            zOutput.write(bodyBytes);
            zOutput.finish();
            zOutput.flush();
            this.body(byteOutStream.toByteArray());
            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(this.request);
            Assert.assertEquals((Object)"hello", (Object)UnitTest.readZipInputStream((InputStream)wrapper.getInputStream()));
        }

        @Test
        public void parsesParamsFromFormBody() throws Exception {
            this.method("POST");
            this.body("one=1&two=2".getBytes());
            this.contentType("application/x-www-form-urlencoded");
            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(this.request);
            Map params = wrapper.getParameterMap();
            Assert.assertTrue((boolean)params.containsKey("one"));
            Assert.assertTrue((boolean)params.containsKey("two"));
        }

        @Test
        public void ignoresParamsInBodyForNonPosts() throws Exception {
            this.method("PUT");
            this.body("one=1&two=2".getBytes());
            this.contentType("application/x-www-form-urlencoded");
            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(this.request);
            Map params = wrapper.getParameterMap();
            Assert.assertFalse((boolean)params.containsKey("one"));
        }

        @Test
        public void ignoresParamsInBodyForNonForms() throws Exception {
            this.method("POST");
            this.body("one=1&two=2".getBytes());
            this.contentType("application/json");
            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(this.request);
            Map params = wrapper.getParameterMap();
            Assert.assertFalse((boolean)params.containsKey("one"));
        }

        @Test
        public void handlesPostsWithNoContentTypeHeader() throws Exception {
            this.method("POST");
            this.body("one=1&two=2".getBytes());
            this.contentType(null);
            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(this.request);
            Map params = wrapper.getParameterMap();
            Assert.assertFalse((boolean)params.containsKey("one"));
        }
    }
}

