/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.internal.operators.BufferUntilSubscriber;
import rx.observables.GroupedObservable;
import rx.observers.SerializedObserver;
import rx.subscriptions.Subscriptions;

public final class OperatorPivot<K1, K2, T>
implements Observable.Operator<GroupedObservable<K2, GroupedObservable<K1, T>>, GroupedObservable<K1, GroupedObservable<K2, T>>> {
    public static <K1, K2, T> OperatorPivot<K1, K2, T> create() {
        return new OperatorPivot<K1, K2, T>();
    }

    public Subscriber<? super GroupedObservable<K1, GroupedObservable<K2, T>>> call(Subscriber<? super GroupedObservable<K2, GroupedObservable<K1, T>>> child) {
        final AtomicReference<State> state = new AtomicReference<State>(State.create());
        final PivotSubscriber pivotSubscriber = new PivotSubscriber(child, state);
        child.add(Subscriptions.create((Action0)new Action0(){

            public void call() {
                State current;
                State newState = null;
                while (!state.compareAndSet(current = (State)state.get(), newState = current.unsubscribe())) {
                }
                if (newState.shouldComplete()) {
                    pivotSubscriber.groups.completeAll(newState);
                }
            }
        }));
        return pivotSubscriber;
    }

    private static final class KeyPair<K1, K2> {
        private final K1 k1;
        private final K2 k2;

        KeyPair(K1 k1, K2 k2) {
            this.k1 = k1;
            this.k2 = k2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.k1 == null ? 0 : this.k1.hashCode());
            result = 31 * result + (this.k2 == null ? 0 : this.k2.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyPair other = (KeyPair)obj;
            if (this.k1 == null ? other.k1 != null : !this.k1.equals(other.k1)) {
                return false;
            }
            return !(this.k2 == null ? other.k2 != null : !this.k2.equals(other.k2));
        }

        public String toString() {
            return this.k2 + "." + this.k1;
        }
    }

    private static final class State {
        private final boolean unsubscribed;
        private final boolean completed;
        private final Set<Object> k1Keys;
        private final Set<KeyPair<?, ?>> k1k2Keys;

        private State(boolean completed, boolean unsubscribed, Set<Object> k1Keys, Set<KeyPair<?, ?>> k1k2Keys) {
            this.completed = completed;
            this.unsubscribed = unsubscribed;
            this.k1Keys = k1Keys;
            this.k1k2Keys = k1k2Keys;
        }

        public static State create() {
            return new State(false, false, Collections.emptySet(), Collections.emptySet());
        }

        public State addK1(Object key) {
            HashSet<Object> newKeys = new HashSet<Object>(this.k1Keys);
            newKeys.add(key);
            return new State(this.completed, this.unsubscribed, newKeys, this.k1k2Keys);
        }

        public State removeK1(Object key) {
            HashSet<Object> newKeys = new HashSet<Object>(this.k1Keys);
            newKeys.remove(key);
            return new State(this.completed, this.unsubscribed, newKeys, this.k1k2Keys);
        }

        public State addK1k2(KeyPair<?, ?> key) {
            HashSet newKeys = new HashSet(this.k1k2Keys);
            newKeys.add(key);
            return new State(this.completed, this.unsubscribed, this.k1Keys, newKeys);
        }

        public State removeK1k2(KeyPair<?, ?> key) {
            HashSet newKeys = new HashSet(this.k1k2Keys);
            newKeys.remove(key);
            return new State(this.completed, this.unsubscribed, this.k1Keys, newKeys);
        }

        public State complete() {
            return new State(true, this.unsubscribed, this.k1Keys, this.k1k2Keys);
        }

        public State unsubscribe() {
            return new State(this.completed, true, this.k1Keys, this.k1k2Keys);
        }

        public boolean shouldComplete() {
            if (this.k1Keys.isEmpty() && this.completed) {
                return true;
            }
            if (this.unsubscribed) {
                return this.k1k2Keys.isEmpty();
            }
            return false;
        }

        public String toString() {
            return "State =>  k1: " + this.k1Keys.size() + " k1k2: " + this.k1k2Keys.size() + " completed: " + this.completed + " unsubscribed: " + this.unsubscribed;
        }
    }

    private static final class Outer<K1, K2, T> {
        private final Observer<GroupedObservable<K1, T>> subscriber;
        private final GroupedObservable<K2, GroupedObservable<K1, T>> group;

        private Outer(BufferUntilSubscriber<GroupedObservable<K1, T>> subscriber, GroupedObservable<K2, GroupedObservable<K1, T>> group) {
            this.subscriber = new SerializedObserver(subscriber);
            this.group = group;
        }

        public static <K1, K2, T> Outer<K1, K2, T> create(K2 key2) {
            final BufferUntilSubscriber subject = BufferUntilSubscriber.create();
            GroupedObservable group = GroupedObservable.create(key2, (Observable.OnSubscribe)new Observable.OnSubscribe<GroupedObservable<K1, T>>(){

                public void call(final Subscriber<? super GroupedObservable<K1, T>> o) {
                    subject.unsafeSubscribe(new Subscriber<GroupedObservable<K1, T>>(o){

                        public void onCompleted() {
                            o.onCompleted();
                        }

                        public void onError(Throwable e) {
                            o.onError(e);
                        }

                        public void onNext(GroupedObservable<K1, T> t) {
                            if (!this.isUnsubscribed()) {
                                o.onNext(t);
                            }
                        }
                    });
                }
            });
            return new Outer<K1, K2, T>(subject, group);
        }
    }

    private static final class Inner<K1, K2, T> {
        private final Observer<T> subscriber;
        private final GroupedObservable<K1, T> group;

        private Inner(BufferUntilSubscriber<T> subscriber, GroupedObservable<K1, T> group) {
            this.subscriber = new SerializedObserver(subscriber);
            this.group = group;
        }

        public static <K1, K2, T> Inner<K1, K2, T> create(final GroupState<K1, K2, T> groupState, final AtomicReference<State> state, Outer<K1, K2, T> outer, final KeyPair<K1, K2> keyPair) {
            final BufferUntilSubscriber subject = BufferUntilSubscriber.create();
            GroupedObservable group = GroupedObservable.create((Object)((KeyPair)keyPair).k1, (Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

                public void call(final Subscriber<? super T> o) {
                    o.add(Subscriptions.create((Action0)new Action0(){

                        public void call() {
                            groupState.completeK1K2Group(state, keyPair);
                        }
                    }));
                    subject.unsafeSubscribe(new Subscriber<T>(o){

                        public void onCompleted() {
                            groupState.completeK1K2Group(state, keyPair);
                            o.onCompleted();
                        }

                        public void onError(Throwable e) {
                            o.onError(e);
                        }

                        public void onNext(T t) {
                            if (!this.isUnsubscribed()) {
                                o.onNext(t);
                            }
                        }
                    });
                }
            });
            return new Inner<K1, K2, T>(subject, group);
        }
    }

    private static final class GroupState<K1, K2, T> {
        private final ConcurrentHashMap<KeyPair<K1, K2>, Inner<K1, K2, T>> innerSubjects = new ConcurrentHashMap();
        private final ConcurrentHashMap<K2, Outer<K1, K2, T>> outerSubjects = new ConcurrentHashMap();
        private final Subscription parentSubscription;
        private final Subscriber<? super GroupedObservable<K2, GroupedObservable<K1, T>>> child;
        volatile int completed;
        static final AtomicIntegerFieldUpdater<GroupState> COMPLETED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(GroupState.class, "completed");

        public GroupState(Subscription parentSubscription, Subscriber<? super GroupedObservable<K2, GroupedObservable<K1, T>>> child) {
            this.parentSubscription = parentSubscription;
            this.child = child;
        }

        public void startK1Group(AtomicReference<State> state, K1 key) {
            State newState;
            State current;
            while (!state.compareAndSet(current = state.get(), newState = current.addK1(key))) {
            }
        }

        public void completeK1Group(AtomicReference<State> state, K1 key) {
            State current;
            State newState = null;
            while (!state.compareAndSet(current = state.get(), newState = current.removeK1(key))) {
            }
            if (newState.shouldComplete()) {
                this.completeAll(newState);
            }
        }

        public void startK1K2Group(AtomicReference<State> state, KeyPair<K1, K2> keyPair) {
            State newState;
            State current;
            while (!state.compareAndSet(current = state.get(), newState = current.addK1k2(keyPair))) {
            }
        }

        public void completeK1K2Group(AtomicReference<State> state, KeyPair<K1, K2> keyPair) {
            State current;
            State newState = null;
            while (!state.compareAndSet(current = state.get(), newState = current.removeK1k2(keyPair))) {
            }
            if (newState.shouldComplete()) {
                this.completeAll(newState);
            }
        }

        public void completeAll(State state) {
            if (COMPLETED_UPDATER.compareAndSet(this, 0, 1)) {
                for (Map.Entry<K2, Outer<K1, K2, T>> entry : this.outerSubjects.entrySet()) {
                    ((Outer)entry.getValue()).subscriber.onCompleted();
                }
                for (Map.Entry<Object, Object> entry : this.innerSubjects.entrySet()) {
                    ((Inner)entry.getValue()).subscriber.onCompleted();
                }
                if (state.unsubscribed) {
                    this.parentSubscription.unsubscribe();
                }
                this.child.onCompleted();
            }
        }

        private Inner<K1, K2, T> getOrCreateFor(AtomicReference<State> state, Subscriber<? super GroupedObservable<K2, GroupedObservable<K1, T>>> child, K1 key1, K2 key2) {
            Outer<K1, K2, T> outer = this.getOrCreateOuter(state, child, key2);
            if (outer == null) {
                return null;
            }
            Inner<K1, K2, T> orCreateInnerSubject = this.getOrCreateInnerSubject(state, outer, key1, key2);
            return orCreateInnerSubject;
        }

        private Inner<K1, K2, T> getOrCreateInnerSubject(AtomicReference<State> state, Outer<K1, K2, T> outer, K1 key1, K2 key2) {
            KeyPair<K1, K2> keyPair = new KeyPair<K1, K2>(key1, key2);
            Inner<K1, K2, T> innerSubject = this.innerSubjects.get(keyPair);
            if (innerSubject != null) {
                return innerSubject;
            }
            Inner<K1, K2, T> newInner = Inner.create(this, state, outer, keyPair);
            Inner<K1, K2, T> existing = this.innerSubjects.putIfAbsent(keyPair, newInner);
            if (existing != null) {
                return existing;
            }
            this.startK1K2Group(state, keyPair);
            ((Outer)outer).subscriber.onNext((Object)((Inner)newInner).group);
            return newInner;
        }

        private Outer<K1, K2, T> getOrCreateOuter(AtomicReference<State> state, Subscriber<? super GroupedObservable<K2, GroupedObservable<K1, T>>> child, K2 key2) {
            Outer<K1, K2, T> outerSubject = this.outerSubjects.get(key2);
            if (outerSubject != null) {
                return outerSubject;
            }
            if (child.isUnsubscribed()) {
                return null;
            }
            Outer newOuter = Outer.create(key2);
            Outer existing = this.outerSubjects.putIfAbsent(key2, newOuter);
            if (existing != null) {
                return existing;
            }
            child.onNext((Object)newOuter.group);
            return newOuter;
        }
    }

    private static final class PivotSubscriber<K1, K2, T>
    extends Subscriber<GroupedObservable<K1, GroupedObservable<K2, T>>> {
        private final Subscriber<? super GroupedObservable<K2, GroupedObservable<K1, T>>> child;
        private final AtomicReference<State> state;
        private final GroupState<K1, K2, T> groups;

        private PivotSubscriber(Subscriber<? super GroupedObservable<K2, GroupedObservable<K1, T>>> child, AtomicReference<State> state) {
            this.child = child;
            this.state = state;
            this.groups = new GroupState((Subscription)this, child);
        }

        public void onCompleted() {
            State current;
            State newState = null;
            while (!this.state.compareAndSet(current = this.state.get(), newState = current.complete())) {
            }
            if (newState.shouldComplete()) {
                this.groups.completeAll(newState);
            }
        }

        public void onError(Throwable e) {
            this.child.onError(e);
        }

        public void onNext(final GroupedObservable<K1, GroupedObservable<K2, T>> k1Group) {
            this.groups.startK1Group(this.state, k1Group.getKey());
            k1Group.unsafeSubscribe(new Subscriber<GroupedObservable<K2, T>>(this){

                public void onCompleted() {
                    groups.completeK1Group(state, k1Group.getKey());
                }

                public void onError(Throwable e) {
                    child.onError(e);
                }

                public void onNext(GroupedObservable<K2, T> k2Group) {
                    final Inner inner = groups.getOrCreateFor(state, child, k1Group.getKey(), k2Group.getKey());
                    if (inner == null) {
                        return;
                    }
                    k2Group.unsafeSubscribe(new Subscriber<T>(this){

                        public void onCompleted() {
                        }

                        public void onError(Throwable e) {
                            inner.subscriber.onError(e);
                        }

                        public void onNext(T t) {
                            inner.subscriber.onNext(t);
                        }
                    });
                }
            });
        }
    }
}

