/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.internal;

import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;
import org.codehaus.jackson.map.ObjectWriter;

public class JsonUtility {
    private static final JsonUtility INSTANCE = new JsonUtility();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ObjectReader objectReader = this.objectMapper.reader(Map.class);
    private final ObjectWriter objectWriter = this.objectMapper.writerWithType(Map.class);

    private JsonUtility() {
    }

    public static Map<String, Object> jsonToMap(String jsonString) {
        return INSTANCE._jsonToMap(jsonString);
    }

    public static String mapToJson(Map<String, ? extends Object> map) {
        return INSTANCE._mapToJson(map);
    }

    private Map<String, Object> _jsonToMap(String jsonString) {
        try {
            return (Map)this.objectReader.readValue(jsonString);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse JSON", e);
        }
    }

    private String _mapToJson(Map<String, ? extends Object> map) {
        try {
            return this.objectWriter.writeValueAsString(map);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write JSON", e);
        }
    }
}

