/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.discovery;

import java.net.URI;

public class StreamAction {
    private final ActionType type;
    private final URI uri;

    private StreamAction(ActionType type, URI uri) {
        this.type = type;
        this.uri = uri;
    }

    public static StreamAction create(ActionType type, URI uri) {
        return new StreamAction(type, uri);
    }

    public ActionType getType() {
        return this.type;
    }

    public URI getUri() {
        return this.uri;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamAction other = (StreamAction)obj;
        if (this.type != other.type) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public String toString() {
        return "StreamAction [type=" + (Object)((Object)this.type) + ", uri=" + this.uri + "]";
    }

    public static enum ActionType {
        ADD,
        REMOVE;

    }
}

