/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.aggregator;

import com.netflix.turbine.aggregator.GroupKey;
import java.util.concurrent.ConcurrentHashMap;

public final class TypeAndNameKey
implements GroupKey {
    private final String key;
    private final String type;
    private final String name;
    private static ConcurrentHashMap<String, TypeAndNameKey> internedKeys = new ConcurrentHashMap();

    public static TypeAndNameKey from(String type, String name) {
        return internedKeys.computeIfAbsent(type + "_" + name, k -> new TypeAndNameKey((String)k, type, name));
    }

    private TypeAndNameKey(String key, String type, String name) {
        this.key = key;
        this.type = type;
        this.name = name;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "TypeAndName=>" + this.key;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeAndNameKey other = (TypeAndNameKey)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }
}

