/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.aggregator;

import com.netflix.turbine.aggregator.InstanceKey;
import com.netflix.turbine.internal.AggregateStringSerializer;
import com.netflix.turbine.internal.JsonUtility;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(using=AggregateStringSerializer.class)
public class AggregateString {
    private final Map<String, Integer> values;
    private final Set<InstanceKey> instances;
    private static AggregateString EMPTY = new AggregateString(Collections.emptyMap(), Collections.emptySet());

    private AggregateString(Map<String, Integer> values, Set<InstanceKey> instances) {
        this.values = values;
        this.instances = instances;
    }

    public static AggregateString create() {
        return EMPTY;
    }

    public static AggregateString create(String value, InstanceKey instanceKey) {
        if (instanceKey == null) {
            throw new NullPointerException("AggregateString can not have null InstanceKey. Value -> " + value);
        }
        return new AggregateString(Collections.singletonMap(value, 1), Collections.singleton(instanceKey));
    }

    public AggregateString update(String oldValue, String newValue, InstanceKey instanceKey) {
        Map<String, Integer> _values;
        Set<InstanceKey> _instances;
        if (instanceKey == null) {
            throw new NullPointerException("AggregateString can not have null InstanceKey. Value -> " + newValue);
        }
        boolean containsInstance = this.instances.contains(instanceKey);
        boolean valuesEqual = this.valuesEqual(oldValue, newValue);
        if (containsInstance && valuesEqual) {
            return this;
        }
        if (containsInstance && newValue != null) {
            _instances = this.instances;
        } else if (containsInstance && newValue == null) {
            _instances = new HashSet<InstanceKey>(this.instances);
            _instances.remove(instanceKey);
        } else {
            _instances = new HashSet<InstanceKey>(this.instances);
            _instances.add(instanceKey);
        }
        if (valuesEqual) {
            _values = this.values;
        } else {
            _values = new TreeMap<String, Integer>(this.values);
            if (oldValue != null) {
                _values.computeIfPresent(oldValue, (key, old) -> {
                    if (old == 1) {
                        return null;
                    }
                    return old - 1;
                });
            }
            if (newValue != null) {
                _values.merge(newValue, 1, (e, v) -> {
                    if (e == null) {
                        return v;
                    }
                    return e + v;
                });
            }
        }
        return new AggregateString(_values, _instances);
    }

    private boolean valuesEqual(String newValue, String oldValue) {
        if (newValue == oldValue) {
            return true;
        }
        return !(newValue == null ? oldValue != null : !newValue.equals(oldValue));
    }

    public Map<String, Integer> values() {
        return Collections.unmodifiableMap(this.values);
    }

    public Set<InstanceKey> instances() {
        return Collections.unmodifiableSet(this.instances);
    }

    public String toJson() {
        return JsonUtility.mapToJson(this.values);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " => " + this.toJson();
    }
}

