/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.utils;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class EventThrottle<K> {
    private AtomicInteger eventCount = new AtomicInteger(0);
    private volatile long lastEventTime = -1L;
    private final DynamicIntProperty eventFlushThreshold;
    private final DynamicIntProperty eventFlushDelayMillis;

    public EventThrottle(DynamicIntProperty eventThreshold, DynamicIntProperty flushDelay) {
        this.eventFlushThreshold = eventThreshold;
        this.eventFlushDelayMillis = flushDelay;
    }

    public boolean throttle(Collection<K> events) {
        return this.throttleEvents(events.size());
    }

    public boolean throttle(K event) {
        return this.throttleEvents(1);
    }

    private boolean throttleEvents(int size) {
        this.eventCount.addAndGet(size);
        boolean succeeded = false;
        while (!succeeded) {
            long delay = this.lastEventTime > 0L ? System.currentTimeMillis() - this.lastEventTime : (long)this.eventFlushDelayMillis.get();
            int count = this.eventCount.get();
            if (delay < (long)this.eventFlushDelayMillis.get() && count < this.eventFlushThreshold.get()) break;
            count = this.eventCount.get();
            succeeded = this.eventCount.compareAndSet(count, 0);
        }
        if (succeeded) {
            this.lastEventTime = System.currentTimeMillis();
            return false;
        }
        return true;
    }

    public static class UnitTest {
        private Random random = new Random();

        @Test
        public void testThrottleOnCountsOnly() throws Exception {
            DynamicIntProperty countThreshold = DynamicPropertyFactory.getInstance().getIntProperty("foo", 1000);
            DynamicIntProperty delayThreshold = DynamicPropertyFactory.getInstance().getIntProperty("bar", 10);
            EventThrottle<List<Integer>> throttle = new EventThrottle<List<Integer>>(countThreshold, delayThreshold);
            boolean shouldThrottle = throttle.throttle(this.getRandomIntegers(100));
            Assert.assertFalse((boolean)shouldThrottle);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(300));
            Assert.assertTrue((boolean)shouldThrottle);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(200));
            Assert.assertTrue((boolean)shouldThrottle);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(400));
            Assert.assertTrue((boolean)shouldThrottle);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(200));
            Assert.assertFalse((boolean)shouldThrottle);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(400));
            Assert.assertTrue((boolean)shouldThrottle);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(300));
            Assert.assertTrue((boolean)shouldThrottle);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(310));
            Assert.assertFalse((boolean)shouldThrottle);
        }

        @Test
        public void testThrottleOnTimeOnly() throws Exception {
            DynamicIntProperty countThreshold = DynamicPropertyFactory.getInstance().getIntProperty("foo", 100000);
            DynamicIntProperty delayThreshold = DynamicPropertyFactory.getInstance().getIntProperty("bar", 100);
            EventThrottle<List<Integer>> throttle = new EventThrottle<List<Integer>>(countThreshold, delayThreshold);
            boolean shouldThrottle = throttle.throttle(this.getRandomIntegers(100));
            Assert.assertFalse((boolean)shouldThrottle);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(300));
            Assert.assertTrue((boolean)shouldThrottle);
            Thread.sleep(120L);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(200));
            Assert.assertFalse((boolean)shouldThrottle);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(400));
            Assert.assertTrue((boolean)shouldThrottle);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(200));
            Assert.assertTrue((boolean)shouldThrottle);
            Thread.sleep(120L);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(400));
            Assert.assertFalse((boolean)shouldThrottle);
        }

        @Test
        public void testThrottleOnTimeAndCount() throws Exception {
            DynamicIntProperty countThreshold = DynamicPropertyFactory.getInstance().getIntProperty("foo", 1000);
            DynamicIntProperty delayThreshold = DynamicPropertyFactory.getInstance().getIntProperty("bar", 100);
            EventThrottle<List<Integer>> throttle = new EventThrottle<List<Integer>>(countThreshold, delayThreshold);
            boolean shouldThrottle = throttle.throttle(this.getRandomIntegers(100));
            Assert.assertFalse((boolean)shouldThrottle);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(300));
            Assert.assertTrue((boolean)shouldThrottle);
            Thread.sleep(120L);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(200));
            Assert.assertFalse((boolean)shouldThrottle);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(400));
            Assert.assertTrue((boolean)shouldThrottle);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(700));
            Assert.assertFalse((boolean)shouldThrottle);
            Thread.sleep(120L);
            shouldThrottle = throttle.throttle(this.getRandomIntegers(400));
            Assert.assertFalse((boolean)shouldThrottle);
        }

        private List<Integer> getRandomIntegers(int n) {
            ArrayList<Integer> list = new ArrayList<Integer>(n);
            for (int i = 0; i < n; ++i) {
                list.add(this.random.nextInt());
            }
            return list;
        }
    }
}

