/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.monitor.instance;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.turbine.data.DataFromSingleInstance;
import com.netflix.turbine.monitor.MonitorConsole;
import com.netflix.turbine.monitor.TurbineDataMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaleConnectionMonitorReaper {
    private static final Logger logger = LoggerFactory.getLogger(StaleConnectionMonitorReaper.class);
    private final DynamicIntProperty StalenessThreshold = DynamicPropertyFactory.getInstance().getIntProperty("turbine.StaleConnectionMonitorReaper.StalenessThreshold", 30000);
    private final DynamicIntProperty RunFrequencyMillis = DynamicPropertyFactory.getInstance().getIntProperty("turbine.StaleConnectionMonitorReaper.RunFrequencyMillis", 20000);
    private final DynamicBooleanProperty ReaperEnabled = DynamicPropertyFactory.getInstance().getBooleanProperty("turbine.StaleConnectionMonitorReaper.Enabled", false);
    private final AtomicReference<List<MonitorConsole<DataFromSingleInstance>>> monitorConsoles = new AtomicReference(new ArrayList());
    private final Timer timer = new Timer();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    public static StaleConnectionMonitorReaper Instance = new StaleConnectionMonitorReaper();

    private StaleConnectionMonitorReaper() {
    }

    public void addMonitorConsole(MonitorConsole<DataFromSingleInstance> console) {
        ArrayList<MonitorConsole<DataFromSingleInstance>> newList = new ArrayList<MonitorConsole<DataFromSingleInstance>>((Collection)this.monitorConsoles.get());
        newList.add(console);
        this.monitorConsoles.set(newList);
    }

    public void removeMonitorConsole(MonitorConsole<DataFromSingleInstance> consoleToBeRemoved) {
        ArrayList newList = new ArrayList(this.monitorConsoles.get());
        newList.remove(consoleToBeRemoved);
        this.monitorConsoles.set(newList);
    }

    public void start() {
        if (this.started.get()) {
            return;
        }
        if (this.stopped.get()) {
            return;
        }
        boolean success = this.started.compareAndSet(false, true);
        if (!success) {
            return;
        }
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                StaleConnectionMonitorReaper.this.checkStaleMonitors();
            }
        }, 60000L, (long)this.RunFrequencyMillis.get());
    }

    public void stop() {
        this.stopped.set(true);
        this.timer.cancel();
    }

    private void checkStaleMonitors() {
        if (this.stopped.get()) {
            return;
        }
        if (!this.ReaperEnabled.get()) {
            return;
        }
        logger.info("Checking for stale connections");
        for (MonitorConsole<DataFromSingleInstance> console : this.monitorConsoles.get()) {
            Collection<TurbineDataMonitor<DataFromSingleInstance>> monitors = console.getAllMonitors();
            for (TurbineDataMonitor<DataFromSingleInstance> instanceMonitor : monitors) {
                long staleness;
                long lastEventUpdate = instanceMonitor.getLastEventUpdateTime();
                if (lastEventUpdate == -1L || (staleness = System.currentTimeMillis() - lastEventUpdate) <= (long)this.StalenessThreshold.get()) continue;
                logger.info("Terminating InstanceMonitor due to staleness threshold breach, " + instanceMonitor.getName());
                try {
                    instanceMonitor.stopMonitor();
                }
                catch (Exception e) {
                    logger.error("Could not terminate InstanceMonitor due to staleness threshold breach, " + instanceMonitor.getName(), (Throwable)e);
                }
            }
        }
    }
}

