/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.monitor.instance;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.turbine.data.DataFromSingleInstance;
import com.netflix.turbine.discovery.Instance;
import com.netflix.turbine.handler.PerformanceCriteria;
import com.netflix.turbine.handler.TurbineDataDispatcher;
import com.netflix.turbine.handler.TurbineDataHandler;
import com.netflix.turbine.monitor.MonitorConsole;
import com.netflix.turbine.monitor.TurbineDataMonitor;
import com.netflix.turbine.monitor.instance.InstanceUrlClosure;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.NoRouteToHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceMonitor
extends TurbineDataMonitor<DataFromSingleInstance> {
    private static final Logger logger = LoggerFactory.getLogger(InstanceMonitor.class);
    private static final ThreadFactory InstanceMonitorThreadFactory = new ThreadFactory(){
        private static final String ThreadName = "InstanceMonitor";
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.defaultFactory.newThread(r);
            thread.setName(ThreadName);
            return thread;
        }
    };
    public static final ExecutorService ThreadPool = Executors.newCachedThreadPool(InstanceMonitorThreadFactory);
    private static DynamicBooleanProperty skipLineLogic = DynamicPropertyFactory.getInstance().getBooleanProperty("turbine.InstanceMonitor.eventStream.skipLineLogic.enabled", true);
    private static DynamicIntProperty latencyThreshold = DynamicPropertyFactory.getInstance().getIntProperty("turbine.InstanceMonitor.eventStream.skipLineLogic.latencyThreshold", 2500);
    private static DynamicIntProperty skipLogicDelay = DynamicPropertyFactory.getInstance().getIntProperty("turbine.InstanceMonitor.eventStream.skipLineLogic.delay", 500);
    private static DynamicIntProperty hostRetryMillis = DynamicPropertyFactory.getInstance().getIntProperty("turbine.InstanceMonitor.hostRertyMillis", 1000);
    private final AtomicReference<State> monitorState = new AtomicReference<State>(State.NotStarted);
    private final Instance host;
    private final TurbineDataDispatcher<DataFromSingleInstance> dispatcher;
    private final MonitorConsole<DataFromSingleInstance> monitorConsole;
    private BufferedReader reader;
    private final GatewayHttpClient gatewayHttpClient;
    private final String url;
    private static final String NAME_KEY = "name";
    private static final String TYPE_KEY = "type";
    private static final String CURRENT_TIME = "currentTime";
    private static final String DATA_PREFIX = "data";
    private static final String OPEN_BRACE = "{";
    private static final String REPORTING_HOSTS = "reportingHosts";
    private final ObjectReader objectReader;
    private volatile Future<Void> taskFuture;
    private final AtomicLong lastEventUpdateTime = new AtomicLong(-1L);
    private final DynamicBooleanProperty LogEnabled;

    public InstanceMonitor(Instance host, InstanceUrlClosure urlClosure, TurbineDataDispatcher<DataFromSingleInstance> dispatcher, MonitorConsole<DataFromSingleInstance> monitorConsole) {
        this(host, new ProdGatewayHttpClient(), urlClosure, dispatcher, monitorConsole);
    }

    private InstanceMonitor(Instance host, GatewayHttpClient httpClient, InstanceUrlClosure urlClosure, TurbineDataDispatcher<DataFromSingleInstance> dispatcher, MonitorConsole<DataFromSingleInstance> monitorConsole) {
        this.host = host;
        this.gatewayHttpClient = httpClient;
        this.dispatcher = dispatcher;
        this.monitorConsole = monitorConsole;
        this.url = urlClosure.getUrlPath(host);
        logger.info("Url for host: " + this.url + " " + host.getCluster());
        ObjectMapper objectMapper = new ObjectMapper();
        this.objectReader = objectMapper.reader(Map.class);
        this.LogEnabled = DynamicPropertyFactory.getInstance().getBooleanProperty("InstanceMonitor.LogEnabled." + host.getHostname(), false);
    }

    @Override
    public String getName() {
        return this.host.getHostname();
    }

    @Override
    public Instance getStatsInstance() {
        return this.host;
    }

    @Override
    public TurbineDataDispatcher<DataFromSingleInstance> getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void startMonitor() throws Exception {
        if (this.monitorState.get() != State.NotStarted) {
            return;
        }
        this.taskFuture = ThreadPool.submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                try {
                    InstanceMonitor.this.init();
                    InstanceMonitor.this.monitorState.set(State.Running);
                    while (InstanceMonitor.this.monitorState.get() == State.Running) {
                        InstanceMonitor.this.doWork();
                    }
                }
                catch (Throwable t) {
                    logger.warn("Stopping InstanceMonitor for: " + InstanceMonitor.this.getStatsInstance().getHostname() + " " + InstanceMonitor.this.getStatsInstance().getCluster(), t);
                }
                finally {
                    if (InstanceMonitor.this.monitorState.get() == State.Running) {
                        InstanceMonitor.this.monitorState.set(State.StopRequested);
                    }
                    InstanceMonitor.this.cleanup();
                    InstanceMonitor.this.monitorState.set(State.CleanedUp);
                }
                return null;
            }
        });
    }

    @Override
    public void stopMonitor() {
        this.monitorState.set(State.StopRequested);
        logger.info("Host monitor stop requested: " + this.getName());
        if (this.taskFuture != null) {
            logger.info("Cancelling InstanceMonitor task future");
            this.taskFuture.cancel(true);
        }
    }

    @Override
    public long getLastEventUpdateTime() {
        return this.lastEventUpdateTime.get();
    }

    private void doWork() throws Exception {
        DataFromSingleInstance instanceData = null;
        instanceData = this.getNextStatsData();
        if (instanceData == null) {
            return;
        }
        this.lastEventUpdateTime.set(System.currentTimeMillis());
        ArrayList<DataFromSingleInstance> list = new ArrayList<DataFromSingleInstance>();
        list.add(instanceData);
        boolean continueRunning = this.dispatcher.pushData(this.getStatsInstance(), (DataFromSingleInstance)((Object)list));
        if (!continueRunning) {
            logger.info("No more listeners to the host monitor, stopping monitor for: " + this.host.getHostname() + " " + this.host.getCluster());
            this.monitorState.set(State.StopRequested);
            return;
        }
    }

    private void init() throws Exception {
        HttpGet httpget = new HttpGet(this.url);
        HttpResponse response = this.gatewayHttpClient.getHttpClient().execute((HttpUriRequest)httpget);
        HttpEntity entity = response.getEntity();
        InputStream is = entity.getContent();
        this.reader = new BufferedReader(new InputStreamReader(is));
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            List responseMessage = IOUtils.readLines((Reader)this.reader);
            logger.error("Could not initiate connection to host, giving up: " + responseMessage);
            throw new MisconfiguredHostException(responseMessage.toString());
        }
    }

    private void cleanup() throws Exception {
        if (this.monitorState.get() == State.CleanedUp) {
            return;
        }
        logger.info("Single Server event publisher releasing http client connection for: " + this.host.getHostname() + " " + this.host.getCluster());
        this.gatewayHttpClient.releaseConnections();
        this.dispatcher.handleHostLost(this.getStatsInstance());
        logger.info("Removing monitor from StatsEventConsole: " + this.host.getHostname() + " " + this.host.getCluster());
        this.monitorConsole.removeMonitor(this.getName());
        this.monitorState.set(State.CleanedUp);
    }

    /*
     * Exception decompiling
     */
    private DataFromSingleInstance getNextStatsData() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryHostConnection() throws Exception {
        boolean succeeded = false;
        while (!succeeded && this.monitorState.get() == State.Running) {
            this.gatewayHttpClient.releaseConnections();
            try {
                logger.info("Re-initing host connection: " + this.host.getHostname() + " " + this.host.getCluster());
                this.init();
                succeeded = true;
            }
            catch (NoRouteToHostException e) {
                logger.warn("Found no route to host connection: " + this.host.getHostname() + " " + this.host.getCluster() + " will not retry", (Throwable)e);
                this.monitorState.set(State.StopRequested);
            }
            catch (MisconfiguredHostException e) {
                logger.warn("Found MisconfiguredHostException host connection: " + this.host.getHostname() + " " + this.host.getCluster() + " will not retry", (Throwable)e);
                this.monitorState.set(State.StopRequested);
            }
            catch (Exception e) {
                logger.warn("Could not init host connection: " + this.host.getHostname() + " " + this.host.getCluster() + " will continue to retry", (Throwable)e);
            }
            finally {
                try {
                    Thread.sleep(hostRetryMillis.get());
                }
                catch (InterruptedException ie) {
                    logger.warn("Instance Monitor got interrupted");
                    this.monitorState.set(State.StopRequested);
                }
            }
        }
        if (this.monitorState.get() != State.Running) {
            throw new Exception("Giving up on retry connection");
        }
    }

    public boolean monitorRunning() {
        return this.monitorState.get() == State.Running;
    }

    public boolean hasStopped() {
        return this.monitorState.get() == State.CleanedUp;
    }

    public static void stop() {
        ThreadPool.shutdown();
    }

    public static class UnitTest {
        Instance instance = new Instance("testInstance", "testCluster", true);
        HttpClient mockClient;
        ClientConnectionManager mockConnManager;
        GatewayHttpClient gatewayClient;
        InstanceMonitor monitor;
        TurbineDataDispatcher<DataFromSingleInstance> dispatcher;
        PerformanceCriteria perfCriteria = new PerformanceCriteria(){

            @Override
            public boolean isCritical() {
                return false;
            }

            @Override
            public int getMaxQueueSize() {
                return 1;
            }

            @Override
            public int numThreads() {
                return 0;
            }
        };
        TurbineDataHandler<DataFromSingleInstance> eventHandler;
        File file;
        private static PerformanceCriteria testCriteria = new PerformanceCriteria(){

            @Override
            public boolean isCritical() {
                return false;
            }

            @Override
            public int getMaxQueueSize() {
                return 10000;
            }

            @Override
            public int numThreads() {
                return 10;
            }
        };

        @Before
        public void before() {
            this.file = new File("main/testfiles/StatsSingleServerMonitorUnitTest.txt");
            if (!this.file.exists()) {
                this.file = new File("testfiles/StatsSingleServerMonitorUnitTest.txt");
            }
        }

        private void doTheMockMagic(InputStream dataStream) throws Exception {
            ConfigurationManager.getConfigInstance().setProperty("turbine.InstanceMonitor.eventStream.skipLineLogic.enabled", (Object)false);
            StatusLine sLine = (StatusLine)Mockito.mock(StatusLine.class);
            Mockito.when((Object)sLine.getStatusCode()).thenReturn((Object)200);
            HttpResponse mockResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
            Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)new InputStreamEntity(dataStream, -1L));
            Mockito.when((Object)mockResponse.getStatusLine()).thenReturn((Object)sLine);
            this.mockConnManager = (ClientConnectionManager)Mockito.mock(ClientConnectionManager.class);
            this.mockClient = (HttpClient)Mockito.mock(HttpClient.class);
            Mockito.when((Object)this.mockClient.execute((HttpUriRequest)Matchers.any(HttpUriRequest.class))).thenReturn((Object)mockResponse);
            Mockito.when((Object)this.mockClient.getConnectionManager()).thenReturn((Object)this.mockConnManager);
            this.gatewayClient = new GatewayHttpClient(){

                @Override
                public HttpClient getHttpClient() {
                    return UnitTest.this.mockClient;
                }

                @Override
                public void releaseConnections() {
                    UnitTest.this.mockConnManager.shutdown();
                }
            };
            InstanceUrlClosure urlClosure = (InstanceUrlClosure)Mockito.mock(InstanceUrlClosure.class);
            Mockito.when((Object)urlClosure.getUrlPath(this.instance)).thenReturn((Object)"http://foo.com/");
            this.dispatcher = new TurbineDataDispatcher("TEST");
            this.monitor = new InstanceMonitor(this.instance, this.gatewayClient, urlClosure, this.dispatcher, new MonitorConsole());
            this.eventHandler = (TurbineDataHandler)Mockito.mock(TurbineDataHandler.class);
            Mockito.when((Object)this.eventHandler.getName()).thenReturn((Object)"handler");
            Mockito.when((Object)this.eventHandler.getCriteria()).thenReturn((Object)this.perfCriteria);
            this.monitor.getDispatcher().registerEventHandler(this.instance, this.eventHandler);
        }

        @Test
        public void testProcessFiniteStream() throws Exception {
            this.doTheMockMagic(new FileInputStream(this.file));
            this.monitor.startMonitor();
            Thread.sleep(1000L);
            ((ClientConnectionManager)Mockito.verify((Object)this.mockConnManager, (VerificationMode)Mockito.times((int)1))).shutdown();
            ((TurbineDataHandler)Mockito.verify(this.eventHandler, (VerificationMode)Mockito.never())).handleHostLost(this.instance);
            this.monitor.stopMonitor();
            Thread.sleep(500L);
            ((TurbineDataHandler)Mockito.verify(this.eventHandler, (VerificationMode)Mockito.times((int)1))).handleHostLost(this.instance);
            Assert.assertNull(this.monitor.getDispatcher().findHandlerForHost(this.instance, "handler"));
            this.dispatcher.stopDispatcher();
        }

        @Test(timeout=2000L)
        public void testProcessInfiniteStream() throws Exception {
            this.doTheMockMagic(new InfiniteInputStream());
            this.monitor.startMonitor();
            Thread.sleep(1000L);
            Assert.assertTrue((boolean)this.monitor.monitorRunning());
            this.monitor.stopMonitor();
            while (!this.monitor.hasStopped()) {
                Thread.sleep(50L);
            }
            ((ClientConnectionManager)Mockito.verify((Object)this.mockConnManager, (VerificationMode)Mockito.times((int)1))).shutdown();
            ((TurbineDataHandler)Mockito.verify(this.eventHandler, (VerificationMode)Mockito.times((int)1))).handleHostLost(this.instance);
            Assert.assertNull(this.monitor.getDispatcher().findHandlerForHost(this.instance, "handler"));
            this.dispatcher.stopDispatcher();
        }

        @Test
        public void testInfiniteRetryOnIOException() throws Exception {
            TimeBombInputStream timeBombStream = new TimeBombInputStream();
            this.doTheMockMagic(timeBombStream);
            this.monitor.startMonitor();
            Thread.sleep(100L);
            Assert.assertTrue((boolean)this.monitor.monitorRunning());
            Thread.sleep(3000L);
            Assert.assertTrue((boolean)this.monitor.monitorRunning());
            Assert.assertTrue((timeBombStream.count.get() >= 1 ? 1 : 0) != 0);
            ((ClientConnectionManager)Mockito.verify((Object)this.mockConnManager, (VerificationMode)Mockito.atLeastOnce())).shutdown();
            ((TurbineDataHandler)Mockito.verify(this.eventHandler, (VerificationMode)Mockito.never())).handleHostLost(this.instance);
            this.monitor.stopMonitor();
            Assert.assertFalse((boolean)this.monitor.monitorRunning());
            Thread.sleep(2000L);
            ((ClientConnectionManager)Mockito.verify((Object)this.mockConnManager, (VerificationMode)Mockito.atLeastOnce())).shutdown();
            ((TurbineDataHandler)Mockito.verify(this.eventHandler, (VerificationMode)Mockito.times((int)1))).handleHostLost(this.instance);
            Assert.assertNull(this.monitor.getDispatcher().findHandlerForHost(this.instance, "handler"));
            Assert.assertTrue((boolean)this.monitor.hasStopped());
            this.dispatcher.stopDispatcher();
        }

        @Test(timeout=2000L)
        public void testStartMonitorAndNoEventHandlers() throws Exception {
            this.doTheMockMagic(new InfiniteInputStream());
            this.monitor.getDispatcher().deregisterEventHandler("handler");
            this.monitor.startMonitor();
            Thread.sleep(200L);
            while (this.monitor.monitorRunning()) {
                Thread.sleep(50L);
            }
            ((ClientConnectionManager)Mockito.verify((Object)this.mockConnManager, (VerificationMode)Mockito.atLeastOnce())).shutdown();
            Assert.assertNull(this.monitor.getDispatcher().findHandlerForHost(this.instance, "handler"));
            this.dispatcher.stopDispatcher();
        }

        @Test
        public void testStopMonitorOnNoRouteToHostException() throws Exception {
            TimeBombInputStream timeBombStream = new TimeBombInputStream();
            ConfigurationManager.getConfigInstance().setProperty("turbine.InstanceMonitor.eventStream.skipLineLogic.enabled", (Object)false);
            StatusLine sLine = (StatusLine)Mockito.mock(StatusLine.class);
            Mockito.when((Object)sLine.getStatusCode()).thenReturn((Object)200);
            HttpResponse mockResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
            Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)new InputStreamEntity((InputStream)timeBombStream, -1L));
            Mockito.when((Object)mockResponse.getStatusLine()).thenReturn((Object)sLine);
            this.mockConnManager = (ClientConnectionManager)Mockito.mock(ClientConnectionManager.class);
            this.mockClient = (HttpClient)Mockito.mock(HttpClient.class);
            Mockito.when((Object)this.mockClient.execute((HttpUriRequest)Matchers.any(HttpUriRequest.class))).thenReturn((Object)mockResponse).thenThrow(new Throwable[]{new NoRouteToHostException()});
            Mockito.when((Object)this.mockClient.getConnectionManager()).thenReturn((Object)this.mockConnManager);
            this.gatewayClient = new GatewayHttpClient(){

                @Override
                public HttpClient getHttpClient() {
                    return UnitTest.this.mockClient;
                }

                @Override
                public void releaseConnections() {
                    UnitTest.this.mockConnManager.shutdown();
                }
            };
            InstanceUrlClosure urlClosure = (InstanceUrlClosure)Mockito.mock(InstanceUrlClosure.class);
            Mockito.when((Object)urlClosure.getUrlPath(this.instance)).thenReturn((Object)"http://foo.com/");
            this.dispatcher = new TurbineDataDispatcher("TEST");
            this.monitor = new InstanceMonitor(this.instance, this.gatewayClient, urlClosure, this.dispatcher, new MonitorConsole());
            this.eventHandler = (TurbineDataHandler)Mockito.mock(TurbineDataHandler.class);
            Mockito.when((Object)this.eventHandler.getName()).thenReturn((Object)"handler");
            Mockito.when((Object)this.eventHandler.getCriteria()).thenReturn((Object)this.perfCriteria);
            this.monitor.getDispatcher().registerEventHandler(this.instance, this.eventHandler);
            this.monitor.startMonitor();
            Thread.sleep(2000L);
            Assert.assertFalse((boolean)this.monitor.monitorRunning());
            ((ClientConnectionManager)Mockito.verify((Object)this.mockConnManager, (VerificationMode)Mockito.times((int)2))).shutdown();
            ((TurbineDataHandler)Mockito.verify(this.eventHandler, (VerificationMode)Mockito.times((int)1))).handleHostLost(this.instance);
            Assert.assertNull(this.monitor.getDispatcher().findHandlerForHost(this.instance, "handler"));
            Assert.assertTrue((boolean)this.monitor.hasStopped());
            this.dispatcher.stopDispatcher();
        }

        @Test
        public void testStartMonitorsAndTransientEventHandlers() throws Exception {
            this.doTheMockMagic(new InfiniteInputStream());
            this.monitor.getDispatcher().deregisterEventHandler("handler");
            StatsCounter c1 = new StatsCounter("c1");
            this.monitor.getDispatcher().registerEventHandler(this.instance, c1);
            this.monitor.startMonitor();
            Thread.sleep(500L);
            StatsCounter c2 = new StatsCounter("c2");
            this.monitor.getDispatcher().registerEventHandler(this.instance, c2);
            Thread.sleep(500L);
            Assert.assertNotNull(this.monitor.getDispatcher().findHandlerForHost(this.instance, "c1"));
            Assert.assertNotNull(this.monitor.getDispatcher().findHandlerForHost(this.instance, "c2"));
            Assert.assertFalse((boolean)c1.handleHostLostCalled);
            Assert.assertFalse((boolean)c2.handleHostLostCalled);
            this.monitor.getDispatcher().deregisterEventHandler("c2");
            Thread.sleep(500L);
            this.monitor.getDispatcher().deregisterEventHandler("c1");
            while (this.monitor.monitorRunning()) {
                Thread.sleep(50L);
            }
            Assert.assertNull(this.monitor.getDispatcher().findHandlerForHost(this.instance, "handler"));
            Assert.assertNull(this.monitor.getDispatcher().findHandlerForHost(this.instance, "c1"));
            Assert.assertNull(this.monitor.getDispatcher().findHandlerForHost(this.instance, "c2"));
            Assert.assertTrue((c1.getCount() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((c2.getCount() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((c1.getCount() > c2.getCount() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)c1.handleHostLostCalled);
            Assert.assertTrue((boolean)c2.handleHostLostCalled);
            this.dispatcher.stopDispatcher();
        }

        private class TimeBombInputStream
        extends InfiniteInputStream {
            private volatile boolean blowUp;
            private final AtomicInteger count;

            private TimeBombInputStream() {
                this.blowUp = false;
                this.count = new AtomicInteger(0);
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        TimeBombInputStream.this.blowUp = true;
                    }
                };
                Timer timer = new Timer();
                timer.schedule(task, 500L);
            }

            @Override
            public int read() throws IOException {
                if (this.blowUp) {
                    this.count.incrementAndGet();
                    throw new IOException("Kaboom");
                }
                return super.read();
            }
        }

        private class StatsCounter
        implements TurbineDataHandler<DataFromSingleInstance> {
            private AtomicInteger count = new AtomicInteger(0);
            private boolean handleHostLostCalled = false;
            String nameS;

            StatsCounter(String name) {
                this.nameS = name;
            }

            @Override
            public String getName() {
                return this.nameS;
            }

            @Override
            public void handleData(Collection<DataFromSingleInstance> stats) {
                this.count.addAndGet(stats.size());
            }

            @Override
            public void handleHostLost(Instance host) {
                this.handleHostLostCalled = true;
            }

            int getCount() {
                return this.count.get();
            }

            @Override
            public PerformanceCriteria getCriteria() {
                return testCriteria;
            }
        }

        class InfiniteInputStream
        extends InputStream {
            InputStream in = null;

            InfiniteInputStream() {
            }

            @Override
            public int read() throws IOException {
                int read;
                if (this.in == null) {
                    this.in = new FileInputStream(UnitTest.this.file);
                }
                if ((read = this.in.read()) != -1) {
                    return read;
                }
                this.in.close();
                this.in = new FileInputStream(UnitTest.this.file);
                return this.in.read();
            }
        }
    }

    private class MisconfiguredHostException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MisconfiguredHostException(String arg0) {
            super(arg0);
        }
    }

    private static class ProdGatewayHttpClient
    implements GatewayHttpClient {
        HttpClient httpClient;

        private ProdGatewayHttpClient() {
        }

        @Override
        public HttpClient getHttpClient() {
            this.httpClient = new DefaultHttpClient();
            HttpParams httpParams = this.httpClient.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)10000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)10000);
            return this.httpClient;
        }

        @Override
        public void releaseConnections() {
            try {
                if (this.httpClient != null && this.httpClient.getConnectionManager() != null) {
                    this.httpClient.getConnectionManager().shutdown();
                    this.httpClient = null;
                }
            }
            catch (Exception e) {
                logger.error("We failed closing connection to the HTTP server", (Throwable)e);
            }
        }
    }

    private static interface GatewayHttpClient {
        public HttpClient getHttpClient();

        public void releaseConnections();
    }

    private static enum State {
        NotStarted,
        Running,
        StopRequested,
        CleanedUp;

    }
}

