/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.discovery;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Instance
implements Comparable<Instance> {
    private final String hostname;
    private final String cluster;
    private final boolean isUp;
    private final Map<String, String> attributes;

    public Instance(String host, String clusterName, boolean status) {
        this.hostname = host;
        this.cluster = clusterName;
        this.isUp = status;
        this.attributes = new HashMap<String, String>();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Instance other = (Instance)obj;
        boolean equals = true;
        equals &= this.hostname != null ? this.hostname.equals(other.hostname) : other.hostname == null;
        equals &= this.cluster != null ? this.cluster.equals(other.cluster) : other.cluster == null;
        return equals &= this.isUp == other.isUp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (this.cluster == null ? 0 : this.cluster.hashCode());
        result = 31 * result + (this.isUp ? 1 : 0);
        return result;
    }

    public String toString() {
        return "StatsInstance [hostname=" + this.hostname + ", cluster: " + this.cluster + ", isUp: " + this.isUp + ", attrs=" + this.attributes.toString() + "]";
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getCluster() {
        return this.cluster;
    }

    public boolean isUp() {
        return this.isUp;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public int compareTo(Instance other) {
        return this.getHostname().compareTo(other.getHostname());
    }

    public static class UnitTest {
        @Test
        public void testHostEquals() throws Exception {
            Instance host1 = new Instance("h1", "c1", true);
            Instance host2 = new Instance("h1", "c2", false);
            Instance host3 = new Instance("h2", "c1", true);
            Assert.assertFalse((boolean)host1.equals(host2));
            Assert.assertFalse((boolean)host1.equals(host3));
            Assert.assertFalse((boolean)host2.equals(host3));
        }
    }
}

