/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.data.meta;

import com.netflix.turbine.data.DataFromSingleInstance;
import com.netflix.turbine.data.TurbineData;
import com.netflix.turbine.data.meta.MetaInfoAdaptor;
import com.netflix.turbine.monitor.TurbineDataMonitor;
import com.netflix.turbine.monitor.cluster.ClusterMonitor;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;

public class MetaInformation<K extends TurbineData> {
    protected final ClusterMonitor<K> clusterMonitor;
    protected final MetaInfoAdaptor<K> metaInfoAdaptor;
    protected final AtomicLong lastUpdateTime = new AtomicLong(0L);
    protected final AtomicLong numReportingHosts = new AtomicLong(0L);
    public static final String Meta = "meta";
    public static final String ReportingHostsLast10Seconds = "reportingHostsLast10Seconds";
    public static final String Timestamp = "timestamp";

    public MetaInformation(ClusterMonitor<K> monitor, MetaInfoAdaptor<K> adaptor) {
        this.clusterMonitor = monitor;
        this.metaInfoAdaptor = adaptor;
    }

    public boolean shouldStream() {
        return this.lastUpdateTime.get() == 0L || System.currentTimeMillis() - this.lastUpdateTime.get() > 3000L;
    }

    public void update() {
        Collection<TurbineDataMonitor<DataFromSingleInstance>> allHostMonitors = this.clusterMonitor.getInstanceMonitors().getAllMonitors();
        long now = System.currentTimeMillis();
        int sum = 0;
        for (TurbineDataMonitor<DataFromSingleInstance> hostMonitor : allHostMonitors) {
            long lastHostUpdate = hostMonitor.getLastEventUpdateTime();
            if (lastHostUpdate <= 0L || now - lastHostUpdate >= 10000L) continue;
            ++sum;
        }
        this.numReportingHosts.set(sum);
    }

    public void streamDataToListeners() {
        this.clusterMonitor.getDispatcher().pushData(this.clusterMonitor.getStatsInstance(), this.metaInfoAdaptor.getData(this));
        this.lastUpdateTime.set(System.currentTimeMillis());
    }

    public long getReportingHosts() {
        return this.numReportingHosts.get();
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime.get();
    }
}

