/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.data.meta;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.turbine.data.meta.MetaInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;

public class MetaInfoUpdator {
    private static final DynamicBooleanProperty UpdatorEnabled = DynamicPropertyFactory.getInstance().getBooleanProperty("turbine.MetaInfoUpdator.enabled", true);
    private static final DynamicIntProperty UpdatorFrequencyMillis = DynamicPropertyFactory.getInstance().getIntProperty("turbine.MetaInfoUpdator.runMillis", 1000);
    private final Timer timer = new Timer();
    private final AtomicReference<List<MetaInformation<?>>> metaInfoReference = new AtomicReference(new ArrayList());
    public static final MetaInfoUpdator Instance = new MetaInfoUpdator();

    private MetaInfoUpdator() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!UpdatorEnabled.get()) {
                    return;
                }
                for (MetaInformation metaInfo : (List)MetaInfoUpdator.this.metaInfoReference.get()) {
                    if (!metaInfo.shouldStream()) continue;
                    metaInfo.update();
                    metaInfo.streamDataToListeners();
                }
            }
        }, 1000L, (long)UpdatorFrequencyMillis.get());
    }

    public static void addMetaInfo(MetaInformation<?> metaInfo) {
        if (metaInfo == null) {
            return;
        }
        ArrayList newList = new ArrayList((Collection)MetaInfoUpdator.Instance.metaInfoReference.get());
        newList.add(metaInfo);
        MetaInfoUpdator.Instance.metaInfoReference.set(newList);
    }

    public static void removeMetaInfo(MetaInformation<?> metaInfo) {
        if (metaInfo == null) {
            return;
        }
        ArrayList newList = new ArrayList(MetaInfoUpdator.Instance.metaInfoReference.get());
        newList.remove(metaInfo);
        MetaInfoUpdator.Instance.metaInfoReference.set(newList);
    }

    public void stop() {
        this.timer.cancel();
    }
}

