/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.niws.loadbalancer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.discovery.CacheRefreshedEvent;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaEvent;
import com.netflix.discovery.EurekaEventListener;
import com.netflix.loadbalancer.ServerListUpdater;
import com.netflix.niws.loadbalancer.LegacyEurekaClientProvider;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaNotificationServerListUpdater
implements ServerListUpdater {
    private static final Logger logger = LoggerFactory.getLogger(EurekaNotificationServerListUpdater.class);
    private final AtomicBoolean isActive = new AtomicBoolean(false);
    private final AtomicLong lastUpdated = new AtomicLong(System.currentTimeMillis());
    private final Provider<EurekaClient> eurekaClientProvider;
    private final ExecutorService refreshExecutor;
    private volatile EurekaEventListener updateListener;
    private volatile EurekaClient eurekaClient;

    public static ExecutorService getDefaultRefreshExecutor() {
        return LazyHolder.DEFAULT_SERVER_LIST_UPDATE_EXECUTOR;
    }

    public EurekaNotificationServerListUpdater() {
        this(new LegacyEurekaClientProvider());
    }

    public EurekaNotificationServerListUpdater(Provider<EurekaClient> eurekaClientProvider) {
        this(eurekaClientProvider, EurekaNotificationServerListUpdater.getDefaultRefreshExecutor());
    }

    public EurekaNotificationServerListUpdater(Provider<EurekaClient> eurekaClientProvider, ExecutorService refreshExecutor) {
        this.eurekaClientProvider = eurekaClientProvider;
        this.refreshExecutor = refreshExecutor;
    }

    public synchronized void start(final ServerListUpdater.UpdateAction updateAction) {
        if (this.isActive.compareAndSet(false, true)) {
            this.updateListener = new EurekaEventListener(){

                public void onEvent(EurekaEvent event) {
                    if (event instanceof CacheRefreshedEvent) {
                        EurekaNotificationServerListUpdater.this.refreshExecutor.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    updateAction.doUpdate();
                                    EurekaNotificationServerListUpdater.this.lastUpdated.set(System.currentTimeMillis());
                                }
                                catch (Exception e) {
                                    logger.warn("Failed to update serverList", (Throwable)e);
                                }
                            }
                        });
                    }
                }
            };
            if (this.eurekaClient == null) {
                this.eurekaClient = (EurekaClient)this.eurekaClientProvider.get();
            }
            if (this.eurekaClient != null) {
                this.eurekaClient.registerEventListener(this.updateListener);
            }
        } else {
            logger.info("Update listener already registered, no-op");
        }
    }

    public synchronized void stop() {
        if (this.isActive.compareAndSet(true, false)) {
            if (this.eurekaClient != null) {
                this.eurekaClient.unregisterEventListener(this.updateListener);
            }
        } else {
            logger.info("Not currently active, no-op");
        }
    }

    public String getLastUpdate() {
        return new Date(this.lastUpdated.get()).toString();
    }

    public long getDurationSinceLastUpdateMs() {
        return System.currentTimeMillis() - this.lastUpdated.get();
    }

    public int getNumberMissedCycles() {
        return 0;
    }

    public int getCoreThreads() {
        if (this.isActive.get() && this.refreshExecutor != null && this.refreshExecutor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.refreshExecutor).getCorePoolSize();
        }
        return 0;
    }

    private static class LazyHolder {
        private static final ExecutorService DEFAULT_SERVER_LIST_UPDATE_EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("EurekaNotificationServerListUpdater-%d").setDaemon(true).build());
        private static final Thread SHUTDOWN_THREAD = new Thread(new Runnable(){

            @Override
            public void run() {
                logger.info("Shutting down the Executor for EurekaNotificationServerListUpdater");
                try {
                    DEFAULT_SERVER_LIST_UPDATE_EXECUTOR.shutdown();
                    Runtime.getRuntime().removeShutdownHook(SHUTDOWN_THREAD);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });

        private LazyHolder() {
        }

        static {
            Runtime.getRuntime().addShutdownHook(SHUTDOWN_THREAD);
        }
    }
}

