/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.serial;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.metric.sample.HystrixCommandUtilization;
import com.netflix.hystrix.metric.sample.HystrixThreadPoolUtilization;
import com.netflix.hystrix.metric.sample.HystrixUtilization;
import com.netflix.hystrix.serial.SerialHystrixMetric;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialHystrixUtilization
extends SerialHystrixMetric {
    private static final Logger logger = LoggerFactory.getLogger(SerialHystrixUtilization.class);

    public static byte[] toBytes(HystrixUtilization utilization) {
        byte[] retVal = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            CBORGenerator cbor = cborFactory.createGenerator((OutputStream)bos);
            SerialHystrixUtilization.serializeUtilization(utilization, (JsonGenerator)cbor);
            retVal = bos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retVal;
    }

    public static String toJsonString(HystrixUtilization utilization) {
        StringWriter jsonString = new StringWriter();
        try {
            JsonGenerator json = jsonFactory.createGenerator((Writer)jsonString);
            SerialHystrixUtilization.serializeUtilization(utilization, json);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return jsonString.getBuffer().toString();
    }

    private static void serializeUtilization(HystrixUtilization utilization, JsonGenerator json) {
        try {
            json.writeStartObject();
            json.writeStringField("type", "HystrixUtilization");
            json.writeObjectFieldStart("commands");
            for (Map.Entry entry : utilization.getCommandUtilizationMap().entrySet()) {
                HystrixCommandKey key = (HystrixCommandKey)entry.getKey();
                HystrixCommandUtilization commandUtilization = (HystrixCommandUtilization)entry.getValue();
                SerialHystrixUtilization.writeCommandUtilizationJson(json, key, commandUtilization);
            }
            json.writeEndObject();
            json.writeObjectFieldStart("threadpools");
            for (Map.Entry entry : utilization.getThreadPoolUtilizationMap().entrySet()) {
                HystrixThreadPoolKey threadPoolKey = (HystrixThreadPoolKey)entry.getKey();
                HystrixThreadPoolUtilization threadPoolUtilization = (HystrixThreadPoolUtilization)entry.getValue();
                SerialHystrixUtilization.writeThreadPoolUtilizationJson(json, threadPoolKey, threadPoolUtilization);
            }
            json.writeEndObject();
            json.writeEndObject();
            json.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HystrixUtilization fromByteBuffer(ByteBuffer bb) {
        byte[] byteArray = new byte[bb.remaining()];
        bb.get(byteArray);
        HashMap<HystrixCommandKey, HystrixCommandUtilization> commandUtilizationMap = new HashMap<HystrixCommandKey, HystrixCommandUtilization>();
        HashMap<HystrixThreadPoolKey, HystrixThreadPoolUtilization> threadPoolUtilizationMap = new HashMap<HystrixThreadPoolKey, HystrixThreadPoolUtilization>();
        try {
            CBORParser parser = cborFactory.createParser(byteArray);
            JsonNode rootNode = (JsonNode)mapper.readTree((JsonParser)parser);
            Iterator commands = rootNode.path("commands").fields();
            Iterator threadPools = rootNode.path("threadpools").fields();
            while (commands.hasNext()) {
                Map.Entry command = (Map.Entry)commands.next();
                HystrixCommandKey commandKey = HystrixCommandKey.Factory.asKey((String)((String)command.getKey()));
                HystrixCommandUtilization commandUtilization = new HystrixCommandUtilization(((JsonNode)command.getValue()).path("activeCount").asInt());
                commandUtilizationMap.put(commandKey, commandUtilization);
            }
            while (threadPools.hasNext()) {
                Map.Entry threadPool = (Map.Entry)threadPools.next();
                HystrixThreadPoolKey threadPoolKey = HystrixThreadPoolKey.Factory.asKey((String)((String)threadPool.getKey()));
                HystrixThreadPoolUtilization threadPoolUtilization = new HystrixThreadPoolUtilization(((JsonNode)threadPool.getValue()).path("activeCount").asInt(), ((JsonNode)threadPool.getValue()).path("corePoolSize").asInt(), ((JsonNode)threadPool.getValue()).path("poolSize").asInt(), ((JsonNode)threadPool.getValue()).path("queueSize").asInt());
                threadPoolUtilizationMap.put(threadPoolKey, threadPoolUtilization);
            }
        }
        catch (IOException ioe) {
            logger.error("IO Exception during desrialization of HystrixUtilization : " + ioe);
        }
        return new HystrixUtilization(commandUtilizationMap, threadPoolUtilizationMap);
    }

    private static void writeCommandUtilizationJson(JsonGenerator json, HystrixCommandKey key, HystrixCommandUtilization utilization) throws IOException {
        json.writeObjectFieldStart(key.name());
        json.writeNumberField("activeCount", utilization.getConcurrentCommandCount());
        json.writeEndObject();
    }

    private static void writeThreadPoolUtilizationJson(JsonGenerator json, HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolUtilization utilization) throws IOException {
        json.writeObjectFieldStart(threadPoolKey.name());
        json.writeNumberField("activeCount", utilization.getCurrentActiveCount());
        json.writeNumberField("queueSize", utilization.getCurrentQueueSize());
        json.writeNumberField("corePoolSize", utilization.getCurrentCorePoolSize());
        json.writeNumberField("poolSize", utilization.getCurrentPoolSize());
        json.writeEndObject();
    }
}

