/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.serial;

import com.fasterxml.jackson.core.JsonGenerator;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.metric.consumer.HystrixDashboardStream;
import com.netflix.hystrix.serial.SerialHystrixMetric;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Func0;

public class SerialHystrixDashboardData
extends SerialHystrixMetric {
    private static final Logger logger = LoggerFactory.getLogger(SerialHystrixDashboardData.class);

    @Deprecated
    public static byte[] toBytes(HystrixDashboardStream.DashboardData dashboardData) {
        throw new UnsupportedOperationException("Not implemented anymore.  Will be implemented in a new class shortly");
    }

    public static String toJsonString(HystrixDashboardStream.DashboardData dashboardData) {
        StringWriter jsonString = new StringWriter();
        try {
            JsonGenerator json = jsonFactory.createGenerator((Writer)jsonString);
            SerialHystrixDashboardData.writeDashboardData(json, dashboardData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return jsonString.getBuffer().toString();
    }

    public static List<String> toMultipleJsonStrings(HystrixDashboardStream.DashboardData dashboardData) {
        ArrayList<String> jsonStrings = new ArrayList<String>();
        for (HystrixCommandMetrics commandMetrics : dashboardData.getCommandMetrics()) {
            jsonStrings.add(SerialHystrixDashboardData.toJsonString(commandMetrics));
        }
        for (HystrixThreadPoolMetrics threadPoolMetrics : dashboardData.getThreadPoolMetrics()) {
            jsonStrings.add(SerialHystrixDashboardData.toJsonString(threadPoolMetrics));
        }
        for (HystrixCollapserMetrics collapserMetrics : dashboardData.getCollapserMetrics()) {
            jsonStrings.add(SerialHystrixDashboardData.toJsonString(collapserMetrics));
        }
        return jsonStrings;
    }

    private static void writeDashboardData(JsonGenerator json, HystrixDashboardStream.DashboardData dashboardData) {
        try {
            json.writeStartArray();
            for (HystrixCommandMetrics commandMetrics : dashboardData.getCommandMetrics()) {
                SerialHystrixDashboardData.writeCommandMetrics(commandMetrics, json);
            }
            for (HystrixThreadPoolMetrics threadPoolMetrics : dashboardData.getThreadPoolMetrics()) {
                SerialHystrixDashboardData.writeThreadPoolMetrics(threadPoolMetrics, json);
            }
            for (HystrixCollapserMetrics collapserMetrics : dashboardData.getCollapserMetrics()) {
                SerialHystrixDashboardData.writeCollapserMetrics(collapserMetrics, json);
            }
            json.writeEndArray();
            json.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJsonString(HystrixCommandMetrics commandMetrics) {
        StringWriter jsonString = new StringWriter();
        try {
            JsonGenerator json = jsonFactory.createGenerator((Writer)jsonString);
            SerialHystrixDashboardData.writeCommandMetrics(commandMetrics, json);
            json.close();
            return jsonString.getBuffer().toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String toJsonString(HystrixThreadPoolMetrics threadPoolMetrics) {
        StringWriter jsonString = new StringWriter();
        try {
            JsonGenerator json = jsonFactory.createGenerator((Writer)jsonString);
            SerialHystrixDashboardData.writeThreadPoolMetrics(threadPoolMetrics, json);
            json.close();
            return jsonString.getBuffer().toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String toJsonString(HystrixCollapserMetrics collapserMetrics) {
        StringWriter jsonString = new StringWriter();
        try {
            JsonGenerator json = jsonFactory.createGenerator((Writer)jsonString);
            SerialHystrixDashboardData.writeCollapserMetrics(collapserMetrics, json);
            json.close();
            return jsonString.getBuffer().toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void writeCommandMetrics(final HystrixCommandMetrics commandMetrics, JsonGenerator json) throws IOException {
        HystrixCommandKey key = commandMetrics.getCommandKey();
        HystrixCircuitBreaker circuitBreaker = HystrixCircuitBreaker.Factory.getInstance((HystrixCommandKey)key);
        json.writeStartObject();
        json.writeStringField("type", "HystrixCommand");
        json.writeStringField("name", key.name());
        json.writeStringField("group", commandMetrics.getCommandGroup().name());
        json.writeNumberField("currentTime", System.currentTimeMillis());
        if (circuitBreaker == null) {
            json.writeBooleanField("isCircuitBreakerOpen", false);
        } else {
            json.writeBooleanField("isCircuitBreakerOpen", circuitBreaker.isOpen());
        }
        HystrixCommandMetrics.HealthCounts healthCounts = commandMetrics.getHealthCounts();
        json.writeNumberField("errorPercentage", healthCounts.getErrorPercentage());
        json.writeNumberField("errorCount", healthCounts.getErrorCount());
        json.writeNumberField("requestCount", healthCounts.getTotalRequests());
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountBadRequests", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.BAD_REQUEST);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountCollapsedRequests", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.COLLAPSED);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountEmit", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.EMIT);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountExceptionsThrown", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.EXCEPTION_THROWN);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountFailure", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.FAILURE);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountFallbackEmit", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.FALLBACK_EMIT);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountFallbackFailure", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.FALLBACK_FAILURE);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountFallbackMissing", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.FALLBACK_MISSING);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountFallbackRejection", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.FALLBACK_REJECTION);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountFallbackSuccess", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.FALLBACK_SUCCESS);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountResponsesFromCache", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.RESPONSE_FROM_CACHE);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountSemaphoreRejected", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.SEMAPHORE_REJECTED);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountShortCircuited", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.SHORT_CIRCUITED);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountSuccess", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.SUCCESS);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountThreadPoolRejected", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.THREAD_POOL_REJECTED);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountTimeout", new Func0<Long>(){

            public Long call() {
                return commandMetrics.getRollingCount(HystrixEventType.TIMEOUT);
            }
        });
        json.writeNumberField("currentConcurrentExecutionCount", commandMetrics.getCurrentConcurrentExecutionCount());
        json.writeNumberField("rollingMaxConcurrentExecutionCount", commandMetrics.getRollingMaxConcurrentExecutions());
        json.writeNumberField("latencyExecute_mean", commandMetrics.getExecutionTimeMean());
        json.writeObjectFieldStart("latencyExecute");
        json.writeNumberField("0", commandMetrics.getExecutionTimePercentile(0.0));
        json.writeNumberField("25", commandMetrics.getExecutionTimePercentile(25.0));
        json.writeNumberField("50", commandMetrics.getExecutionTimePercentile(50.0));
        json.writeNumberField("75", commandMetrics.getExecutionTimePercentile(75.0));
        json.writeNumberField("90", commandMetrics.getExecutionTimePercentile(90.0));
        json.writeNumberField("95", commandMetrics.getExecutionTimePercentile(95.0));
        json.writeNumberField("99", commandMetrics.getExecutionTimePercentile(99.0));
        json.writeNumberField("99.5", commandMetrics.getExecutionTimePercentile(99.5));
        json.writeNumberField("100", commandMetrics.getExecutionTimePercentile(100.0));
        json.writeEndObject();
        json.writeNumberField("latencyTotal_mean", commandMetrics.getTotalTimeMean());
        json.writeObjectFieldStart("latencyTotal");
        json.writeNumberField("0", commandMetrics.getTotalTimePercentile(0.0));
        json.writeNumberField("25", commandMetrics.getTotalTimePercentile(25.0));
        json.writeNumberField("50", commandMetrics.getTotalTimePercentile(50.0));
        json.writeNumberField("75", commandMetrics.getTotalTimePercentile(75.0));
        json.writeNumberField("90", commandMetrics.getTotalTimePercentile(90.0));
        json.writeNumberField("95", commandMetrics.getTotalTimePercentile(95.0));
        json.writeNumberField("99", commandMetrics.getTotalTimePercentile(99.0));
        json.writeNumberField("99.5", commandMetrics.getTotalTimePercentile(99.5));
        json.writeNumberField("100", commandMetrics.getTotalTimePercentile(100.0));
        json.writeEndObject();
        HystrixCommandProperties commandProperties = commandMetrics.getProperties();
        json.writeNumberField("propertyValue_circuitBreakerRequestVolumeThreshold", ((Integer)commandProperties.circuitBreakerRequestVolumeThreshold().get()).intValue());
        json.writeNumberField("propertyValue_circuitBreakerSleepWindowInMilliseconds", ((Integer)commandProperties.circuitBreakerSleepWindowInMilliseconds().get()).intValue());
        json.writeNumberField("propertyValue_circuitBreakerErrorThresholdPercentage", ((Integer)commandProperties.circuitBreakerErrorThresholdPercentage().get()).intValue());
        json.writeBooleanField("propertyValue_circuitBreakerForceOpen", ((Boolean)commandProperties.circuitBreakerForceOpen().get()).booleanValue());
        json.writeBooleanField("propertyValue_circuitBreakerForceClosed", ((Boolean)commandProperties.circuitBreakerForceClosed().get()).booleanValue());
        json.writeBooleanField("propertyValue_circuitBreakerEnabled", ((Boolean)commandProperties.circuitBreakerEnabled().get()).booleanValue());
        json.writeStringField("propertyValue_executionIsolationStrategy", ((HystrixCommandProperties.ExecutionIsolationStrategy)commandProperties.executionIsolationStrategy().get()).name());
        json.writeNumberField("propertyValue_executionIsolationThreadTimeoutInMilliseconds", ((Integer)commandProperties.executionTimeoutInMilliseconds().get()).intValue());
        json.writeNumberField("propertyValue_executionTimeoutInMilliseconds", ((Integer)commandProperties.executionTimeoutInMilliseconds().get()).intValue());
        json.writeBooleanField("propertyValue_executionIsolationThreadInterruptOnTimeout", ((Boolean)commandProperties.executionIsolationThreadInterruptOnTimeout().get()).booleanValue());
        json.writeStringField("propertyValue_executionIsolationThreadPoolKeyOverride", (String)commandProperties.executionIsolationThreadPoolKeyOverride().get());
        json.writeNumberField("propertyValue_executionIsolationSemaphoreMaxConcurrentRequests", ((Integer)commandProperties.executionIsolationSemaphoreMaxConcurrentRequests().get()).intValue());
        json.writeNumberField("propertyValue_fallbackIsolationSemaphoreMaxConcurrentRequests", ((Integer)commandProperties.fallbackIsolationSemaphoreMaxConcurrentRequests().get()).intValue());
        json.writeNumberField("propertyValue_metricsRollingStatisticalWindowInMilliseconds", ((Integer)commandProperties.metricsRollingStatisticalWindowInMilliseconds().get()).intValue());
        json.writeBooleanField("propertyValue_requestCacheEnabled", ((Boolean)commandProperties.requestCacheEnabled().get()).booleanValue());
        json.writeBooleanField("propertyValue_requestLogEnabled", ((Boolean)commandProperties.requestLogEnabled().get()).booleanValue());
        json.writeNumberField("reportingHosts", 1);
        json.writeStringField("threadPool", commandMetrics.getThreadPoolKey().name());
        json.writeEndObject();
    }

    private static void writeThreadPoolMetrics(final HystrixThreadPoolMetrics threadPoolMetrics, JsonGenerator json) throws IOException {
        HystrixThreadPoolKey key = threadPoolMetrics.getThreadPoolKey();
        json.writeStartObject();
        json.writeStringField("type", "HystrixThreadPool");
        json.writeStringField("name", key.name());
        json.writeNumberField("currentTime", System.currentTimeMillis());
        json.writeNumberField("currentActiveCount", threadPoolMetrics.getCurrentActiveCount().intValue());
        json.writeNumberField("currentCompletedTaskCount", threadPoolMetrics.getCurrentCompletedTaskCount().longValue());
        json.writeNumberField("currentCorePoolSize", threadPoolMetrics.getCurrentCorePoolSize().intValue());
        json.writeNumberField("currentLargestPoolSize", threadPoolMetrics.getCurrentLargestPoolSize().intValue());
        json.writeNumberField("currentMaximumPoolSize", threadPoolMetrics.getCurrentMaximumPoolSize().intValue());
        json.writeNumberField("currentPoolSize", threadPoolMetrics.getCurrentPoolSize().intValue());
        json.writeNumberField("currentQueueSize", threadPoolMetrics.getCurrentQueueSize().intValue());
        json.writeNumberField("currentTaskCount", threadPoolMetrics.getCurrentTaskCount().longValue());
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountThreadsExecuted", new Func0<Long>(){

            public Long call() {
                return threadPoolMetrics.getRollingCount(HystrixEventType.ThreadPool.EXECUTED);
            }
        });
        json.writeNumberField("rollingMaxActiveThreads", threadPoolMetrics.getRollingMaxActiveThreads());
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountCommandRejections", new Func0<Long>(){

            public Long call() {
                return threadPoolMetrics.getRollingCount(HystrixEventType.ThreadPool.REJECTED);
            }
        });
        json.writeNumberField("propertyValue_queueSizeRejectionThreshold", ((Integer)threadPoolMetrics.getProperties().queueSizeRejectionThreshold().get()).intValue());
        json.writeNumberField("propertyValue_metricsRollingStatisticalWindowInMilliseconds", ((Integer)threadPoolMetrics.getProperties().metricsRollingStatisticalWindowInMilliseconds().get()).intValue());
        json.writeNumberField("reportingHosts", 1);
        json.writeEndObject();
    }

    private static void writeCollapserMetrics(final HystrixCollapserMetrics collapserMetrics, JsonGenerator json) throws IOException {
        HystrixCollapserKey key = collapserMetrics.getCollapserKey();
        json.writeStartObject();
        json.writeStringField("type", "HystrixCollapser");
        json.writeStringField("name", key.name());
        json.writeNumberField("currentTime", System.currentTimeMillis());
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountRequestsBatched", new Func0<Long>(){

            public Long call() {
                return collapserMetrics.getRollingCount(HystrixEventType.Collapser.ADDED_TO_BATCH);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountBatches", new Func0<Long>(){

            public Long call() {
                return collapserMetrics.getRollingCount(HystrixEventType.Collapser.BATCH_EXECUTED);
            }
        });
        SerialHystrixDashboardData.safelyWriteNumberField(json, "rollingCountResponsesFromCache", new Func0<Long>(){

            public Long call() {
                return collapserMetrics.getRollingCount(HystrixEventType.Collapser.RESPONSE_FROM_CACHE);
            }
        });
        json.writeNumberField("batchSize_mean", collapserMetrics.getBatchSizeMean());
        json.writeObjectFieldStart("batchSize");
        json.writeNumberField("25", collapserMetrics.getBatchSizePercentile(25.0));
        json.writeNumberField("50", collapserMetrics.getBatchSizePercentile(50.0));
        json.writeNumberField("75", collapserMetrics.getBatchSizePercentile(75.0));
        json.writeNumberField("90", collapserMetrics.getBatchSizePercentile(90.0));
        json.writeNumberField("95", collapserMetrics.getBatchSizePercentile(95.0));
        json.writeNumberField("99", collapserMetrics.getBatchSizePercentile(99.0));
        json.writeNumberField("99.5", collapserMetrics.getBatchSizePercentile(99.5));
        json.writeNumberField("100", collapserMetrics.getBatchSizePercentile(100.0));
        json.writeEndObject();
        json.writeBooleanField("propertyValue_requestCacheEnabled", ((Boolean)collapserMetrics.getProperties().requestCacheEnabled().get()).booleanValue());
        json.writeNumberField("propertyValue_maxRequestsInBatch", ((Integer)collapserMetrics.getProperties().maxRequestsInBatch().get()).intValue());
        json.writeNumberField("propertyValue_timerDelayInMilliseconds", ((Integer)collapserMetrics.getProperties().timerDelayInMilliseconds().get()).intValue());
        json.writeNumberField("reportingHosts", 1);
        json.writeEndObject();
    }

    protected static void safelyWriteNumberField(JsonGenerator json, String name, Func0<Long> metricGenerator) throws IOException {
        try {
            json.writeNumberField(name, ((Long)metricGenerator.call()).longValue());
        }
        catch (NoSuchFieldError error) {
            logger.error("While publishing Hystrix metrics stream, error looking up eventType for : " + name + ".  Please check that all Hystrix versions are the same!");
            json.writeNumberField(name, 0L);
        }
    }
}

