/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.consumer;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.metric.HystrixCollapserEvent;
import com.netflix.hystrix.metric.HystrixCollapserEventStream;
import com.netflix.hystrix.metric.consumer.RollingDistributionStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.HdrHistogram.Histogram;
import rx.functions.Func2;

public class RollingCollapserBatchSizeDistributionStream
extends RollingDistributionStream<HystrixCollapserEvent> {
    private static final ConcurrentMap<String, RollingCollapserBatchSizeDistributionStream> streams = new ConcurrentHashMap<String, RollingCollapserBatchSizeDistributionStream>();
    private static final Func2<Histogram, HystrixCollapserEvent, Histogram> addValuesToBucket = new Func2<Histogram, HystrixCollapserEvent, Histogram>(){

        public Histogram call(Histogram initialDistribution, HystrixCollapserEvent event) {
            switch (event.getEventType()) {
                case ADDED_TO_BATCH: {
                    if (event.getCount() <= -1) break;
                    initialDistribution.recordValue((long)event.getCount());
                    break;
                }
            }
            return initialDistribution;
        }
    };

    public static RollingCollapserBatchSizeDistributionStream getInstance(HystrixCollapserKey collapserKey, HystrixCollapserProperties properties) {
        int percentileMetricWindow = properties.metricsRollingPercentileWindowInMilliseconds().get();
        int numPercentileBuckets = properties.metricsRollingPercentileWindowBuckets().get();
        int percentileBucketSizeInMs = percentileMetricWindow / numPercentileBuckets;
        return RollingCollapserBatchSizeDistributionStream.getInstance(collapserKey, numPercentileBuckets, percentileBucketSizeInMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RollingCollapserBatchSizeDistributionStream getInstance(HystrixCollapserKey collapserKey, int numBuckets, int bucketSizeInMs) {
        RollingCollapserBatchSizeDistributionStream initialStream = (RollingCollapserBatchSizeDistributionStream)streams.get(collapserKey.name());
        if (initialStream != null) {
            return initialStream;
        }
        Class<RollingCollapserBatchSizeDistributionStream> clazz = RollingCollapserBatchSizeDistributionStream.class;
        synchronized (RollingCollapserBatchSizeDistributionStream.class) {
            RollingCollapserBatchSizeDistributionStream existingStream = (RollingCollapserBatchSizeDistributionStream)streams.get(collapserKey.name());
            if (existingStream == null) {
                RollingCollapserBatchSizeDistributionStream newStream = new RollingCollapserBatchSizeDistributionStream(collapserKey, numBuckets, bucketSizeInMs);
                streams.putIfAbsent(collapserKey.name(), newStream);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return newStream;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return existingStream;
        }
    }

    public static void reset() {
        streams.clear();
    }

    private RollingCollapserBatchSizeDistributionStream(HystrixCollapserKey collapserKey, int numPercentileBuckets, int percentileBucketSizeInMs) {
        super(HystrixCollapserEventStream.getInstance(collapserKey), numPercentileBuckets, percentileBucketSizeInMs, addValuesToBucket);
    }
}

