/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.consumer;

import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.metric.HystrixCommandCompletion;
import com.netflix.hystrix.metric.HystrixThreadPoolCompletionStream;
import com.netflix.hystrix.metric.consumer.BucketedRollingCounterStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import rx.functions.Func2;

public class RollingThreadPoolEventCounterStream
extends BucketedRollingCounterStream<HystrixCommandCompletion, long[], long[]> {
    private static final ConcurrentMap<String, RollingThreadPoolEventCounterStream> streams = new ConcurrentHashMap<String, RollingThreadPoolEventCounterStream>();
    private static final int ALL_EVENT_TYPES_SIZE = HystrixEventType.ThreadPool.values().length;

    public static RollingThreadPoolEventCounterStream getInstance(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties properties) {
        int counterMetricWindow = properties.metricsRollingStatisticalWindowInMilliseconds().get();
        int numCounterBuckets = properties.metricsRollingStatisticalWindowBuckets().get();
        int counterBucketSizeInMs = counterMetricWindow / numCounterBuckets;
        return RollingThreadPoolEventCounterStream.getInstance(threadPoolKey, numCounterBuckets, counterBucketSizeInMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RollingThreadPoolEventCounterStream getInstance(HystrixThreadPoolKey threadPoolKey, int numBuckets, int bucketSizeInMs) {
        RollingThreadPoolEventCounterStream initialStream = (RollingThreadPoolEventCounterStream)streams.get(threadPoolKey.name());
        if (initialStream != null) {
            return initialStream;
        }
        Class<RollingThreadPoolEventCounterStream> clazz = RollingThreadPoolEventCounterStream.class;
        synchronized (RollingThreadPoolEventCounterStream.class) {
            RollingThreadPoolEventCounterStream existingStream = (RollingThreadPoolEventCounterStream)streams.get(threadPoolKey.name());
            if (existingStream == null) {
                RollingThreadPoolEventCounterStream newStream = new RollingThreadPoolEventCounterStream(threadPoolKey, numBuckets, bucketSizeInMs, HystrixThreadPoolMetrics.appendEventToBucket, HystrixThreadPoolMetrics.counterAggregator);
                streams.putIfAbsent(threadPoolKey.name(), newStream);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return newStream;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return existingStream;
        }
    }

    public static void reset() {
        streams.clear();
    }

    private RollingThreadPoolEventCounterStream(HystrixThreadPoolKey threadPoolKey, int numCounterBuckets, int counterBucketSizeInMs, Func2<long[], HystrixCommandCompletion, long[]> reduceCommandCompletion, Func2<long[], long[], long[]> reduceBucket) {
        super(HystrixThreadPoolCompletionStream.getInstance(threadPoolKey), numCounterBuckets, counterBucketSizeInMs, reduceCommandCompletion, reduceBucket);
    }

    @Override
    public long[] getEmptyBucketSummary() {
        return new long[ALL_EVENT_TYPES_SIZE];
    }

    @Override
    public long[] getEmptyOutputValue() {
        return new long[ALL_EVENT_TYPES_SIZE];
    }

    public long getLatestCount(HystrixEventType.ThreadPool eventType) {
        return ((long[])this.getLatest())[eventType.ordinal()];
    }
}

