/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.consumer;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.metric.HystrixThreadPoolStartStream;
import com.netflix.hystrix.metric.consumer.RollingConcurrencyStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RollingThreadPoolMaxConcurrencyStream
extends RollingConcurrencyStream {
    private static final ConcurrentMap<String, RollingThreadPoolMaxConcurrencyStream> streams = new ConcurrentHashMap<String, RollingThreadPoolMaxConcurrencyStream>();

    public static RollingThreadPoolMaxConcurrencyStream getInstance(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties properties) {
        int counterMetricWindow = properties.metricsRollingStatisticalWindowInMilliseconds().get();
        int numCounterBuckets = properties.metricsRollingStatisticalWindowBuckets().get();
        int counterBucketSizeInMs = counterMetricWindow / numCounterBuckets;
        return RollingThreadPoolMaxConcurrencyStream.getInstance(threadPoolKey, numCounterBuckets, counterBucketSizeInMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RollingThreadPoolMaxConcurrencyStream getInstance(HystrixThreadPoolKey threadPoolKey, int numBuckets, int bucketSizeInMs) {
        RollingThreadPoolMaxConcurrencyStream initialStream = (RollingThreadPoolMaxConcurrencyStream)streams.get(threadPoolKey.name());
        if (initialStream != null) {
            return initialStream;
        }
        Class<RollingThreadPoolMaxConcurrencyStream> clazz = RollingThreadPoolMaxConcurrencyStream.class;
        synchronized (RollingThreadPoolMaxConcurrencyStream.class) {
            RollingThreadPoolMaxConcurrencyStream existingStream = (RollingThreadPoolMaxConcurrencyStream)streams.get(threadPoolKey.name());
            if (existingStream == null) {
                RollingThreadPoolMaxConcurrencyStream newStream = new RollingThreadPoolMaxConcurrencyStream(threadPoolKey, numBuckets, bucketSizeInMs);
                streams.putIfAbsent(threadPoolKey.name(), newStream);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return newStream;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return existingStream;
        }
    }

    public static void reset() {
        streams.clear();
    }

    public RollingThreadPoolMaxConcurrencyStream(HystrixThreadPoolKey threadPoolKey, int numBuckets, int bucketSizeInMs) {
        super(HystrixThreadPoolStartStream.getInstance(threadPoolKey), numBuckets, bucketSizeInMs);
    }
}

