/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.EurekaAccept;
import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.EurekaServerContextHolder;
import com.netflix.eureka.Version;
import com.netflix.eureka.registry.Key;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.registry.ResponseCache;
import com.netflix.eureka.resources.CurrentRequestVersion;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractVIPResource {
    private static final Logger logger = LoggerFactory.getLogger(AbstractVIPResource.class);
    private final PeerAwareInstanceRegistry registry;
    private final ResponseCache responseCache;

    AbstractVIPResource(EurekaServerContext server) {
        this.registry = server.getRegistry();
        this.responseCache = this.registry.getResponseCache();
    }

    AbstractVIPResource() {
        this(EurekaServerContextHolder.getInstance().getServerContext());
    }

    protected Response getVipResponse(String version, String entityName, String acceptHeader, EurekaAccept eurekaAccept, Key.EntityType entityType) {
        Key cacheKey;
        String payLoad;
        if (!this.registry.shouldAllowAccess(false)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        CurrentRequestVersion.set(Version.toEnum(version));
        Key.KeyType keyType = Key.KeyType.JSON;
        if (acceptHeader == null || !acceptHeader.contains("json")) {
            keyType = Key.KeyType.XML;
        }
        if ((payLoad = this.responseCache.get(cacheKey = new Key(entityType, entityName, keyType, CurrentRequestVersion.get(), eurekaAccept))) != null) {
            logger.debug("Found: {}", (Object)entityName);
            return Response.ok((Object)payLoad).build();
        }
        logger.debug("Not Found: {}", (Object)entityName);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

