/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.EurekaAccept;
import com.netflix.discovery.converters.wrappers.CodecWrapper;
import com.netflix.discovery.converters.wrappers.CodecWrappers;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.registry.Key;
import com.netflix.eureka.resources.ServerCodecs;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultServerCodecs
implements ServerCodecs {
    protected final CodecWrapper fullJsonCodec;
    protected final CodecWrapper compactJsonCodec;
    protected final CodecWrapper fullXmlCodec;
    protected final CodecWrapper compactXmlCodec;

    private static CodecWrapper getFullJson(EurekaServerConfig serverConfig) {
        CodecWrapper codec = CodecWrappers.getCodec((String)serverConfig.getJsonCodecName());
        return codec == null ? CodecWrappers.getCodec(CodecWrappers.LegacyJacksonJson.class) : codec;
    }

    private static CodecWrapper getFullXml(EurekaServerConfig serverConfig) {
        CodecWrapper codec = CodecWrappers.getCodec((String)serverConfig.getXmlCodecName());
        return codec == null ? CodecWrappers.getCodec(CodecWrappers.XStreamXml.class) : codec;
    }

    @Inject
    public DefaultServerCodecs(EurekaServerConfig serverConfig) {
        this(DefaultServerCodecs.getFullJson(serverConfig), CodecWrappers.getCodec(CodecWrappers.JacksonJsonMini.class), DefaultServerCodecs.getFullXml(serverConfig), CodecWrappers.getCodec(CodecWrappers.JacksonXmlMini.class));
    }

    protected DefaultServerCodecs(CodecWrapper fullJsonCodec, CodecWrapper compactJsonCodec, CodecWrapper fullXmlCodec, CodecWrapper compactXmlCodec) {
        this.fullJsonCodec = fullJsonCodec;
        this.compactJsonCodec = compactJsonCodec;
        this.fullXmlCodec = fullXmlCodec;
        this.compactXmlCodec = compactXmlCodec;
    }

    @Override
    public CodecWrapper getFullJsonCodec() {
        return this.fullJsonCodec;
    }

    @Override
    public CodecWrapper getCompactJsonCodec() {
        return this.compactJsonCodec;
    }

    @Override
    public CodecWrapper getFullXmlCodec() {
        return this.fullXmlCodec;
    }

    @Override
    public CodecWrapper getCompactXmlCodecr() {
        return this.compactXmlCodec;
    }

    @Override
    public EncoderWrapper getEncoder(Key.KeyType keyType, boolean compact) {
        switch (keyType) {
            case JSON: {
                return compact ? this.compactJsonCodec : this.fullJsonCodec;
            }
        }
        return compact ? this.compactXmlCodec : this.fullXmlCodec;
    }

    @Override
    public EncoderWrapper getEncoder(Key.KeyType keyType, EurekaAccept eurekaAccept) {
        switch (eurekaAccept) {
            case compact: {
                return this.getEncoder(keyType, true);
            }
        }
        return this.getEncoder(keyType, false);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected CodecWrapper fullJsonCodec;
        protected CodecWrapper compactJsonCodec;
        protected CodecWrapper fullXmlCodec;
        protected CodecWrapper compactXmlCodec;

        protected Builder() {
        }

        public Builder withFullJsonCodec(CodecWrapper fullJsonCodec) {
            this.fullJsonCodec = fullJsonCodec;
            return this;
        }

        public Builder withCompactJsonCodec(CodecWrapper compactJsonCodec) {
            this.compactJsonCodec = compactJsonCodec;
            return this;
        }

        public Builder withFullXmlCodec(CodecWrapper fullXmlCodec) {
            this.fullXmlCodec = fullXmlCodec;
            return this;
        }

        public Builder withCompactXmlCodec(CodecWrapper compactXmlEncoder) {
            this.compactXmlCodec = compactXmlEncoder;
            return this;
        }

        public Builder withEurekaServerConfig(EurekaServerConfig config) {
            this.fullJsonCodec = CodecWrappers.getCodec((String)config.getJsonCodecName());
            this.fullXmlCodec = CodecWrappers.getCodec((String)config.getXmlCodecName());
            return this;
        }

        public ServerCodecs build() {
            if (this.fullJsonCodec == null) {
                this.fullJsonCodec = CodecWrappers.getCodec(CodecWrappers.LegacyJacksonJson.class);
            }
            if (this.compactJsonCodec == null) {
                this.compactJsonCodec = CodecWrappers.getCodec(CodecWrappers.JacksonJsonMini.class);
            }
            if (this.fullXmlCodec == null) {
                this.fullXmlCodec = CodecWrappers.getCodec(CodecWrappers.XStreamXml.class);
            }
            if (this.compactXmlCodec == null) {
                this.compactXmlCodec = CodecWrappers.getCodec(CodecWrappers.JacksonXmlMini.class);
            }
            return new DefaultServerCodecs(this.fullJsonCodec, this.compactJsonCodec, this.fullXmlCodec, this.compactXmlCodec);
        }
    }
}

