/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.registry;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.aws.AwsAsgUtil;
import com.netflix.eureka.cluster.PeerEurekaNodes;
import com.netflix.eureka.lease.Lease;
import com.netflix.eureka.registry.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.resources.ServerCodecs;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AwsInstanceRegistry
extends PeerAwareInstanceRegistryImpl {
    private static final Logger logger = LoggerFactory.getLogger(AwsInstanceRegistry.class);
    private AwsAsgUtil awsAsgUtil;

    @Inject
    public AwsInstanceRegistry(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, EurekaClient eurekaClient) {
        super(serverConfig, clientConfig, serverCodecs, eurekaClient);
    }

    @Override
    public void init(PeerEurekaNodes peerEurekaNodes) throws Exception {
        super.init(peerEurekaNodes);
        this.awsAsgUtil = new AwsAsgUtil(this.serverConfig, this.clientConfig, this);
    }

    public AwsAsgUtil getAwsAsgUtil() {
        return this.awsAsgUtil;
    }

    @Override
    protected InstanceInfo.InstanceStatus getOverriddenInstanceStatus(InstanceInfo r, Lease<InstanceInfo> existingLease, boolean isReplication) {
        if (!InstanceInfo.InstanceStatus.UP.equals((Object)r.getStatus()) && !InstanceInfo.InstanceStatus.OUT_OF_SERVICE.equals((Object)r.getStatus())) {
            logger.debug("Trusting the instance status {} from replica or instance for instance {}", (Object)r.getStatus(), (Object)r.getId());
            return r.getStatus();
        }
        InstanceInfo.InstanceStatus overridden = (InstanceInfo.InstanceStatus)this.overriddenInstanceStatusMap.get(r.getId());
        if (overridden != null) {
            logger.debug("The instance specific override for instance {} and the value is {}", (Object)r.getId(), (Object)overridden.name());
            return overridden;
        }
        boolean isASGDisabled = false;
        if (r.getASGName() != null) {
            isASGDisabled = !this.awsAsgUtil.isASGEnabled(r);
            logger.debug("The ASG name is specified {} and the value is {}", (Object)r.getASGName(), (Object)isASGDisabled);
            if (isASGDisabled) {
                return InstanceInfo.InstanceStatus.OUT_OF_SERVICE;
            }
            return InstanceInfo.InstanceStatus.UP;
        }
        if (!isReplication) {
            InstanceInfo.InstanceStatus existingStatus = null;
            if (existingLease != null) {
                existingStatus = existingLease.getHolder().getStatus();
            }
            if (existingStatus != null && (InstanceInfo.InstanceStatus.OUT_OF_SERVICE.equals((Object)existingStatus) || InstanceInfo.InstanceStatus.UP.equals((Object)existingStatus))) {
                logger.debug("There is already an existing lease with status {}  for instance {}", (Object)existingLease.getHolder().getStatus().name(), (Object)existingLease.getHolder().getId());
                return existingLease.getHolder().getStatus();
            }
        }
        logger.debug("Returning the default instance status {} for instance {}", (Object)r.getStatus(), (Object)r.getId());
        return r.getStatus();
    }
}

