/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.resolver;

import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.ClusterResolverException;
import com.netflix.discovery.shared.resolver.ClusterResolverFactory;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.resolver.ResolverUtils;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Monitors;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadingClusterResolver<T extends EurekaEndpoint>
implements ClusterResolver<T> {
    private static final Logger logger = LoggerFactory.getLogger(ReloadingClusterResolver.class);
    private static final long MAX_RELOAD_INTERVAL_MULTIPLIER = 5L;
    private final ClusterResolverFactory<T> factory;
    private final long reloadIntervalMs;
    private final long maxReloadIntervalMs;
    private final AtomicReference<ClusterResolver<T>> delegateRef;
    private volatile long lastUpdateTime;
    private volatile long currentReloadIntervalMs;
    private volatile long lastReloadTimestamp = -1L;

    public ReloadingClusterResolver(ClusterResolverFactory<T> factory, long reloadIntervalMs) {
        this.factory = factory;
        this.reloadIntervalMs = reloadIntervalMs;
        this.maxReloadIntervalMs = 5L * reloadIntervalMs;
        this.delegateRef = new AtomicReference<ClusterResolver<T>>(factory.createClusterResolver());
        this.lastUpdateTime = System.currentTimeMillis();
        this.currentReloadIntervalMs = reloadIntervalMs;
        List<T> clusterEndpoints = this.delegateRef.get().getClusterEndpoints();
        if (clusterEndpoints.isEmpty()) {
            logger.error("Empty Eureka server endpoint list during initialization process");
            throw new ClusterResolverException("Resolved to an empty endpoint list");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Initiated with delegate resolver of type {}; next reload in {}[sec]. Loaded endpoints={}", new Object[]{this.delegateRef.get().getClass(), this.currentReloadIntervalMs / 1000L, clusterEndpoints});
        }
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register metrics", e);
        }
    }

    @Override
    public String getRegion() {
        ClusterResolver<T> delegate = this.delegateRef.get();
        return delegate == null ? null : delegate.getRegion();
    }

    @Override
    public List<T> getClusterEndpoints() {
        long expiryTime = this.lastUpdateTime + this.currentReloadIntervalMs;
        if (expiryTime <= System.currentTimeMillis()) {
            try {
                ClusterResolver<T> newDelegate = this.reload();
                this.lastUpdateTime = System.currentTimeMillis();
                this.currentReloadIntervalMs = this.reloadIntervalMs;
                if (newDelegate != null) {
                    this.delegateRef.set(newDelegate);
                    this.lastReloadTimestamp = System.currentTimeMillis();
                    if (logger.isInfoEnabled()) {
                        logger.info("Reload endpoints differ from the original list; next reload in {}[sec], Loaded endpoints={}", (Object)(this.currentReloadIntervalMs / 1000L), newDelegate.getClusterEndpoints());
                    }
                }
            }
            catch (Exception e) {
                this.currentReloadIntervalMs = Math.min(this.maxReloadIntervalMs, this.currentReloadIntervalMs * 2L);
                logger.warn("Cluster resolve error; keeping the current Eureka endpoints; next reload in {}[sec]", (Object)(this.currentReloadIntervalMs / 1000L), (Object)e);
            }
        }
        return this.delegateRef.get().getClusterEndpoints();
    }

    private ClusterResolver<T> reload() {
        ClusterResolver<T> newDelegate = this.factory.createClusterResolver();
        List<T> newEndpoints = newDelegate.getClusterEndpoints();
        if (newEndpoints.isEmpty()) {
            logger.info("Tried to reload but empty endpoint list returned; keeping the current endpoints");
            return null;
        }
        if (ResolverUtils.identical(this.delegateRef.get().getClusterEndpoints(), newEndpoints)) {
            logger.debug("Loaded cluster server list identical to the current one; no update required");
            return null;
        }
        return newDelegate;
    }

    @Monitor(name="eurekaClient.resolver.lastReloadTimestamp", description="How much time has passed from last successful cluster configuration resolve", type=DataSourceType.GAUGE)
    public long getLastReloadTimestamp() {
        return this.lastReloadTimestamp < 0L ? 0L : System.currentTimeMillis() - this.lastReloadTimestamp;
    }
}

