/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.InstanceRegionChecker;
import com.netflix.discovery.provider.Serializer;
import com.netflix.discovery.shared.Application;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Serializer(value="com.netflix.discovery.converters.EntityBodyConverter")
@XStreamAlias(value="applications")
@JsonRootName(value="applications")
public class Applications {
    private static final String STATUS_DELIMITER = "_";
    private String appsHashCode;
    private Long versionDelta;
    @XStreamImplicit
    private final AbstractQueue<Application> applications = new ConcurrentLinkedQueue<Application>();
    private final Map<String, Application> appNameApplicationMap = new ConcurrentHashMap<String, Application>();
    private final Map<String, VipIndexSupport> virtualHostNameAppMap = new ConcurrentHashMap<String, VipIndexSupport>();
    private final Map<String, VipIndexSupport> secureVirtualHostNameAppMap = new ConcurrentHashMap<String, VipIndexSupport>();

    public Applications() {
        this(null, -1L, Collections.emptyList());
    }

    @JsonCreator
    public Applications(@JsonProperty(value="appsHashCode") String appsHashCode, @JsonProperty(value="versionDelta") Long versionDelta, @JsonProperty(value="application") List<Application> registeredApplications) {
        this.appsHashCode = appsHashCode;
        this.versionDelta = versionDelta;
        for (Application app : registeredApplications) {
            this.addApplication(app);
        }
    }

    public void addApplication(Application app) {
        this.appNameApplicationMap.put(app.getName().toUpperCase(Locale.ROOT), app);
        this.addInstancesToVIPMaps(app, this.virtualHostNameAppMap, this.secureVirtualHostNameAppMap);
        this.applications.add(app);
    }

    @JsonProperty(value="application")
    public List<Application> getRegisteredApplications() {
        return new ArrayList<Application>(this.applications);
    }

    public Application getRegisteredApplications(String appName) {
        return this.appNameApplicationMap.get(appName.toUpperCase(Locale.ROOT));
    }

    public List<InstanceInfo> getInstancesByVirtualHostName(String virtualHostName) {
        return Optional.ofNullable(this.virtualHostNameAppMap.get(virtualHostName.toUpperCase(Locale.ROOT))).map(VipIndexSupport::getVipList).map(AtomicReference::get).orElseGet(Collections::emptyList);
    }

    public List<InstanceInfo> getInstancesBySecureVirtualHostName(String secureVirtualHostName) {
        return Optional.ofNullable(this.secureVirtualHostNameAppMap.get(secureVirtualHostName.toUpperCase(Locale.ROOT))).map(VipIndexSupport::getVipList).map(AtomicReference::get).orElseGet(Collections::emptyList);
    }

    public int size() {
        return this.applications.stream().mapToInt(Application::size).sum();
    }

    @Deprecated
    public void setVersion(Long version) {
        this.versionDelta = version;
    }

    @Deprecated
    @JsonIgnore
    public Long getVersion() {
        return this.versionDelta;
    }

    public void setAppsHashCode(String hashCode) {
        this.appsHashCode = hashCode;
    }

    @JsonIgnore
    public String getAppsHashCode() {
        return this.appsHashCode;
    }

    @JsonIgnore
    public String getReconcileHashCode() {
        TreeMap<String, AtomicInteger> instanceCountMap = new TreeMap<String, AtomicInteger>();
        this.populateInstanceCountMap(instanceCountMap);
        return Applications.getReconcileHashCode(instanceCountMap);
    }

    public void populateInstanceCountMap(Map<String, AtomicInteger> instanceCountMap) {
        for (Application app : this.getRegisteredApplications()) {
            for (InstanceInfo info : app.getInstancesAsIsFromEureka()) {
                AtomicInteger instanceCount = instanceCountMap.computeIfAbsent(info.getStatus().name(), k -> new AtomicInteger(0));
                instanceCount.incrementAndGet();
            }
        }
    }

    public static String getReconcileHashCode(Map<String, AtomicInteger> instanceCountMap) {
        StringBuilder reconcileHashCode = new StringBuilder(75);
        for (Map.Entry<String, AtomicInteger> mapEntry : instanceCountMap.entrySet()) {
            reconcileHashCode.append(mapEntry.getKey()).append(STATUS_DELIMITER).append(mapEntry.getValue().get()).append(STATUS_DELIMITER);
        }
        return reconcileHashCode.toString();
    }

    public void shuffleInstances(boolean filterUpInstances) {
        this.shuffleInstances(filterUpInstances, false, null, null, null);
    }

    public void shuffleAndIndexInstances(Map<String, Applications> remoteRegionsRegistry, EurekaClientConfig clientConfig, InstanceRegionChecker instanceRegionChecker) {
        this.shuffleInstances(clientConfig.shouldFilterOnlyUpInstances(), true, remoteRegionsRegistry, clientConfig, instanceRegionChecker);
    }

    private void shuffleInstances(boolean filterUpInstances, boolean indexByRemoteRegions, @Nullable Map<String, Applications> remoteRegionsRegistry, @Nullable EurekaClientConfig clientConfig, @Nullable InstanceRegionChecker instanceRegionChecker) {
        HashMap<String, VipIndexSupport> secureVirtualHostNameAppMap = new HashMap<String, VipIndexSupport>();
        HashMap<String, VipIndexSupport> virtualHostNameAppMap = new HashMap<String, VipIndexSupport>();
        for (Application application : this.appNameApplicationMap.values()) {
            if (indexByRemoteRegions) {
                application.shuffleAndStoreInstances(remoteRegionsRegistry, clientConfig, instanceRegionChecker);
            } else {
                application.shuffleAndStoreInstances(filterUpInstances);
            }
            this.addInstancesToVIPMaps(application, virtualHostNameAppMap, secureVirtualHostNameAppMap);
        }
        this.shuffleAndFilterInstances(virtualHostNameAppMap, filterUpInstances);
        this.shuffleAndFilterInstances(secureVirtualHostNameAppMap, filterUpInstances);
        this.virtualHostNameAppMap.putAll(virtualHostNameAppMap);
        this.virtualHostNameAppMap.keySet().retainAll(virtualHostNameAppMap.keySet());
        this.secureVirtualHostNameAppMap.putAll(secureVirtualHostNameAppMap);
        this.secureVirtualHostNameAppMap.keySet().retainAll(secureVirtualHostNameAppMap.keySet());
    }

    public AtomicLong getNextIndex(String virtualHostname, boolean secure) {
        Map<String, VipIndexSupport> index = secure ? this.secureVirtualHostNameAppMap : this.virtualHostNameAppMap;
        return Optional.ofNullable(index.get(virtualHostname.toUpperCase(Locale.ROOT))).map(VipIndexSupport::getRoundRobinIndex).orElse(null);
    }

    private void shuffleAndFilterInstances(Map<String, VipIndexSupport> srcMap, boolean filterUpInstances) {
        Random shuffleRandom = new Random();
        for (Map.Entry<String, VipIndexSupport> entries : srcMap.entrySet()) {
            VipIndexSupport vipIndexSupport = entries.getValue();
            AbstractQueue<InstanceInfo> vipInstances = vipIndexSupport.instances;
            List<InstanceInfo> filteredInstances = filterUpInstances ? (List)vipInstances.stream().filter(ii -> ii.getStatus() == InstanceInfo.InstanceStatus.UP).collect(Collectors.toCollection(() -> new ArrayList(vipInstances.size()))) : new ArrayList<InstanceInfo>(vipInstances);
            Collections.shuffle(filteredInstances, shuffleRandom);
            vipIndexSupport.vipList.set(filteredInstances);
            vipIndexSupport.roundRobinIndex.set(0L);
        }
    }

    private void addInstanceToMap(InstanceInfo info, String vipAddresses, Map<String, VipIndexSupport> vipMap) {
        if (vipAddresses != null) {
            String[] vipAddressArray;
            for (String vipAddress : vipAddressArray = vipAddresses.toUpperCase(Locale.ROOT).split(",")) {
                VipIndexSupport vis = vipMap.computeIfAbsent(vipAddress, k -> new VipIndexSupport());
                vis.instances.add(info);
            }
        }
    }

    private void addInstancesToVIPMaps(Application app, Map<String, VipIndexSupport> virtualHostNameAppMap, Map<String, VipIndexSupport> secureVirtualHostNameAppMap) {
        for (InstanceInfo info : app.getInstances()) {
            String secureVipAddresses;
            String vipAddresses = info.getVIPAddress();
            if (vipAddresses != null) {
                this.addInstanceToMap(info, vipAddresses, virtualHostNameAppMap);
            }
            if ((secureVipAddresses = info.getSecureVipAddress()) == null) continue;
            this.addInstanceToMap(info, secureVipAddresses, secureVirtualHostNameAppMap);
        }
    }

    private static class VipIndexSupport {
        final AbstractQueue<InstanceInfo> instances = new ConcurrentLinkedQueue<InstanceInfo>();
        final AtomicLong roundRobinIndex = new AtomicLong(0L);
        final AtomicReference<List<InstanceInfo>> vipList = new AtomicReference(Collections.emptyList());

        private VipIndexSupport() {
        }

        public AtomicLong getRoundRobinIndex() {
            return this.roundRobinIndex;
        }

        public AtomicReference<List<InstanceInfo>> getVipList() {
            return this.vipList;
        }
    }
}

