/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.netflix.discovery.util.ServoUtil;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import java.util.concurrent.ConcurrentHashMap;

public class ExceptionsMetric {
    private final String name;
    private final ConcurrentHashMap<String, Counter> exceptionCounters = new ConcurrentHashMap();

    public ExceptionsMetric(String name) {
        this.name = name;
    }

    public void count(Throwable ex) {
        this.getOrCreateCounter(ExceptionsMetric.extractName(ex)).increment();
    }

    public void shutdown() {
        ServoUtil.unregister(this.exceptionCounters.values());
    }

    private Counter getOrCreateCounter(String exceptionName) {
        Counter counter = this.exceptionCounters.get(exceptionName);
        if (counter == null) {
            counter = new BasicCounter(MonitorConfig.builder((String)this.name).withTag("id", exceptionName).build());
            if (this.exceptionCounters.putIfAbsent(exceptionName, counter) == null) {
                DefaultMonitorRegistry.getInstance().register((Monitor)counter);
            } else {
                counter = this.exceptionCounters.get(exceptionName);
            }
        }
        return counter;
    }

    private static String extractName(Throwable ex) {
        Throwable cause = ex;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause.getClass().getSimpleName();
    }
}

