/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.utils;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.utils.ZKPaths;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public class EnsurePath {
    private final String path;
    private final AtomicReference<Helper> helper = new AtomicReference();
    private static final Helper doNothingHelper = new Helper(){

        @Override
        public void ensure(CuratorZookeeperClient curatorZookeeperClient, String string) throws Exception {
        }
    };

    public EnsurePath(String string) {
        this.path = string;
        this.helper.set(new InitialHelper());
    }

    public void ensure(CuratorZookeeperClient curatorZookeeperClient) throws Exception {
        Helper helper = this.helper.get();
        helper.ensure(curatorZookeeperClient, this.path);
    }

    private class InitialHelper
    implements Helper {
        private boolean isSet = false;

        private InitialHelper() {
        }

        @Override
        public synchronized void ensure(final CuratorZookeeperClient curatorZookeeperClient, final String string) throws Exception {
            if (!this.isSet) {
                RetryLoop.callWithRetry(curatorZookeeperClient, new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ZKPaths.mkdirs(curatorZookeeperClient.getZooKeeper(), string, true);
                        EnsurePath.this.helper.set(doNothingHelper);
                        InitialHelper.this.isSet = true;
                        return null;
                    }
                });
            }
        }
    }

    private static interface Helper {
        public void ensure(CuratorZookeeperClient var1, String var2) throws Exception;
    }
}

