/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.retry;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.curator.retry.SleepingRetry;
import java.util.Random;

public class ExponentialBackoffRetry
extends SleepingRetry {
    private final Random random = new Random();
    private final int baseSleepTimeMs;

    public ExponentialBackoffRetry(int n, int n2) {
        super(n2);
        this.baseSleepTimeMs = n;
    }

    @VisibleForTesting
    public int getBaseSleepTimeMs() {
        return this.baseSleepTimeMs;
    }

    @Override
    protected int getSleepTimeMs(int n, long l) {
        return this.baseSleepTimeMs * Math.max(1, this.random.nextInt(1 << n + 1));
    }
}

