/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.ensemble.exhibitor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class Exhibitors {
    private final Collection<String> hostnames;
    private final int restPort;
    private final BackupConnectionStringProvider backupConnectionStringProvider;

    public Exhibitors(Collection<String> collection, int n, BackupConnectionStringProvider backupConnectionStringProvider) {
        this.backupConnectionStringProvider = (BackupConnectionStringProvider)Preconditions.checkNotNull((Object)backupConnectionStringProvider, (Object)"backupConnectionStringProvider cannot be null");
        this.hostnames = ImmutableList.copyOf(collection);
        this.restPort = n;
    }

    public Collection<String> getHostnames() {
        return this.hostnames;
    }

    public int getRestPort() {
        return this.restPort;
    }

    public String getBackupConnectionString() throws Exception {
        return this.backupConnectionStringProvider.getBackupConnectionString();
    }

    public static interface BackupConnectionStringProvider {
        public String getBackupConnectionString() throws Exception;
    }
}

