/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.ensemble.exhibitor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.RetryPolicy;
import com.netflix.curator.ensemble.EnsembleProvider;
import com.netflix.curator.ensemble.exhibitor.ExhibitorRestClient;
import com.netflix.curator.ensemble.exhibitor.Exhibitors;
import com.netflix.curator.utils.ThreadUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExhibitorEnsembleProvider
implements EnsembleProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<Exhibitors> exhibitors = new AtomicReference();
    private final AtomicReference<Exhibitors> masterExhibitors = new AtomicReference();
    private final ExhibitorRestClient restClient;
    private final String restUriPath;
    private final int pollingMs;
    private final RetryPolicy retryPolicy;
    private final ScheduledExecutorService service = ThreadUtils.newSingleThreadScheduledExecutor("ExhibitorEnsembleProvider");
    private final Random random = new Random();
    private final AtomicReference<String> connectionString = new AtomicReference<String>("");
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private static final String MIME_TYPE = "application/x-www-form-urlencoded";
    private static final String VALUE_PORT = "port";
    private static final String VALUE_COUNT = "count";
    private static final String VALUE_SERVER_PREFIX = "server";

    public ExhibitorEnsembleProvider(Exhibitors exhibitors, ExhibitorRestClient exhibitorRestClient, String string, int n, RetryPolicy retryPolicy) {
        this.exhibitors.set(exhibitors);
        this.masterExhibitors.set(exhibitors);
        this.restClient = exhibitorRestClient;
        this.restUriPath = string;
        this.pollingMs = n;
        this.retryPolicy = retryPolicy;
    }

    public void setExhibitors(Exhibitors exhibitors) {
        this.exhibitors.set(exhibitors);
        this.masterExhibitors.set(exhibitors);
    }

    public void pollForInitialEnsemble() throws Exception {
        Preconditions.checkState((this.state.get() == State.LATENT ? 1 : 0) != 0, (Object)"Cannot be called after start()");
        this.poll();
    }

    @Override
    public void start() throws Exception {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.LATENT, State.STARTED), (Object)"Already started");
        this.service.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ExhibitorEnsembleProvider.this.poll();
            }
        }, this.pollingMs, this.pollingMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.STARTED, State.CLOSED), (Object)"Already closed");
        this.service.shutdownNow();
    }

    @Override
    public String getConnectionString() {
        return this.connectionString.get();
    }

    @VisibleForTesting
    protected void poll() {
        Exhibitors exhibitors = this.exhibitors.get();
        Map<String, String> map = this.queryExhibitors(exhibitors);
        int n = this.getCountFromValues(map);
        if (n == 0) {
            this.log.warn("0 count returned from Exhibitors. Using backup connection values.");
            map = this.useBackup(exhibitors);
            n = this.getCountFromValues(map);
        }
        if (n > 0) {
            Object object;
            int n2 = Integer.parseInt(map.get(VALUE_PORT));
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList arrayList = Lists.newArrayList();
            for (int i = 0; i < n; ++i) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                object = map.get(VALUE_SERVER_PREFIX + i);
                stringBuilder.append((String)object).append(":").append(n2);
                arrayList.add(object);
            }
            String string = stringBuilder.toString();
            if (!string.equals(this.connectionString.get())) {
                this.log.info("Connection string has changed. Old value (%s), new value (%s)", (Object)this.connectionString.get(), (Object)string);
            }
            object = new Exhibitors(arrayList, exhibitors.getRestPort(), new Exhibitors.BackupConnectionStringProvider(){

                @Override
                public String getBackupConnectionString() throws Exception {
                    return ((Exhibitors)ExhibitorEnsembleProvider.this.masterExhibitors.get()).getBackupConnectionString();
                }
            });
            this.connectionString.set(string);
            this.exhibitors.set((Exhibitors)object);
        }
    }

    private int getCountFromValues(Map<String, String> map) {
        try {
            return Integer.parseInt(map.get(VALUE_COUNT));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private Map<String, String> useBackup(Exhibitors exhibitors) {
        Map<String, String> map = this.newValues();
        try {
            String string = exhibitors.getBackupConnectionString();
            int n = -1;
            int n2 = 0;
            for (String string2 : string.split(",")) {
                String[] stringArray = (string2 = string2.trim()).split(":");
                if (stringArray.length == 2) {
                    String string3 = stringArray[0];
                    int n3 = Integer.parseInt(stringArray[1]);
                    if (n < 0) {
                        n = n3;
                    } else if (n3 != n) {
                        this.log.warn("Inconsistent port in connection component: " + string2);
                    }
                    map.put(VALUE_SERVER_PREFIX + n2, string3);
                    ++n2;
                    continue;
                }
                this.log.warn("Bad backup connection component: " + string2);
            }
            map.put(VALUE_COUNT, Integer.toString(n2));
            map.put(VALUE_PORT, Integer.toString(n));
        }
        catch (Exception exception) {
            this.log.error("Couldn't get backup connection string", (Throwable)exception);
        }
        return map;
    }

    private Map<String, String> newValues() {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(VALUE_COUNT, "0");
        return hashMap;
    }

    private static Map<String, String> decodeExhibitorList(String string) throws UnsupportedEncodingException {
        HashMap hashMap = Maps.newHashMap();
        for (String string2 : string.split("&")) {
            String[] stringArray = string2.split("=");
            if (stringArray.length != 2) continue;
            hashMap.put(stringArray[0], URLDecoder.decode(stringArray[1], "UTF-8"));
        }
        return hashMap;
    }

    private Map<String, String> queryExhibitors(Exhibitors exhibitors) {
        Map<String, String> map = this.newValues();
        long l = System.currentTimeMillis();
        int n = 0;
        boolean bl = false;
        while (!bl) {
            ArrayList arrayList = Lists.newArrayList(exhibitors.getHostnames());
            if (arrayList.size() == 0) {
                bl = true;
                continue;
            }
            String string = (String)arrayList.get(this.random.nextInt(arrayList.size()));
            try {
                String string2 = this.restClient.getRaw(string, exhibitors.getRestPort(), this.restUriPath, MIME_TYPE);
                map.putAll(ExhibitorEnsembleProvider.decodeExhibitorList(string2));
                bl = true;
            }
            catch (Throwable throwable) {
                if (this.retryPolicy.allowRetry(n++, System.currentTimeMillis() - l, RetryLoop.getDefaultRetrySleeper())) {
                    this.log.warn("Couldn't get servers from Exhibitor. Retrying.", throwable);
                    continue;
                }
                this.log.error("Couldn't get servers from Exhibitor. Giving up.", throwable);
                bl = true;
            }
        }
        return map;
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

