/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.retry;

import com.netflix.curator.retry.SleepingRetry;

public class RetryUntilElapsed
extends SleepingRetry {
    private final int maxElapsedTimeMs;
    private final int sleepMsBetweenRetries;

    public RetryUntilElapsed(int maxElapsedTimeMs, int sleepMsBetweenRetries) {
        super(Integer.MAX_VALUE);
        this.maxElapsedTimeMs = maxElapsedTimeMs;
        this.sleepMsBetweenRetries = sleepMsBetweenRetries;
    }

    @Override
    public boolean allowRetry(int retryCount, long elapsedTimeMs) {
        return elapsedTimeMs < (long)this.maxElapsedTimeMs;
    }

    @Override
    protected int getSleepTimeMs(int retryCount, long elapsedTimeMs) {
        return this.sleepMsBetweenRetries;
    }
}

