/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.ConcurrentMapConfiguration;
import com.netflix.config.ConfigurationManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathPropertiesConfiguration
extends ConcurrentMapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ClasspathPropertiesConfiguration.class);
    static String configNameProperty = "config.configName";
    static String propertiesResourceRelativePath = "META-INF/conf/config.properties";
    static ClasspathPropertiesConfiguration instance = null;

    private ClasspathPropertiesConfiguration() {
    }

    public String getConfigNameProperty() {
        return configNameProperty;
    }

    public static void setConfigNameProperty(String configNameProperty) {
        ClasspathPropertiesConfiguration.configNameProperty = configNameProperty;
    }

    public String getPropertiesResourceRelativePath() {
        return propertiesResourceRelativePath;
    }

    public static void setPropertiesResourceRelativePath(String propertiesResourceRelativePath) {
        ClasspathPropertiesConfiguration.propertiesResourceRelativePath = propertiesResourceRelativePath;
    }

    @Override
    public Properties getProperties() {
        return instance != null ? instance.getProperties() : new Properties();
    }

    public static void initialize() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            instance = new ClasspathPropertiesConfiguration();
            ClasspathPropertiesConfiguration.loadResources(loader, propertiesResourceRelativePath);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to read configuration properties from classpath", e);
        }
    }

    private static void loadResources(ClassLoader loader, String resourceName) throws Exception {
        Enumeration<URL> resources = loader.getResources(resourceName);
        boolean loadedResources = false;
        while (resources.hasMoreElements()) {
            URL from = resources.nextElement();
            ConfigurationManager.loadPropertiesFromResources(from.getPath());
            log.debug("Added properties from:" + from + from.getPath());
            loadedResources = true;
        }
        if (!loadedResources) {
            log.debug("Did not find any properties resource in the classpath with name:" + propertiesResourceRelativePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(URL from) throws IOException {
        Properties into = new Properties();
        InputStream in = from.openStream();
        try {
            into.load(in);
        }
        catch (Exception e) {
            log.error("Exception while loading properties from URL:" + from);
        }
        finally {
            in.close();
        }
        return into;
    }

    private static String getConfigName(Properties props, URL propertyFile) {
        String name = props.getProperty(configNameProperty);
        if (name == null) {
            name = propertyFile.toExternalForm();
            name = name.replace('\\', '/');
            String scheme = propertyFile.getProtocol().toLowerCase();
            if ("jar".equals(scheme) || "zip".equals(scheme)) {
                int slash;
                int bang = name.lastIndexOf("!");
                if (bang >= 0) {
                    name = name.substring(0, bang);
                }
                if ((slash = name.lastIndexOf("/")) >= 0) {
                    name = name.substring(slash + 1);
                }
            } else {
                int slash = name.lastIndexOf("/");
                if (slash >= 0) {
                    name = name.substring(0, slash);
                }
            }
        }
        return name;
    }
}

