/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.DynamicStringListProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicMapProperty<TKEY, TVAL>
extends DynamicStringListProperty {
    private static final Logger logger = LoggerFactory.getLogger(DynamicMapProperty.class);
    private volatile Map<TKEY, TVAL> values;

    public DynamicMapProperty(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public DynamicMapProperty(String string, Map<TKEY, TVAL> map, String string2) {
        this(string, (String)null, string2);
        if (this.values == null && map != null) {
            this.values = Collections.unmodifiableMap(map);
        }
    }

    public DynamicMapProperty(String string, String string2) {
        super(string, string2);
    }

    public DynamicMapProperty(String string, Map<TKEY, TVAL> map) {
        this(string, map, ",");
    }

    public Map<TKEY, TVAL> getMap() {
        return this.values;
    }

    @Override
    protected void load() {
        super.load();
        List list = super.get();
        if (list == null) {
            return;
        }
        HashMap<TKEY, TVAL> hashMap = new HashMap<TKEY, TVAL>(list.size());
        for (String string : list) {
            String[] stringArray = this.getKeyValue(string);
            if (stringArray.length == 2) {
                hashMap.put(this.getKey(stringArray[0]), this.getValue(stringArray[1]));
                continue;
            }
            logger.warn("Ignoring illegal key value pair: " + string);
        }
        this.values = Collections.unmodifiableMap(hashMap);
    }

    protected String[] getKeyValue(String string) {
        return string.split("=");
    }

    protected abstract TKEY getKey(String var1);

    protected abstract TVAL getValue(String var1);
}

