/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.Messages;
import com.mysql.cj.MysqlType;
import com.mysql.cj.ServerVersion;
import com.mysql.cj.conf.PropertyDefinitions;
import com.mysql.cj.conf.PropertyKey;
import com.mysql.cj.exceptions.CJException;
import com.mysql.cj.jdbc.DatabaseMetaData;
import com.mysql.cj.jdbc.JdbcConnection;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.jdbc.result.ResultSetFactory;
import com.mysql.cj.jdbc.result.ResultSetInternalMethods;
import com.mysql.cj.util.LRUCache;
import com.mysql.cj.util.StringUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DatabaseMetaDataUsingInfoSchema
extends DatabaseMetaData {
    private static Map<ServerVersion, String> keywordsCache = Collections.synchronizedMap(new LRUCache(10));
    private static final Lock KEYWORDS_CACHE_LOCK = new ReentrantLock();

    protected DatabaseMetaDataUsingInfoSchema(JdbcConnection connToSet, String databaseToSet, ResultSetFactory resultSetFactory) throws SQLException {
        super(connToSet, databaseToSet, resultSetFactory);
    }

    protected ResultSet executeMetadataQuery(PreparedStatement pStmt) throws SQLException {
        ResultSet rs = pStmt.executeQuery();
        ((ResultSetInternalMethods)rs).setOwningStatement(null);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbPattern = this.getDatabase(catalog, schema);
            String dbFilter = this.pedantic ? dbPattern : StringUtils.unQuoteIdentifier(dbPattern, this.quotedId);
            String tableFilter = this.pedantic ? table : StringUtils.unQuoteIdentifier(table, this.quotedId);
            String columnNameFilter = this.pedantic ? columnNamePattern : StringUtils.unQuoteIdentifier(columnNamePattern, this.quotedId);
            StringBuilder query = new StringBuilder(dbMapsToSchema ? "SELECT TABLE_CATALOG, TABLE_SCHEMA," : "SELECT TABLE_SCHEMA, NULL,");
            query.append(" TABLE_NAME, COLUMN_NAME, NULL AS GRANTOR, GRANTEE, PRIVILEGE_TYPE AS PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.COLUMN_PRIVILEGES WHERE");
            if (dbFilter != null) {
                query.append(" TABLE_SCHEMA=? AND");
            }
            query.append(" TABLE_NAME = ?");
            if (columnNamePattern != null) {
                query.append(" AND COLUMN_NAME LIKE ?");
            }
            query.append(" ORDER BY COLUMN_NAME, PRIVILEGE_TYPE");
            try (PreparedStatement pStmt = null;){
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                pStmt.setString(nextId++, dbFilter);
                pStmt.setString(nextId++, tableFilter);
                if (columnNameFilter != null) {
                    pStmt.setString(nextId, columnNameFilter);
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.getColumnPrivilegesFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFilter = this.getDatabase(catalog, schemaPattern);
            dbFilter = this.pedantic ? dbFilter : StringUtils.unQuoteIdentifier(dbFilter, this.quotedId);
            String tableNameFilter = this.pedantic ? tableNamePattern : StringUtils.unQuoteIdentifier(tableNamePattern, this.quotedId);
            String columnNameFilter = this.pedantic ? columnNamePattern : StringUtils.unQuoteIdentifier(columnNamePattern, this.quotedId);
            StringBuilder query = new StringBuilder(dbMapsToSchema ? "SELECT TABLE_CATALOG, TABLE_SCHEMA," : "SELECT TABLE_SCHEMA, NULL,");
            query.append(" TABLE_NAME, COLUMN_NAME,");
            this.appendJdbcTypeMappingQuery(query, "DATA_TYPE", "COLUMN_TYPE");
            query.append(" AS DATA_TYPE, ");
            query.append("UPPER(CASE");
            if (this.tinyInt1isBit) {
                query.append(" WHEN UPPER(DATA_TYPE)='TINYINT' THEN CASE");
                query.append(" WHEN LOCATE('ZEROFILL', UPPER(COLUMN_TYPE)) = 0 AND LOCATE('UNSIGNED', UPPER(COLUMN_TYPE)) = 0 AND LOCATE('(1)', COLUMN_TYPE) != 0 THEN ");
                query.append(this.transformedBitIsBoolean ? "'BOOLEAN'" : "'BIT'");
                query.append(" WHEN LOCATE('UNSIGNED', UPPER(COLUMN_TYPE)) != 0 AND LOCATE('UNSIGNED', UPPER(DATA_TYPE)) = 0 THEN 'TINYINT UNSIGNED'");
                query.append(" ELSE DATA_TYPE END ");
            }
            query.append(" WHEN LOCATE('UNSIGNED', UPPER(COLUMN_TYPE)) != 0 AND LOCATE('UNSIGNED', UPPER(DATA_TYPE)) = 0 AND LOCATE('SET', UPPER(DATA_TYPE)) <> 1 AND LOCATE('ENUM', UPPER(DATA_TYPE)) <> 1 THEN CONCAT(DATA_TYPE, ' UNSIGNED')");
            query.append(" WHEN UPPER(DATA_TYPE)='POINT' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='LINESTRING' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='POLYGON' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='MULTIPOINT' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='MULTILINESTRING' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='MULTIPOLYGON' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='GEOMETRYCOLLECTION' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='GEOMCOLLECTION' THEN 'GEOMETRY'");
            query.append(" ELSE UPPER(DATA_TYPE) END) AS TYPE_NAME,");
            query.append("UPPER(CASE");
            query.append(" WHEN UPPER(DATA_TYPE)='DATE' THEN 10");
            if (this.conn.getServerVersion().meetsMinimum(ServerVersion.parseVersion("5.6.4"))) {
                query.append(" WHEN UPPER(DATA_TYPE)='TIME'");
                query.append("  THEN 8+(CASE WHEN DATETIME_PRECISION>0 THEN DATETIME_PRECISION+1 ELSE DATETIME_PRECISION END)");
                query.append(" WHEN UPPER(DATA_TYPE)='DATETIME' OR");
                query.append("  UPPER(DATA_TYPE)='TIMESTAMP'");
                query.append("  THEN 19+(CASE WHEN DATETIME_PRECISION>0 THEN DATETIME_PRECISION+1 ELSE DATETIME_PRECISION END)");
            } else {
                query.append(" WHEN UPPER(DATA_TYPE)='TIME' THEN 8");
                query.append(" WHEN UPPER(DATA_TYPE)='DATETIME' OR");
                query.append("  UPPER(DATA_TYPE)='TIMESTAMP'");
                query.append("  THEN 19");
            }
            query.append(" WHEN UPPER(DATA_TYPE)='YEAR' THEN 4");
            if (this.tinyInt1isBit && !this.transformedBitIsBoolean) {
                query.append(" WHEN UPPER(DATA_TYPE)='TINYINT' AND LOCATE('ZEROFILL', UPPER(COLUMN_TYPE)) = 0 AND LOCATE('UNSIGNED', UPPER(COLUMN_TYPE)) = 0 AND LOCATE('(1)', COLUMN_TYPE) != 0 THEN 1");
            }
            query.append(" WHEN UPPER(DATA_TYPE)='MEDIUMINT' AND LOCATE('UNSIGNED', UPPER(COLUMN_TYPE)) != 0 THEN 8");
            query.append(" WHEN UPPER(DATA_TYPE)='JSON' THEN 1073741824");
            query.append(" WHEN UPPER(DATA_TYPE)='GEOMETRY' THEN 65535");
            query.append(" WHEN UPPER(DATA_TYPE)='POINT' THEN 65535");
            query.append(" WHEN UPPER(DATA_TYPE)='LINESTRING' THEN 65535");
            query.append(" WHEN UPPER(DATA_TYPE)='POLYGON' THEN 65535");
            query.append(" WHEN UPPER(DATA_TYPE)='MULTIPOINT' THEN 65535");
            query.append(" WHEN UPPER(DATA_TYPE)='MULTILINESTRING' THEN 65535");
            query.append(" WHEN UPPER(DATA_TYPE)='MULTIPOLYGON' THEN 65535");
            query.append(" WHEN UPPER(DATA_TYPE)='GEOMETRYCOLLECTION' THEN 65535");
            query.append(" WHEN UPPER(DATA_TYPE)='GEOMCOLLECTION' THEN 65535");
            query.append(" WHEN CHARACTER_MAXIMUM_LENGTH IS NULL THEN NUMERIC_PRECISION");
            query.append(" WHEN CHARACTER_MAXIMUM_LENGTH > ");
            query.append(Integer.MAX_VALUE);
            query.append(" THEN ");
            query.append(Integer.MAX_VALUE);
            query.append(" ELSE CHARACTER_MAXIMUM_LENGTH");
            query.append(" END) AS COLUMN_SIZE,");
            query.append(maxBufferSize);
            query.append(" AS BUFFER_LENGTH,");
            query.append("UPPER(CASE");
            query.append(" WHEN UPPER(DATA_TYPE)='DECIMAL' THEN NUMERIC_SCALE");
            query.append(" WHEN UPPER(DATA_TYPE)='FLOAT' OR UPPER(DATA_TYPE)='DOUBLE' THEN");
            query.append(" CASE WHEN NUMERIC_SCALE IS NULL THEN 0");
            query.append(" ELSE NUMERIC_SCALE END");
            query.append(" ELSE NULL END) AS DECIMAL_DIGITS,");
            query.append("10 AS NUM_PREC_RADIX,");
            query.append("CASE");
            query.append(" WHEN IS_NULLABLE='NO' THEN ");
            query.append(0);
            query.append(" ELSE CASE WHEN IS_NULLABLE='YES' THEN ");
            query.append(1);
            query.append(" ELSE ");
            query.append(2);
            query.append(" END END AS NULLABLE,");
            query.append("COLUMN_COMMENT AS REMARKS,");
            query.append("COLUMN_DEFAULT AS COLUMN_DEF,");
            query.append("0 AS SQL_DATA_TYPE,");
            query.append("0 AS SQL_DATETIME_SUB,");
            query.append("CASE WHEN CHARACTER_OCTET_LENGTH > ");
            query.append(Integer.MAX_VALUE);
            query.append(" THEN ");
            query.append(Integer.MAX_VALUE);
            query.append(" ELSE CHARACTER_OCTET_LENGTH END AS CHAR_OCTET_LENGTH,");
            query.append("ORDINAL_POSITION, IS_NULLABLE, NULL AS SCOPE_CATALOG, NULL AS SCOPE_SCHEMA, NULL AS SCOPE_TABLE, NULL AS SOURCE_DATA_TYPE,");
            query.append("IF (EXTRA LIKE '%auto_increment%','YES','NO') AS IS_AUTOINCREMENT, ");
            query.append("IF (EXTRA LIKE '%GENERATED%','YES','NO') AS IS_GENERATEDCOLUMN ");
            query.append("FROM INFORMATION_SCHEMA.COLUMNS");
            StringBuilder condition = new StringBuilder();
            if (dbFilter != null) {
                condition.append(dbMapsToSchema && StringUtils.hasWildcards(dbFilter) ? " TABLE_SCHEMA LIKE ?" : " TABLE_SCHEMA = ?");
            }
            if (tableNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(StringUtils.hasWildcards(tableNameFilter) ? " TABLE_NAME LIKE ?" : " TABLE_NAME = ?");
            }
            if (columnNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(StringUtils.hasWildcards(columnNameFilter) ? " COLUMN_NAME LIKE ?" : " COLUMN_NAME = ?");
            }
            if (condition.length() > 0) {
                query.append(" WHERE");
            }
            query.append((CharSequence)condition);
            query.append(" ORDER BY TABLE_SCHEMA, TABLE_NAME, ORDINAL_POSITION");
            try (PreparedStatement pStmt = null;){
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextId++, dbFilter);
                }
                if (tableNameFilter != null) {
                    pStmt.setString(nextId++, tableNameFilter);
                }
                if (columnNameFilter != null) {
                    pStmt.setString(nextId, columnNameFilter);
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createColumnsFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            if (parentTable == null || foreignTable == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String parentDbFromTerm = this.getDatabase(parentCatalog, parentSchema);
            String parentDbFilter = this.pedantic ? parentDbFromTerm : StringUtils.unQuoteIdentifier(parentDbFromTerm, this.quotedId);
            String parentTableFilter = this.pedantic ? parentTable : StringUtils.unQuoteIdentifier(parentTable, this.quotedId);
            String foreignDbFilter = this.getDatabase(foreignCatalog, foreignSchema);
            String foreignTableFilter = this.pedantic ? foreignTable : StringUtils.unQuoteIdentifier(foreignTable, this.quotedId);
            StringBuilder query = new StringBuilder(dbMapsToSchema ? "SELECT DISTINCT A.CONSTRAINT_CATALOG AS PKTABLE_CAT, A.REFERENCED_TABLE_SCHEMA AS PKTABLE_SCHEM," : "SELECT DISTINCT A.REFERENCED_TABLE_SCHEMA AS PKTABLE_CAT,NULL AS PKTABLE_SCHEM,");
            query.append(" A.REFERENCED_TABLE_NAME AS PKTABLE_NAME, A.REFERENCED_COLUMN_NAME AS PKCOLUMN_NAME,");
            query.append(dbMapsToSchema ? " A.TABLE_CATALOG AS FKTABLE_CAT, A.TABLE_SCHEMA AS FKTABLE_SCHEM," : " A.TABLE_SCHEMA AS FKTABLE_CAT, NULL AS FKTABLE_SCHEM,");
            query.append(" A.TABLE_NAME AS FKTABLE_NAME, A.COLUMN_NAME AS FKCOLUMN_NAME, A.ORDINAL_POSITION AS KEY_SEQ,");
            query.append(this.generateUpdateRuleClause());
            query.append(" AS UPDATE_RULE,");
            query.append(this.generateDeleteRuleClause());
            query.append(" AS DELETE_RULE, A.CONSTRAINT_NAME AS FK_NAME, TC.CONSTRAINT_NAME AS PK_NAME,");
            query.append(7);
            query.append(" AS DEFERRABILITY FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE A");
            query.append(" JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS B USING (TABLE_SCHEMA, TABLE_NAME, CONSTRAINT_NAME) ");
            query.append(this.generateOptionalRefContraintsJoin());
            query.append(" LEFT JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS TC ON (A.REFERENCED_TABLE_SCHEMA = TC.TABLE_SCHEMA");
            query.append("  AND A.REFERENCED_TABLE_NAME = TC.TABLE_NAME");
            query.append("  AND TC.CONSTRAINT_TYPE IN ('UNIQUE', 'PRIMARY KEY'))");
            query.append("WHERE B.CONSTRAINT_TYPE = 'FOREIGN KEY'");
            if (parentDbFilter != null) {
                query.append(" AND A.REFERENCED_TABLE_SCHEMA=?");
            }
            query.append(" AND A.REFERENCED_TABLE_NAME=?");
            if (foreignDbFilter != null) {
                query.append(" AND A.TABLE_SCHEMA = ?");
            }
            query.append(" AND A.TABLE_NAME=?");
            query.append(" ORDER BY FKTABLE_NAME, FKTABLE_NAME, KEY_SEQ");
            try (PreparedStatement pStmt = null;){
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                if (parentDbFilter != null) {
                    pStmt.setString(nextId++, parentDbFilter);
                }
                pStmt.setString(nextId++, parentTableFilter);
                if (foreignDbFilter != null) {
                    pStmt.setString(nextId++, foreignDbFilter);
                }
                pStmt.setString(nextId, foreignTableFilter);
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createFkMetadataFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFromTerm = this.getDatabase(catalog, schema);
            String dbFilter = this.pedantic ? dbFromTerm : StringUtils.unQuoteIdentifier(dbFromTerm, this.quotedId);
            String tableFilter = this.pedantic ? table : StringUtils.unQuoteIdentifier(table, this.quotedId);
            StringBuilder query = new StringBuilder(dbMapsToSchema ? "SELECT DISTINCT A.CONSTRAINT_CATALOG AS PKTABLE_CAT, A.REFERENCED_TABLE_SCHEMA AS PKTABLE_SCHEM," : "SELECT DISTINCT A.REFERENCED_TABLE_SCHEMA AS PKTABLE_CAT,NULL AS PKTABLE_SCHEM,");
            query.append(" A.REFERENCED_TABLE_NAME AS PKTABLE_NAME, A.REFERENCED_COLUMN_NAME AS PKCOLUMN_NAME,");
            query.append(dbMapsToSchema ? " A.TABLE_CATALOG AS FKTABLE_CAT, A.TABLE_SCHEMA AS FKTABLE_SCHEM," : " A.TABLE_SCHEMA AS FKTABLE_CAT, NULL AS FKTABLE_SCHEM,");
            query.append(" A.TABLE_NAME AS FKTABLE_NAME, A.COLUMN_NAME AS FKCOLUMN_NAME, A.ORDINAL_POSITION AS KEY_SEQ,");
            query.append(this.generateUpdateRuleClause());
            query.append(" AS UPDATE_RULE,");
            query.append(this.generateDeleteRuleClause());
            query.append(" AS DELETE_RULE, A.CONSTRAINT_NAME AS FK_NAME, TC.CONSTRAINT_NAME AS PK_NAME,");
            query.append(7);
            query.append(" AS DEFERRABILITY FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE A");
            query.append(" JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS B USING (TABLE_SCHEMA, TABLE_NAME, CONSTRAINT_NAME) ");
            query.append(this.generateOptionalRefContraintsJoin());
            query.append(" LEFT JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS TC ON (A.REFERENCED_TABLE_SCHEMA = TC.TABLE_SCHEMA");
            query.append("  AND A.REFERENCED_TABLE_NAME = TC.TABLE_NAME");
            query.append("  AND TC.CONSTRAINT_TYPE IN ('UNIQUE', 'PRIMARY KEY'))");
            query.append(" WHERE B.CONSTRAINT_TYPE = 'FOREIGN KEY'");
            if (dbFilter != null) {
                query.append(" AND A.REFERENCED_TABLE_SCHEMA = ?");
            }
            query.append(" AND A.REFERENCED_TABLE_NAME=?");
            query.append(" ORDER BY FKTABLE_NAME, FKTABLE_NAME, KEY_SEQ");
            try (PreparedStatement pStmt = null;){
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextId++, dbFilter);
                }
                pStmt.setString(nextId, tableFilter);
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createFkMetadataFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private String generateOptionalRefContraintsJoin() {
        return "JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS R ON (R.CONSTRAINT_NAME = B.CONSTRAINT_NAME AND R.TABLE_NAME = B.TABLE_NAME AND R.CONSTRAINT_SCHEMA = B.TABLE_SCHEMA) ";
    }

    private String generateDeleteRuleClause() {
        return "CASE WHEN R.DELETE_RULE='CASCADE' THEN " + String.valueOf(0) + " WHEN R.DELETE_RULE='SET NULL' THEN " + String.valueOf(2) + " WHEN R.DELETE_RULE='SET DEFAULT' THEN " + String.valueOf(4) + " WHEN R.DELETE_RULE='RESTRICT' THEN " + String.valueOf(1) + " WHEN R.DELETE_RULE='NO ACTION' THEN " + String.valueOf(1) + " ELSE " + String.valueOf(1) + " END ";
    }

    private String generateUpdateRuleClause() {
        return "CASE WHEN R.UPDATE_RULE='CASCADE' THEN " + String.valueOf(0) + " WHEN R.UPDATE_RULE='SET NULL' THEN " + String.valueOf(2) + " WHEN R.UPDATE_RULE='SET DEFAULT' THEN " + String.valueOf(4) + " WHEN R.UPDATE_RULE='RESTRICT' THEN " + String.valueOf(1) + " WHEN R.UPDATE_RULE='NO ACTION' THEN " + String.valueOf(1) + " ELSE " + String.valueOf(1) + " END ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFromTerm = this.getDatabase(catalog, schema);
            String dbFilter = this.pedantic ? dbFromTerm : StringUtils.unQuoteIdentifier(dbFromTerm, this.quotedId);
            String tableFilter = this.pedantic ? table : StringUtils.unQuoteIdentifier(table, this.quotedId);
            StringBuilder query = new StringBuilder(dbMapsToSchema ? "SELECT DISTINCT A.CONSTRAINT_CATALOG AS PKTABLE_CAT, A.REFERENCED_TABLE_SCHEMA AS PKTABLE_SCHEM," : "SELECT DISTINCT A.REFERENCED_TABLE_SCHEMA AS PKTABLE_CAT,NULL AS PKTABLE_SCHEM,");
            query.append(" A.REFERENCED_TABLE_NAME AS PKTABLE_NAME, A.REFERENCED_COLUMN_NAME AS PKCOLUMN_NAME,");
            query.append(dbMapsToSchema ? " A.TABLE_CATALOG AS FKTABLE_CAT, A.TABLE_SCHEMA AS FKTABLE_SCHEM," : " A.TABLE_SCHEMA AS FKTABLE_CAT, NULL AS FKTABLE_SCHEM,");
            query.append(" A.TABLE_NAME AS FKTABLE_NAME, A.COLUMN_NAME AS FKCOLUMN_NAME, A.ORDINAL_POSITION AS KEY_SEQ,");
            query.append(this.generateUpdateRuleClause());
            query.append(" AS UPDATE_RULE,");
            query.append(this.generateDeleteRuleClause());
            query.append(" AS DELETE_RULE, A.CONSTRAINT_NAME AS FK_NAME, R.UNIQUE_CONSTRAINT_NAME AS PK_NAME,");
            query.append(7);
            query.append(" AS DEFERRABILITY FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE A");
            query.append(" JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS B USING (CONSTRAINT_SCHEMA, CONSTRAINT_NAME, TABLE_NAME) ");
            query.append(this.generateOptionalRefContraintsJoin());
            query.append("WHERE B.CONSTRAINT_TYPE = 'FOREIGN KEY'");
            if (dbFilter != null) {
                query.append(" AND A.TABLE_SCHEMA = ?");
            }
            query.append(" AND A.TABLE_NAME=?");
            query.append(" AND A.REFERENCED_TABLE_SCHEMA IS NOT NULL");
            query.append(" ORDER BY A.REFERENCED_TABLE_SCHEMA, A.REFERENCED_TABLE_NAME, A.ORDINAL_POSITION");
            try (PreparedStatement pStmt = null;){
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextId++, dbFilter);
                }
                pStmt.setString(nextId, tableFilter);
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createFkMetadataFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFromTerm = this.getDatabase(catalog, schema);
            String dbFilter = this.pedantic ? dbFromTerm : StringUtils.unQuoteIdentifier(dbFromTerm, this.quotedId);
            String tableFilter = this.pedantic ? table : StringUtils.unQuoteIdentifier(table, this.quotedId);
            StringBuilder query = new StringBuilder(dbMapsToSchema ? "SELECT TABLE_CATALOG AS TABLE_CAT, TABLE_SCHEMA AS TABLE_SCHEM," : "SELECT TABLE_SCHEMA AS TABLE_CAT, NULL AS TABLE_SCHEM,");
            query.append(" TABLE_NAME, NON_UNIQUE, NULL AS INDEX_QUALIFIER, INDEX_NAME,");
            query.append(3);
            query.append(" AS TYPE, SEQ_IN_INDEX AS ORDINAL_POSITION, COLUMN_NAME,");
            query.append("COLLATION AS ASC_OR_DESC, CARDINALITY, 0 AS PAGES, NULL AS FILTER_CONDITION FROM INFORMATION_SCHEMA.STATISTICS WHERE");
            if (dbFilter != null) {
                query.append(" TABLE_SCHEMA = ? AND");
            }
            query.append(" TABLE_NAME = ?");
            if (unique) {
                query.append(" AND NON_UNIQUE=0 ");
            }
            query.append(" ORDER BY NON_UNIQUE, INDEX_NAME, SEQ_IN_INDEX");
            try (PreparedStatement pStmt = null;){
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextId++, dbFilter);
                }
                pStmt.setString(nextId, tableFilter);
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createIndexInfoFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFromTerm = this.getDatabase(catalog, schema);
            String dbFilter = this.pedantic ? dbFromTerm : StringUtils.unQuoteIdentifier(dbFromTerm, this.quotedId);
            String tableFilter = this.pedantic ? table : StringUtils.unQuoteIdentifier(table, this.quotedId);
            StringBuilder query = new StringBuilder(dbMapsToSchema ? "SELECT TABLE_CATALOG AS TABLE_CAT, TABLE_SCHEMA AS TABLE_SCHEM," : "SELECT TABLE_SCHEMA AS TABLE_CAT, NULL AS TABLE_SCHEM,");
            query.append(" TABLE_NAME, COLUMN_NAME, SEQ_IN_INDEX AS KEY_SEQ, 'PRIMARY' AS PK_NAME FROM INFORMATION_SCHEMA.STATISTICS WHERE");
            if (dbFilter != null) {
                query.append(" TABLE_SCHEMA = ? AND");
            }
            query.append(" TABLE_NAME = ?");
            query.append(" AND INDEX_NAME='PRIMARY' ORDER BY TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, SEQ_IN_INDEX");
            try (PreparedStatement pStmt = null;){
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextId++, dbFilter);
                }
                pStmt.setString(nextId, tableFilter);
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.getPrimaryKeysFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFilter = this.getDatabase(catalog, schemaPattern);
            dbFilter = this.pedantic ? dbFilter : StringUtils.unQuoteIdentifier(dbFilter, this.quotedId);
            String tableNameFilter = this.pedantic ? tableNamePattern : StringUtils.unQuoteIdentifier(tableNamePattern, this.quotedId);
            PreparedStatement pStmt = null;
            StringBuilder query = new StringBuilder(dbMapsToSchema ? "SELECT TABLE_CATALOG AS TABLE_CAT, TABLE_SCHEMA AS TABLE_SCHEM," : "SELECT TABLE_SCHEMA AS TABLE_CAT, NULL AS TABLE_SCHEM,");
            query.append(" TABLE_NAME, CASE WHEN TABLE_TYPE='BASE TABLE' THEN ");
            query.append("CASE WHEN TABLE_SCHEMA='mysql' OR TABLE_SCHEMA='performance_schema' OR TABLE_SCHEMA='sys' THEN 'SYSTEM TABLE' ELSE 'TABLE' END ");
            query.append("WHEN TABLE_TYPE='TEMPORARY' THEN 'LOCAL_TEMPORARY' ELSE TABLE_TYPE END AS TABLE_TYPE, ");
            query.append("TABLE_COMMENT AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, ");
            query.append("NULL AS REF_GENERATION FROM INFORMATION_SCHEMA.TABLES");
            if (dbFilter != null || tableNameFilter != null) {
                query.append(" WHERE");
            }
            if (dbFilter != null) {
                query.append(dbMapsToSchema && StringUtils.hasWildcards(dbFilter) ? " TABLE_SCHEMA LIKE ?" : " TABLE_SCHEMA = ?");
            }
            if (tableNameFilter != null) {
                if (dbFilter != null) {
                    query.append(" AND");
                }
                query.append(StringUtils.hasWildcards(tableNameFilter) ? " TABLE_NAME LIKE ?" : " TABLE_NAME = ?");
            }
            if (types != null && types.length > 0) {
                query.append(" HAVING TABLE_TYPE IN (?,?,?,?,?)");
            }
            query.append(" ORDER BY TABLE_TYPE, TABLE_SCHEMA, TABLE_NAME");
            try {
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextId++, dbFilter != null ? dbFilter : "%");
                }
                if (tableNameFilter != null) {
                    pStmt.setString(nextId++, tableNameFilter);
                }
                if (types != null && types.length > 0) {
                    int i;
                    for (i = 0; i < 5; ++i) {
                        pStmt.setNull(nextId + i, MysqlType.VARCHAR.getJdbcType());
                    }
                    for (i = 0; i < types.length; ++i) {
                        DatabaseMetaData.TableType tableType = DatabaseMetaData.TableType.getTableTypeEqualTo(types[i]);
                        if (tableType == DatabaseMetaData.TableType.UNKNOWN) continue;
                        pStmt.setString(nextId++, tableType.getName());
                    }
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).setColumnDefinition(this.createTablesFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFromTerm = this.getDatabase(catalog, schema);
            String dbFilter = this.pedantic ? dbFromTerm : StringUtils.unQuoteIdentifier(dbFromTerm, this.quotedId);
            String tableFilter = this.pedantic ? table : StringUtils.unQuoteIdentifier(table, this.quotedId);
            StringBuilder query = new StringBuilder("SELECT NULL AS SCOPE, COLUMN_NAME, ");
            this.appendJdbcTypeMappingQuery(query, "DATA_TYPE", "COLUMN_TYPE");
            query.append(" AS DATA_TYPE, UPPER(COLUMN_TYPE) AS TYPE_NAME,");
            query.append(" CASE WHEN LCASE(DATA_TYPE)='date' THEN 10");
            if (this.conn.getServerVersion().meetsMinimum(ServerVersion.parseVersion("5.6.4"))) {
                query.append(" WHEN LCASE(DATA_TYPE)='time'");
                query.append("  THEN 8+(CASE WHEN DATETIME_PRECISION>0 THEN DATETIME_PRECISION+1 ELSE DATETIME_PRECISION END)");
                query.append(" WHEN LCASE(DATA_TYPE)='datetime' OR LCASE(DATA_TYPE)='timestamp'");
                query.append("  THEN 19+(CASE WHEN DATETIME_PRECISION>0 THEN DATETIME_PRECISION+1 ELSE DATETIME_PRECISION END)");
            } else {
                query.append(" WHEN LCASE(DATA_TYPE)='time' THEN 8");
                query.append(" WHEN LCASE(DATA_TYPE)='datetime' OR LCASE(DATA_TYPE)='timestamp' THEN 19");
            }
            query.append(" WHEN CHARACTER_MAXIMUM_LENGTH IS NULL THEN NUMERIC_PRECISION WHEN CHARACTER_MAXIMUM_LENGTH > ");
            query.append(Integer.MAX_VALUE);
            query.append(" THEN ");
            query.append(Integer.MAX_VALUE);
            query.append(" ELSE CHARACTER_MAXIMUM_LENGTH END AS COLUMN_SIZE, ");
            query.append(maxBufferSize);
            query.append(" AS BUFFER_LENGTH,NUMERIC_SCALE AS DECIMAL_DIGITS, ");
            query.append(Integer.toString(1));
            query.append(" AS PSEUDO_COLUMN FROM INFORMATION_SCHEMA.COLUMNS WHERE");
            if (dbFilter != null) {
                query.append(" TABLE_SCHEMA = ? AND");
            }
            query.append(" TABLE_NAME = ?");
            query.append(" AND EXTRA LIKE '%on update CURRENT_TIMESTAMP%'");
            try (PreparedStatement pStmt = null;){
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextId++, dbFilter);
                }
                pStmt.setString(nextId, tableFilter);
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.getVersionColumnsFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFilter = this.getDatabase(catalog, schemaPattern);
            dbFilter = this.pedantic ? dbFilter : StringUtils.unQuoteIdentifier(dbFilter, this.quotedId);
            String procedureNameFilter = this.pedantic ? procedureNamePattern : StringUtils.unQuoteIdentifier(procedureNamePattern, this.quotedId);
            StringBuilder query = new StringBuilder(dbMapsToSchema ? "SELECT ROUTINE_CATALOG AS PROCEDURE_CAT, ROUTINE_SCHEMA AS PROCEDURE_SCHEM," : "SELECT ROUTINE_SCHEMA AS PROCEDURE_CAT, NULL AS PROCEDURE_SCHEM,");
            query.append(" ROUTINE_NAME AS PROCEDURE_NAME, NULL AS RESERVED_1, NULL AS RESERVED_2, NULL AS RESERVED_3, ROUTINE_COMMENT AS REMARKS, CASE WHEN ROUTINE_TYPE = 'PROCEDURE' THEN ");
            query.append(1);
            query.append(" WHEN ROUTINE_TYPE='FUNCTION' THEN ");
            query.append(2);
            query.append(" ELSE ");
            query.append(0);
            query.append(" END AS PROCEDURE_TYPE, ROUTINE_NAME AS SPECIFIC_NAME FROM INFORMATION_SCHEMA.ROUTINES");
            StringBuilder condition = new StringBuilder();
            if (!this.conn.getPropertySet().getBooleanProperty(PropertyKey.getProceduresReturnsFunctions).getValue().booleanValue()) {
                condition.append(" ROUTINE_TYPE = 'PROCEDURE'");
            }
            if (dbFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(dbMapsToSchema ? " ROUTINE_SCHEMA LIKE ?" : " ROUTINE_SCHEMA = ?");
            }
            if (procedureNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(" ROUTINE_NAME LIKE ?");
            }
            if (condition.length() > 0) {
                query.append(" WHERE");
                query.append((CharSequence)condition);
            }
            query.append(" ORDER BY ROUTINE_SCHEMA, ROUTINE_NAME, ROUTINE_TYPE");
            try (PreparedStatement pStmt = null;){
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextId++, dbFilter);
                }
                if (procedureNameFilter != null) {
                    pStmt.setString(nextId, procedureNameFilter);
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createFieldMetadataForGetProcedures());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFilter = this.getDatabase(catalog, schemaPattern);
            dbFilter = this.pedantic ? dbFilter : StringUtils.unQuoteIdentifier(dbFilter, this.quotedId);
            String procedureNameFilter = this.pedantic ? procedureNamePattern : StringUtils.unQuoteIdentifier(procedureNamePattern, this.quotedId);
            String columnNameFilter = this.pedantic ? columnNamePattern : StringUtils.unQuoteIdentifier(columnNamePattern, this.quotedId);
            boolean supportsFractSeconds = this.conn.getServerVersion().meetsMinimum(ServerVersion.parseVersion("5.6.4"));
            StringBuilder query = new StringBuilder(dbMapsToSchema ? "SELECT SPECIFIC_CATALOG AS PROCEDURE_CAT, SPECIFIC_SCHEMA AS `PROCEDURE_SCHEM`," : "SELECT SPECIFIC_SCHEMA AS PROCEDURE_CAT, NULL AS `PROCEDURE_SCHEM`,");
            query.append(" SPECIFIC_NAME AS `PROCEDURE_NAME`, IFNULL(PARAMETER_NAME, '') AS `COLUMN_NAME`,");
            query.append(" CASE WHEN PARAMETER_MODE = 'IN' THEN ");
            query.append(1);
            query.append(" WHEN PARAMETER_MODE = 'OUT' THEN ");
            query.append(4);
            query.append(" WHEN PARAMETER_MODE = 'INOUT' THEN ");
            query.append(2);
            query.append(" WHEN ORDINAL_POSITION = 0 THEN ");
            query.append(5);
            query.append(" ELSE ");
            query.append(0);
            query.append(" END AS `COLUMN_TYPE`, ");
            this.appendJdbcTypeMappingQuery(query, "DATA_TYPE", "DTD_IDENTIFIER");
            query.append(" AS `DATA_TYPE`, ");
            query.append("UPPER(CASE");
            if (this.tinyInt1isBit) {
                query.append(" WHEN UPPER(DATA_TYPE)='TINYINT' THEN CASE");
                query.append(" WHEN LOCATE('ZEROFILL', UPPER(DTD_IDENTIFIER)) = 0 AND LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) = 0 AND LOCATE('(1)', DTD_IDENTIFIER) != 0 THEN ");
                query.append(this.transformedBitIsBoolean ? "'BOOLEAN'" : "'BIT'");
                query.append(" WHEN LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) != 0 AND LOCATE('UNSIGNED', UPPER(DATA_TYPE)) = 0 THEN 'TINYINT UNSIGNED'");
                query.append(" ELSE DATA_TYPE END ");
            }
            query.append(" WHEN LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) != 0 AND LOCATE('UNSIGNED', UPPER(DATA_TYPE)) = 0 AND LOCATE('SET', UPPER(DATA_TYPE)) <> 1 AND LOCATE('ENUM', UPPER(DATA_TYPE)) <> 1 THEN CONCAT(DATA_TYPE, ' UNSIGNED')");
            query.append(" WHEN UPPER(DATA_TYPE)='POINT' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='LINESTRING' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='POLYGON' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='MULTIPOINT' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='MULTILINESTRING' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='MULTIPOLYGON' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='GEOMETRYCOLLECTION' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='GEOMCOLLECTION' THEN 'GEOMETRY'");
            query.append(" ELSE UPPER(DATA_TYPE) END) AS TYPE_NAME,");
            query.append(" CASE WHEN LCASE(DATA_TYPE)='date' THEN 0");
            if (supportsFractSeconds) {
                query.append(" WHEN LCASE(DATA_TYPE)='time' OR LCASE(DATA_TYPE)='datetime' OR LCASE(DATA_TYPE)='timestamp' THEN DATETIME_PRECISION");
            } else {
                query.append(" WHEN LCASE(DATA_TYPE)='time' OR LCASE(DATA_TYPE)='datetime' OR LCASE(DATA_TYPE)='timestamp' THEN 0");
            }
            if (this.tinyInt1isBit && !this.transformedBitIsBoolean) {
                query.append(" WHEN (UPPER(DATA_TYPE)='TINYINT' AND LOCATE('ZEROFILL', UPPER(DTD_IDENTIFIER)) = 0) AND LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) = 0 AND LOCATE('(1)', DTD_IDENTIFIER) != 0 THEN 1");
            }
            query.append(" WHEN UPPER(DATA_TYPE)='MEDIUMINT' AND LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) != 0 THEN 8");
            query.append(" WHEN UPPER(DATA_TYPE)='JSON' THEN 1073741824");
            query.append(" ELSE NUMERIC_PRECISION END AS `PRECISION`,");
            query.append(" CASE WHEN LCASE(DATA_TYPE)='date' THEN 10");
            if (supportsFractSeconds) {
                query.append(" WHEN LCASE(DATA_TYPE)='time' THEN 8+(CASE WHEN DATETIME_PRECISION>0 THEN DATETIME_PRECISION+1 ELSE DATETIME_PRECISION END)");
                query.append(" WHEN LCASE(DATA_TYPE)='datetime' OR LCASE(DATA_TYPE)='timestamp'");
                query.append("  THEN 19+(CASE WHEN DATETIME_PRECISION>0 THEN DATETIME_PRECISION+1 ELSE DATETIME_PRECISION END)");
            } else {
                query.append(" WHEN LCASE(DATA_TYPE)='time' THEN 8");
                query.append(" WHEN LCASE(DATA_TYPE)='datetime' OR LCASE(DATA_TYPE)='timestamp' THEN 19");
            }
            if (this.tinyInt1isBit && !this.transformedBitIsBoolean) {
                query.append(" WHEN (UPPER(DATA_TYPE)='TINYINT' OR UPPER(DATA_TYPE)='TINYINT UNSIGNED') AND LOCATE('ZEROFILL', UPPER(DTD_IDENTIFIER)) = 0 AND LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) = 0 AND LOCATE('(1)', DTD_IDENTIFIER) != 0 THEN 1");
            }
            query.append(" WHEN UPPER(DATA_TYPE)='MEDIUMINT' AND LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) != 0 THEN 8");
            query.append(" WHEN UPPER(DATA_TYPE)='JSON' THEN 1073741824");
            query.append(" WHEN CHARACTER_MAXIMUM_LENGTH IS NULL THEN NUMERIC_PRECISION");
            query.append(" WHEN CHARACTER_MAXIMUM_LENGTH > ");
            query.append(Integer.MAX_VALUE);
            query.append(" THEN ");
            query.append(Integer.MAX_VALUE);
            query.append(" ELSE CHARACTER_MAXIMUM_LENGTH END AS LENGTH,");
            query.append("NUMERIC_SCALE AS `SCALE`, ");
            query.append("10 AS RADIX,");
            query.append(1);
            query.append(" AS `NULLABLE`, NULL AS `REMARKS`, NULL AS `COLUMN_DEF`, NULL AS `SQL_DATA_TYPE`, NULL AS `SQL_DATETIME_SUB`,");
            query.append(" CASE WHEN CHARACTER_OCTET_LENGTH > ");
            query.append(Integer.MAX_VALUE);
            query.append(" THEN ");
            query.append(Integer.MAX_VALUE);
            query.append(" ELSE CHARACTER_OCTET_LENGTH END AS `CHAR_OCTET_LENGTH`,");
            query.append(" ORDINAL_POSITION, 'YES' AS `IS_NULLABLE`, SPECIFIC_NAME");
            query.append(" FROM INFORMATION_SCHEMA.PARAMETERS");
            StringBuilder condition = new StringBuilder();
            if (!this.conn.getPropertySet().getBooleanProperty(PropertyKey.getProceduresReturnsFunctions).getValue().booleanValue()) {
                condition.append(" ROUTINE_TYPE = 'PROCEDURE'");
            }
            if (dbFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(dbMapsToSchema ? " SPECIFIC_SCHEMA LIKE ?" : " SPECIFIC_SCHEMA = ?");
            }
            if (procedureNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(" SPECIFIC_NAME LIKE ?");
            }
            if (columnNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(" (PARAMETER_NAME LIKE ? OR PARAMETER_NAME IS NULL)");
            }
            if (condition.length() > 0) {
                query.append(" WHERE");
                query.append((CharSequence)condition);
            }
            query.append(" ORDER BY SPECIFIC_SCHEMA, SPECIFIC_NAME, ROUTINE_TYPE, ORDINAL_POSITION");
            try (PreparedStatement pStmt = null;){
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextId++, dbFilter);
                }
                if (procedureNameFilter != null) {
                    pStmt.setString(nextId++, procedureNameFilter);
                }
                if (columnNameFilter != null) {
                    pStmt.setString(nextId, columnNameFilter);
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createProcedureColumnsFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected int getFunctionConstant(FunctionConstant constant) {
        switch (constant) {
            case FUNCTION_COLUMN_IN: {
                return 1;
            }
            case FUNCTION_COLUMN_INOUT: {
                return 2;
            }
            case FUNCTION_COLUMN_OUT: {
                return 3;
            }
            case FUNCTION_COLUMN_RETURN: {
                return 4;
            }
            case FUNCTION_COLUMN_RESULT: {
                return 5;
            }
            case FUNCTION_COLUMN_UNKNOWN: {
                return 0;
            }
            case FUNCTION_NO_NULLS: {
                return 0;
            }
            case FUNCTION_NULLABLE: {
                return 1;
            }
            case FUNCTION_NULLABLE_UNKNOWN: {
                return 2;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try {
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFilter = this.getDatabase(catalog, schemaPattern);
            dbFilter = this.pedantic ? dbFilter : StringUtils.unQuoteIdentifier(dbFilter, this.quotedId);
            String functionNameFilter = this.pedantic ? functionNamePattern : StringUtils.unQuoteIdentifier(functionNamePattern, this.quotedId);
            StringBuilder query = new StringBuilder(dbMapsToSchema ? "SELECT ROUTINE_CATALOG AS FUNCTION_CAT, ROUTINE_SCHEMA AS FUNCTION_SCHEM," : "SELECT ROUTINE_SCHEMA AS FUNCTION_CAT, NULL AS FUNCTION_SCHEM,");
            query.append(" ROUTINE_NAME AS FUNCTION_NAME, ROUTINE_COMMENT AS REMARKS, ");
            query.append(1);
            query.append(" AS FUNCTION_TYPE, ROUTINE_NAME AS SPECIFIC_NAME FROM INFORMATION_SCHEMA.ROUTINES");
            query.append(" WHERE ROUTINE_TYPE LIKE 'FUNCTION'");
            if (dbFilter != null) {
                query.append(dbMapsToSchema ? " AND ROUTINE_SCHEMA LIKE ?" : " AND ROUTINE_SCHEMA = ?");
            }
            if (functionNameFilter != null) {
                query.append(" AND ROUTINE_NAME LIKE ?");
            }
            query.append(" ORDER BY FUNCTION_CAT, FUNCTION_SCHEM, FUNCTION_NAME, SPECIFIC_NAME");
            try (PreparedStatement pStmt = null;){
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextId++, dbFilter);
                }
                if (functionNameFilter != null) {
                    pStmt.setString(nextId, functionNameFilter);
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.getFunctionsFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        try {
            boolean dbMapsToSchema = this.databaseTerm.getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA;
            String dbFilter = this.getDatabase(catalog, schemaPattern);
            dbFilter = this.pedantic ? dbFilter : StringUtils.unQuoteIdentifier(dbFilter, this.quotedId);
            String functionNameFilter = this.pedantic ? functionNamePattern : StringUtils.unQuoteIdentifier(functionNamePattern, this.quotedId);
            String columnNameFilter = this.pedantic ? columnNamePattern : StringUtils.unQuoteIdentifier(columnNamePattern, this.quotedId);
            boolean supportsFractSeconds = this.conn.getServerVersion().meetsMinimum(ServerVersion.parseVersion("5.6.4"));
            StringBuilder query = new StringBuilder(dbMapsToSchema ? "SELECT SPECIFIC_CATALOG AS FUNCTION_CAT, SPECIFIC_SCHEMA AS `FUNCTION_SCHEM`," : "SELECT SPECIFIC_SCHEMA AS FUNCTION_CAT, NULL AS `FUNCTION_SCHEM`,");
            query.append(" SPECIFIC_NAME AS `FUNCTION_NAME`, IFNULL(PARAMETER_NAME, '') AS `COLUMN_NAME`, CASE WHEN PARAMETER_MODE = 'IN' THEN ");
            query.append(this.getFunctionConstant(FunctionConstant.FUNCTION_COLUMN_IN));
            query.append(" WHEN PARAMETER_MODE = 'OUT' THEN ");
            query.append(this.getFunctionConstant(FunctionConstant.FUNCTION_COLUMN_OUT));
            query.append(" WHEN PARAMETER_MODE = 'INOUT' THEN ");
            query.append(this.getFunctionConstant(FunctionConstant.FUNCTION_COLUMN_INOUT));
            query.append(" WHEN ORDINAL_POSITION = 0 THEN ");
            query.append(this.getFunctionConstant(FunctionConstant.FUNCTION_COLUMN_RETURN));
            query.append(" ELSE ");
            query.append(this.getFunctionConstant(FunctionConstant.FUNCTION_COLUMN_UNKNOWN));
            query.append(" END AS `COLUMN_TYPE`, ");
            this.appendJdbcTypeMappingQuery(query, "DATA_TYPE", "DTD_IDENTIFIER");
            query.append(" AS `DATA_TYPE`, ");
            query.append("UPPER(CASE");
            if (this.tinyInt1isBit) {
                query.append(" WHEN UPPER(DATA_TYPE)='TINYINT' THEN CASE");
                query.append(" WHEN LOCATE('ZEROFILL', UPPER(DTD_IDENTIFIER)) = 0 AND LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) = 0 AND LOCATE('(1)', DTD_IDENTIFIER) != 0 THEN ");
                query.append(this.transformedBitIsBoolean ? "'BOOLEAN'" : "'BIT'");
                query.append(" WHEN LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) != 0 AND LOCATE('UNSIGNED', UPPER(DATA_TYPE)) = 0 THEN 'TINYINT UNSIGNED'");
                query.append(" ELSE DATA_TYPE END ");
            }
            query.append(" WHEN LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) != 0 AND LOCATE('UNSIGNED', UPPER(DATA_TYPE)) = 0 AND LOCATE('SET', UPPER(DATA_TYPE)) <> 1 AND LOCATE('ENUM', UPPER(DATA_TYPE)) <> 1 THEN CONCAT(DATA_TYPE, ' UNSIGNED')");
            query.append(" WHEN UPPER(DATA_TYPE)='POINT' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='LINESTRING' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='POLYGON' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='MULTIPOINT' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='MULTILINESTRING' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='MULTIPOLYGON' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='GEOMETRYCOLLECTION' THEN 'GEOMETRY'");
            query.append(" WHEN UPPER(DATA_TYPE)='GEOMCOLLECTION' THEN 'GEOMETRY'");
            query.append(" ELSE UPPER(DATA_TYPE) END) AS TYPE_NAME,");
            query.append(" CASE WHEN LCASE(DATA_TYPE)='date' THEN 0");
            if (supportsFractSeconds) {
                query.append(" WHEN LCASE(DATA_TYPE)='time' OR LCASE(DATA_TYPE)='datetime' OR LCASE(DATA_TYPE)='timestamp' THEN DATETIME_PRECISION");
            } else {
                query.append(" WHEN LCASE(DATA_TYPE)='time' OR LCASE(DATA_TYPE)='datetime' OR LCASE(DATA_TYPE)='timestamp' THEN 0");
            }
            if (this.tinyInt1isBit && !this.transformedBitIsBoolean) {
                query.append(" WHEN UPPER(DATA_TYPE)='TINYINT' AND LOCATE('ZEROFILL', UPPER(DTD_IDENTIFIER)) = 0 AND LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) = 0 AND LOCATE('(1)', DTD_IDENTIFIER) != 0 THEN 1");
            }
            query.append(" WHEN UPPER(DATA_TYPE)='MEDIUMINT' AND LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) != 0 THEN 8");
            query.append(" WHEN UPPER(DATA_TYPE)='JSON' THEN 1073741824");
            query.append(" ELSE NUMERIC_PRECISION END AS `PRECISION`,");
            query.append(" CASE WHEN LCASE(DATA_TYPE)='date' THEN 10");
            if (supportsFractSeconds) {
                query.append(" WHEN LCASE(DATA_TYPE)='time' THEN 8+(CASE WHEN DATETIME_PRECISION>0 THEN DATETIME_PRECISION+1 ELSE DATETIME_PRECISION END)");
                query.append(" WHEN LCASE(DATA_TYPE)='datetime' OR LCASE(DATA_TYPE)='timestamp'");
                query.append("  THEN 19+(CASE WHEN DATETIME_PRECISION>0 THEN DATETIME_PRECISION+1 ELSE DATETIME_PRECISION END)");
            } else {
                query.append(" WHEN LCASE(DATA_TYPE)='time' THEN 8");
                query.append(" WHEN LCASE(DATA_TYPE)='datetime' OR LCASE(DATA_TYPE)='timestamp' THEN 19");
            }
            if (this.tinyInt1isBit && !this.transformedBitIsBoolean) {
                query.append(" WHEN (UPPER(DATA_TYPE)='TINYINT' OR UPPER(DATA_TYPE)='TINYINT UNSIGNED') AND LOCATE('ZEROFILL', UPPER(DTD_IDENTIFIER)) = 0 AND LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) = 0 AND LOCATE('(1)', DTD_IDENTIFIER) != 0 THEN 1");
            }
            query.append(" WHEN UPPER(DATA_TYPE)='MEDIUMINT' AND LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) != 0 THEN 8");
            query.append(" WHEN UPPER(DATA_TYPE)='JSON' THEN 1073741824");
            query.append(" WHEN CHARACTER_MAXIMUM_LENGTH IS NULL THEN NUMERIC_PRECISION");
            query.append(" WHEN CHARACTER_MAXIMUM_LENGTH > 2147483647 THEN 2147483647");
            query.append(" ELSE CHARACTER_MAXIMUM_LENGTH END AS LENGTH, ");
            query.append("NUMERIC_SCALE AS `SCALE`, 10 AS RADIX, ");
            query.append(this.getFunctionConstant(FunctionConstant.FUNCTION_NULLABLE));
            query.append(" AS `NULLABLE`,  NULL AS `REMARKS`,");
            query.append(" CASE WHEN CHARACTER_OCTET_LENGTH > ");
            query.append(Integer.MAX_VALUE);
            query.append(" THEN ");
            query.append(Integer.MAX_VALUE);
            query.append(" ELSE CHARACTER_OCTET_LENGTH END AS `CHAR_OCTET_LENGTH`,");
            query.append(" ORDINAL_POSITION, 'YES' AS `IS_NULLABLE`,");
            query.append(" SPECIFIC_NAME FROM INFORMATION_SCHEMA.PARAMETERS WHERE");
            StringBuilder condition = new StringBuilder();
            if (dbFilter != null) {
                condition.append(dbMapsToSchema ? " SPECIFIC_SCHEMA LIKE ?" : " SPECIFIC_SCHEMA = ?");
            }
            if (functionNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(" SPECIFIC_NAME LIKE ?");
            }
            if (columnNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(" (PARAMETER_NAME LIKE ? OR PARAMETER_NAME IS NULL)");
            }
            if (condition.length() > 0) {
                condition.append(" AND");
            }
            condition.append(" ROUTINE_TYPE='FUNCTION'");
            query.append((CharSequence)condition);
            query.append(" ORDER BY SPECIFIC_SCHEMA, SPECIFIC_NAME, ORDINAL_POSITION");
            try (PreparedStatement pStmt = null;){
                pStmt = this.prepareMetaDataSafeStatement(query.toString());
                int nextId = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextId++, dbFilter);
                }
                if (functionNameFilter != null) {
                    pStmt.setString(nextId++, functionNameFilter);
                }
                if (columnNameFilter != null) {
                    pStmt.setString(nextId, columnNameFilter);
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createFunctionColumnsFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            if (!this.conn.getServerVersion().meetsMinimum(ServerVersion.parseVersion("8.0.11"))) {
                return super.getSQLKeywords();
            }
            String keywords = keywordsCache.get(this.conn.getServerVersion());
            if (keywords != null) {
                return keywords;
            }
            KEYWORDS_CACHE_LOCK.lock();
            try {
                keywords = keywordsCache.get(this.conn.getServerVersion());
                if (keywords != null) {
                    String string = keywords;
                    return string;
                }
                ArrayList<String> keywordsFromServer = new ArrayList<String>();
                Statement stmt = this.conn.getMetadataSafeStatement();
                ResultSet rs = stmt.executeQuery("SELECT WORD FROM INFORMATION_SCHEMA.KEYWORDS WHERE RESERVED=1 ORDER BY WORD");
                while (rs.next()) {
                    keywordsFromServer.add(rs.getString(1));
                }
                stmt.close();
                keywordsFromServer.removeAll(SQL2003_KEYWORDS);
                keywords = String.join((CharSequence)",", keywordsFromServer);
                keywordsCache.put(this.conn.getServerVersion(), keywords);
                String string = keywords;
                return string;
            }
            finally {
                KEYWORDS_CACHE_LOCK.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private final void appendJdbcTypeMappingQuery(StringBuilder buf, String mysqlTypeColumnName, String fullMysqlTypeColumnName) {
        buf.append("CASE ");
        block4: for (MysqlType mysqlType : MysqlType.values()) {
            buf.append(" WHEN UPPER(");
            buf.append(mysqlTypeColumnName);
            buf.append(")='");
            buf.append(mysqlType.getName());
            buf.append("' THEN ");
            switch (mysqlType) {
                case TINYINT: 
                case TINYINT_UNSIGNED: {
                    if (this.tinyInt1isBit) {
                        buf.append("CASE");
                        buf.append(" WHEN LOCATE('ZEROFILL', UPPER(");
                        buf.append(fullMysqlTypeColumnName);
                        buf.append(")) = 0 AND LOCATE('UNSIGNED', UPPER(");
                        buf.append(fullMysqlTypeColumnName);
                        buf.append(")) = 0 AND LOCATE('(1)', ");
                        buf.append(fullMysqlTypeColumnName);
                        buf.append(") != 0 THEN ");
                        buf.append(this.transformedBitIsBoolean ? "16" : "-7");
                        buf.append(" ELSE -6 END ");
                        continue block4;
                    }
                    buf.append(mysqlType.getJdbcType());
                    continue block4;
                }
                case YEAR: {
                    buf.append(this.yearIsDateType ? mysqlType.getJdbcType() : 5);
                    continue block4;
                }
                default: {
                    buf.append(mysqlType.getJdbcType());
                }
            }
        }
        buf.append(" WHEN UPPER(DATA_TYPE)='POINT' THEN -2");
        buf.append(" WHEN UPPER(DATA_TYPE)='LINESTRING' THEN -2");
        buf.append(" WHEN UPPER(DATA_TYPE)='POLYGON' THEN -2");
        buf.append(" WHEN UPPER(DATA_TYPE)='MULTIPOINT' THEN -2");
        buf.append(" WHEN UPPER(DATA_TYPE)='MULTILINESTRING' THEN -2");
        buf.append(" WHEN UPPER(DATA_TYPE)='MULTIPOLYGON' THEN -2");
        buf.append(" WHEN UPPER(DATA_TYPE)='GEOMETRYCOLLECTION' THEN -2");
        buf.append(" WHEN UPPER(DATA_TYPE)='GEOMCOLLECTION' THEN -2");
        buf.append(" ELSE 1111");
        buf.append(" END ");
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        try {
            return super.getSchemas();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        try {
            return super.getSchemas(catalog, schemaPattern);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            return super.getCatalogs();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            return super.getTablePrivileges(catalog, schemaPattern, tableNamePattern);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        try {
            return super.getBestRowIdentifier(catalog, schema, table, scope, nullable);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected static enum FunctionConstant {
        FUNCTION_COLUMN_UNKNOWN,
        FUNCTION_COLUMN_IN,
        FUNCTION_COLUMN_INOUT,
        FUNCTION_COLUMN_OUT,
        FUNCTION_COLUMN_RETURN,
        FUNCTION_COLUMN_RESULT,
        FUNCTION_NO_NULLS,
        FUNCTION_NULLABLE,
        FUNCTION_NULLABLE_UNKNOWN;

    }
}

