/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.datasource.processor;

import com.mybatisflex.core.datasource.processor.DataSourceProcessor;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Method;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpelExpressionDataSourceProcessor
implements DataSourceProcessor {
    private static final String DYNAMIC_PREFIX = "#";
    private static final ParameterNameDiscoverer NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private BeanResolver beanResolver;
    private ParserContext parserContext = new ParserContext(){

        public boolean isTemplate() {
            return false;
        }

        public String getExpressionPrefix() {
            return null;
        }

        public String getExpressionSuffix() {
            return null;
        }
    };

    public String process(String dataSourceKey, Object mapper, Method method, Object[] arguments) {
        if (StringUtil.noText((String)dataSourceKey)) {
            return null;
        }
        if (!dataSourceKey.startsWith(DYNAMIC_PREFIX)) {
            return null;
        }
        if (arguments.length == 0) {
            return null;
        }
        RootObject rootObject = new RootObject(method, arguments, mapper);
        MethodBasedEvaluationContext context = new MethodBasedEvaluationContext((Object)rootObject, method, arguments, NAME_DISCOVERER);
        context.setBeanResolver(this.beanResolver);
        Object value = PARSER.parseExpression(dataSourceKey, this.parserContext).getValue((EvaluationContext)context);
        return value == null ? null : value.toString();
    }

    public void setBeanResolver(BeanResolver beanResolver) {
        this.beanResolver = beanResolver;
    }

    public void setParserContext(ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    public static class RootObject {
        private final Method method;
        private final Object[] args;
        private final Object target;

        public RootObject(Method method, Object[] args, Object target) {
            this.method = method;
            this.args = args;
            this.target = target;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public Object getTarget() {
            return this.target;
        }
    }
}

